/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.iceberg.ColumnIdentity;
import com.facebook.presto.iceberg.TypeConverter;
import com.facebook.presto.spi.ColumnHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.types.Types;

public class IcebergColumnHandle
implements ColumnHandle {
    private final ColumnIdentity columnIdentity;
    private final Type type;
    private final Optional<String> comment;

    @JsonCreator
    public IcebergColumnHandle(@JsonProperty(value="columnIdentity") ColumnIdentity columnIdentity, @JsonProperty(value="type") Type type, @JsonProperty(value="comment") Optional<String> comment) {
        this.columnIdentity = Objects.requireNonNull(columnIdentity, "columnIdentity is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    @JsonProperty
    public ColumnIdentity getColumnIdentity() {
        return this.columnIdentity;
    }

    @JsonProperty
    public int getId() {
        return this.columnIdentity.getId();
    }

    @JsonProperty
    public String getName() {
        return this.columnIdentity.getName();
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public Optional<String> getComment() {
        return this.comment;
    }

    public int hashCode() {
        return Objects.hash(this.columnIdentity, this.type, this.comment);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IcebergColumnHandle other = (IcebergColumnHandle)obj;
        return Objects.equals(this.columnIdentity, other.columnIdentity) && Objects.equals(this.type, other.type) && Objects.equals(this.comment, other.comment);
    }

    public String toString() {
        return this.getId() + ":" + this.getName() + ":" + this.type.getDisplayName();
    }

    public static IcebergColumnHandle primitiveIcebergColumnHandle(int id, String name, Type type, Optional<String> comment) {
        return new IcebergColumnHandle(ColumnIdentity.primitiveColumnIdentity(id, name), type, comment);
    }

    public static IcebergColumnHandle create(Types.NestedField column, TypeManager typeManager) {
        return new IcebergColumnHandle(ColumnIdentity.createColumnIdentity(column), TypeConverter.toPrestoType(column.type(), typeManager), Optional.ofNullable(column.doc()));
    }
}

