/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.ColumnConverterProvider;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveColumnConverterProvider;
import com.facebook.presto.hive.TableAlreadyExistsException;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.iceberg.CommitTaskData;
import com.facebook.presto.iceberg.HiveTableOperations;
import com.facebook.presto.iceberg.IcebergAbstractMetadata;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.IcebergSchemaProperties;
import com.facebook.presto.iceberg.IcebergTableHandle;
import com.facebook.presto.iceberg.IcebergTableName;
import com.facebook.presto.iceberg.IcebergTableProperties;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.iceberg.IcebergWritableTableHandle;
import com.facebook.presto.iceberg.PartitionFields;
import com.facebook.presto.iceberg.TableStatisticsMaker;
import com.facebook.presto.iceberg.TableType;
import com.facebook.presto.iceberg.TypeConverter;
import com.facebook.presto.iceberg.UnknownTableTypeException;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.security.PrincipalType;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transactions;

public class IcebergHiveMetadata
extends IcebergAbstractMetadata {
    private final ExtendedHiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;

    public IcebergHiveMetadata(ExtendedHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, TypeManager typeManager, JsonCodec<CommitTaskData> commitTaskCodec) {
        super(typeManager, commitTaskCodec);
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);
        return this.metastore.getAllDatabases(metastoreContext);
    }

    public IcebergTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        IcebergTableName name = IcebergTableName.from(tableName.getTableName());
        Verify.verify((name.getTableType() == TableType.DATA ? 1 : 0) != 0, (String)("Wrong table type: " + (Object)((Object)name.getTableType())), (Object[])new Object[0]);
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);
        Optional hiveTable = this.metastore.getTable(metastoreContext, tableName.getSchemaName(), name.getTableName());
        if (!hiveTable.isPresent()) {
            return null;
        }
        if (!IcebergUtil.isIcebergTable((com.facebook.presto.hive.metastore.Table)hiveTable.get())) {
            throw new UnknownTableTypeException(tableName);
        }
        Table table = IcebergUtil.getHiveIcebergTable(this.metastore, this.hdfsEnvironment, session, tableName);
        Optional<Long> snapshotId = this.getSnapshotId(table, name.getSnapshotId());
        return new IcebergTableHandle(tableName.getSchemaName(), name.getTableName(), name.getTableType(), snapshotId, (TupleDomain<IcebergColumnHandle>)TupleDomain.all());
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        return this.getRawSystemTable(session, tableName);
    }

    private Optional<SystemTable> getRawSystemTable(ConnectorSession session, SchemaTableName tableName) {
        IcebergTableName name = IcebergTableName.from(tableName.getTableName());
        if (name.getTableType() == TableType.DATA) {
            return Optional.empty();
        }
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);
        Optional hiveTable = this.metastore.getTable(metastoreContext, tableName.getSchemaName(), name.getTableName());
        if (!hiveTable.isPresent() || !IcebergUtil.isIcebergTable((com.facebook.presto.hive.metastore.Table)hiveTable.get())) {
            return Optional.empty();
        }
        Table table = IcebergUtil.getHiveIcebergTable(this.metastore, this.hdfsEnvironment, session, new SchemaTableName(tableName.getSchemaName(), name.getTableName()));
        return this.getIcebergSystemTable(tableName, table);
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);
        return this.metastore.getAllTables(metastoreContext, schemaName.get()).orElseGet(() -> this.metastore.getAllDatabases(metastoreContext)).stream().map(table -> new SchemaTableName((String)schemaName.get(), table)).collect(Collectors.toList());
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Table icebergTable = IcebergUtil.getHiveIcebergTable(this.metastore, this.hdfsEnvironment, session, table.getSchemaTableName());
        return (Map)IcebergUtil.getColumns(icebergTable.schema(), this.typeManager).stream().collect(ImmutableMap.toImmutableMap(IcebergColumnHandle::getName, Function.identity()));
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties) {
        Optional<String> location = IcebergSchemaProperties.getSchemaLocation(properties).map(uri -> {
            try {
                this.hdfsEnvironment.getFileSystem(new HdfsContext(session, schemaName), new Path(uri));
            }
            catch (IOException | IllegalArgumentException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SCHEMA_PROPERTY, "Invalid location URI: " + uri, (Throwable)e);
            }
            return uri;
        });
        Database database = Database.builder().setDatabaseName(schemaName).setLocation(location).setOwnerType(PrincipalType.USER).setOwnerName(session.getUser()).build();
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);
        this.metastore.createDatabase(metastoreContext, database);
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        if (!this.listTables(session, Optional.of(schemaName)).isEmpty() || !this.listViews(session, Optional.of(schemaName)).isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_EMPTY, "Schema not empty: " + schemaName);
        }
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);
        this.metastore.dropDatabase(metastoreContext, schemaName);
    }

    public void renameSchema(ConnectorSession session, String source, String target) {
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);
        this.metastore.renameDatabase(metastoreContext, source, target);
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        HiveTableOperations operations;
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Schema schema = IcebergHiveMetadata.toIcebergSchema(tableMetadata.getColumns());
        PartitionSpec partitionSpec = PartitionFields.parsePartitionFields(schema, IcebergTableProperties.getPartitioning(tableMetadata.getProperties()));
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);
        Database database = (Database)this.metastore.getDatabase(metastoreContext, schemaName).orElseThrow(() -> new SchemaNotFoundException(schemaName));
        HdfsContext hdfsContext = new HdfsContext(session, schemaName, tableName);
        String targetPath = IcebergTableProperties.getTableLocation(tableMetadata.getProperties());
        if (targetPath == null) {
            Optional location = database.getLocation();
            if (!location.isPresent() || ((String)location.get()).isEmpty()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Database " + schemaName + " location is not set");
            }
            Path databasePath = new Path((String)location.get());
            Path resultPath = new Path(databasePath, tableName);
            targetPath = resultPath.toString();
        }
        if ((operations = new HiveTableOperations(this.metastore, new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER), this.hdfsEnvironment, hdfsContext, schemaName, tableName, session.getUser(), targetPath)).current() != null) {
            throw new TableAlreadyExistsException(schemaTableName);
        }
        ImmutableMap.Builder propertiesBuilder = ImmutableMap.builderWithExpectedSize((int)2);
        FileFormat fileFormat = IcebergTableProperties.getFileFormat(tableMetadata.getProperties());
        propertiesBuilder.put((Object)"write.format.default", (Object)fileFormat.toString());
        if (tableMetadata.getComment().isPresent()) {
            propertiesBuilder.put((Object)"comment", tableMetadata.getComment().get());
        }
        TableMetadata metadata = TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)partitionSpec, (String)targetPath, (Map)propertiesBuilder.build());
        this.transaction = Transactions.createTableTransaction((String)tableName, (TableOperations)operations, (TableMetadata)metadata);
        return new IcebergWritableTableHandle(schemaName, tableName, SchemaParser.toJson((Schema)metadata.schema()), PartitionSpecParser.toJson((PartitionSpec)metadata.spec()), IcebergUtil.getColumns(metadata.schema(), this.typeManager), targetPath, fileFormat, metadata.properties());
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Table icebergTable = IcebergUtil.getHiveIcebergTable(this.metastore, this.hdfsEnvironment, session, table.getSchemaTableName());
        return this.beginIcebergTableInsert(table, icebergTable);
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        Table table = IcebergUtil.getHiveIcebergTable(this.metastore, this.hdfsEnvironment, session, handle.getSchemaTableName());
        if (table.properties().containsKey("write.object-storage.path") || table.properties().containsKey("write.folder-storage.path") || table.properties().containsKey("write.metadata.path") || table.properties().containsKey("write.data.path")) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table " + handle.getSchemaTableName() + " contains Iceberg path override properties and cannot be dropped from Presto");
        }
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);
        this.metastore.dropTable(metastoreContext, handle.getSchemaName(), handle.getTableName(), true);
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTable) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);
        this.metastore.renameTable(metastoreContext, handle.getSchemaName(), handle.getTableName(), newTable.getSchemaName(), newTable.getTableName());
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        Table icebergTable = IcebergUtil.getHiveIcebergTable(this.metastore, this.hdfsEnvironment, session, handle.getSchemaTableName());
        icebergTable.updateSchema().addColumn(column.getName(), TypeConverter.toIcebergType(column.getType()), column.getComment()).commit();
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        IcebergTableHandle icebergTableHandle = (IcebergTableHandle)tableHandle;
        IcebergColumnHandle handle = (IcebergColumnHandle)column;
        Table icebergTable = IcebergUtil.getHiveIcebergTable(this.metastore, this.hdfsEnvironment, session, icebergTableHandle.getSchemaTableName());
        icebergTable.updateSchema().deleteColumn(handle.getName()).commit();
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        IcebergTableHandle icebergTableHandle = (IcebergTableHandle)tableHandle;
        IcebergColumnHandle columnHandle = (IcebergColumnHandle)source;
        Table icebergTable = IcebergUtil.getHiveIcebergTable(this.metastore, this.hdfsEnvironment, session, icebergTableHandle.getSchemaTableName());
        icebergTable.updateSchema().renameColumn(columnHandle.getName(), target).commit();
    }

    @Override
    protected ConnectorTableMetadata getTableMetadata(ConnectorSession session, SchemaTableName table) {
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);
        if (!this.metastore.getTable(metastoreContext, table.getSchemaName(), table.getTableName()).isPresent()) {
            throw new TableNotFoundException(table);
        }
        Table icebergTable = IcebergUtil.getHiveIcebergTable(this.metastore, this.hdfsEnvironment, session, table);
        List<ColumnMetadata> columns = this.getColumnMetadatas(icebergTable);
        return new ConnectorTableMetadata(table, columns, this.createMetadataProperties(icebergTable), IcebergUtil.getTableComment(icebergTable));
    }

    public ExtendedHiveMetastore getMetastore() {
        return this.metastore;
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<ConnectorTableLayoutHandle> tableLayoutHandle, List<ColumnHandle> columnHandles, Constraint<ColumnHandle> constraint) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        Table icebergTable = IcebergUtil.getHiveIcebergTable(this.metastore, this.hdfsEnvironment, session, handle.getSchemaTableName());
        return TableStatisticsMaker.getTableStatistics(this.typeManager, constraint, handle, icebergTable);
    }

    private Optional<Long> getSnapshotId(Table table, Optional<Long> snapshotId) {
        if (snapshotId.isPresent()) {
            return Optional.of(IcebergUtil.resolveSnapshotId(table, snapshotId.get()));
        }
        return Optional.ofNullable(table.currentSnapshot()).map(Snapshot::snapshotId);
    }
}

