/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.io.DataSink;
import com.facebook.presto.hive.OrcFileWriter;
import com.facebook.presto.iceberg.IcebergFileWriter;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfWriterEncryption;
import com.facebook.presto.orc.NoOpOrcWriterStats;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.WriterStats;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DateStatistics;
import com.facebook.presto.orc.metadata.statistics.DecimalStatistics;
import com.facebook.presto.orc.metadata.statistics.DoubleStatistics;
import com.facebook.presto.orc.metadata.statistics.IntegerStatistics;
import com.facebook.presto.orc.metadata.statistics.StringStatistics;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.joda.time.DateTimeZone;

public class IcebergOrcFileWriter
extends OrcFileWriter
implements IcebergFileWriter {
    private final Schema icebergSchema;
    private final List<OrcType> orcColumn;

    public IcebergOrcFileWriter(Schema icebergSchema, DataSink dataSink, Callable<Void> rollbackAction, OrcEncoding orcEncoding, List<String> columnNames, List<com.facebook.presto.common.type.Type> fileColumnTypes, List<OrcType> fileColumnOrcTypes, CompressionKind compression, OrcWriterOptions options, int[] fileInputColumnIndexes, Map<String, String> metadata, DateTimeZone hiveStorageTimeZone, Optional<Supplier<OrcDataSource>> validationInputFactory, OrcWriteValidation.OrcWriteValidationMode validationMode, NoOpOrcWriterStats stats, DwrfEncryptionProvider dwrfEncryptionProvider, Optional<DwrfWriterEncryption> dwrfWriterEncryption) {
        super(dataSink, rollbackAction, orcEncoding, columnNames, fileColumnTypes, Optional.ofNullable(fileColumnOrcTypes), compression, options, fileInputColumnIndexes, metadata, hiveStorageTimeZone, validationInputFactory, validationMode, (WriterStats)stats, dwrfEncryptionProvider, dwrfWriterEncryption);
        this.icebergSchema = Objects.requireNonNull(icebergSchema, "icebergSchema is null");
        this.orcColumn = fileColumnOrcTypes;
    }

    @Override
    public Metrics getMetrics() {
        return IcebergOrcFileWriter.computeMetrics(this.icebergSchema, this.orcColumn, this.orcWriter.getFileRowCount(), this.orcWriter.getFileStats());
    }

    private static Metrics computeMetrics(Schema icebergSchema, List<OrcType> orcRowTypes, long fileRowCount, List<ColumnStatistics> columnStatistics) {
        if (columnStatistics.isEmpty()) {
            return new Metrics(Long.valueOf(fileRowCount), null, null, null, null, null, null);
        }
        Set<Integer> excludedColumns = IcebergOrcFileWriter.getExcludedColumns(orcRowTypes);
        ImmutableMap.Builder valueCountsBuilder = ImmutableMap.builder();
        ImmutableMap.Builder nullCountsBuilder = ImmutableMap.builder();
        ImmutableMap.Builder lowerBoundsBuilder = ImmutableMap.builder();
        ImmutableMap.Builder upperBoundsBuilder = ImmutableMap.builder();
        for (int i = 1; i < orcRowTypes.size(); ++i) {
            if (excludedColumns.contains(i)) continue;
            OrcType orcColumn = orcRowTypes.get(i);
            ColumnStatistics orcColumnStats = columnStatistics.get(i);
            int icebergId = IcebergOrcFileWriter.getIcebergId(orcColumn);
            Types.NestedField icebergField = icebergSchema.findField(icebergId);
            Verify.verify((icebergField != null ? 1 : 0) != 0, (String)"Cannot find Iceberg column with ID %s in schema %s", (int)icebergId, (Object)icebergSchema);
            valueCountsBuilder.put((Object)icebergId, (Object)fileRowCount);
            if (orcColumnStats.hasNumberOfValues()) {
                nullCountsBuilder.put((Object)icebergId, (Object)(fileRowCount - orcColumnStats.getNumberOfValues()));
            }
            IcebergOrcFileWriter.toIcebergMinMax(orcColumnStats, icebergField.type()).ifPresent(minMax -> {
                lowerBoundsBuilder.put((Object)icebergId, (Object)minMax.getMin());
                upperBoundsBuilder.put((Object)icebergId, (Object)minMax.getMax());
            });
        }
        ImmutableMap valueCounts = valueCountsBuilder.build();
        ImmutableMap nullCounts = nullCountsBuilder.build();
        ImmutableMap lowerBounds = lowerBoundsBuilder.build();
        ImmutableMap upperBounds = upperBoundsBuilder.build();
        return new Metrics(Long.valueOf(fileRowCount), null, (Map)(valueCounts.isEmpty() ? null : valueCounts), (Map)(nullCounts.isEmpty() ? null : nullCounts), null, (Map)(lowerBounds.isEmpty() ? null : lowerBounds), (Map)(upperBounds.isEmpty() ? null : upperBounds));
    }

    private static Set<Integer> getExcludedColumns(List<OrcType> orcRowTypes) {
        ImmutableSet.Builder excludedColumns = ImmutableSet.builder();
        IcebergOrcFileWriter.populateExcludedColumns(orcRowTypes, 0, false, (ImmutableSet.Builder<Integer>)excludedColumns);
        return excludedColumns.build();
    }

    private static void populateExcludedColumns(List<OrcType> orcRowTypes, int orcColumnId, boolean exclude, ImmutableSet.Builder<Integer> excludedColumns) {
        if (exclude) {
            excludedColumns.add((Object)orcColumnId);
        }
        OrcType orcColumn = orcRowTypes.get(orcColumnId);
        switch (orcColumn.getOrcTypeKind()) {
            case LIST: 
            case MAP: {
                for (Integer child : orcColumn.getFieldTypeIndexes()) {
                    IcebergOrcFileWriter.populateExcludedColumns(orcRowTypes, child, true, excludedColumns);
                }
                return;
            }
            case STRUCT: {
                for (Integer child : orcColumn.getFieldTypeIndexes()) {
                    IcebergOrcFileWriter.populateExcludedColumns(orcRowTypes, child, exclude, excludedColumns);
                }
                return;
            }
        }
    }

    private static int getIcebergId(OrcType orcColumn) {
        String icebergId = (String)orcColumn.getAttributes().get("iceberg.id");
        Verify.verify((icebergId != null ? 1 : 0) != 0, (String)"ORC column %s doesn't have an associated Iceberg ID", (Object)orcColumn);
        return Integer.parseInt(icebergId);
    }

    private static Optional<IcebergMinMax> toIcebergMinMax(ColumnStatistics orcColumnStats, Type icebergType) {
        IntegerStatistics integerStatistics = orcColumnStats.getIntegerStatistics();
        if (integerStatistics != null) {
            Number min = integerStatistics.getMin();
            Number max = integerStatistics.getMax();
            if (min == null || max == null) {
                return Optional.empty();
            }
            if (icebergType.typeId() == Type.TypeID.INTEGER) {
                min = Math.toIntExact(min);
                max = Math.toIntExact(max);
            }
            return Optional.of(new IcebergMinMax(icebergType, min, max));
        }
        DoubleStatistics doubleStatistics = orcColumnStats.getDoubleStatistics();
        if (doubleStatistics != null) {
            Number min = doubleStatistics.getMin();
            Number max = doubleStatistics.getMax();
            if (min == null || max == null) {
                return Optional.empty();
            }
            if (icebergType.typeId() == Type.TypeID.FLOAT) {
                min = Float.valueOf(min.floatValue());
                max = Float.valueOf(max.floatValue());
            }
            return Optional.of(new IcebergMinMax(icebergType, min, max));
        }
        StringStatistics stringStatistics = orcColumnStats.getStringStatistics();
        if (stringStatistics != null) {
            Slice min = stringStatistics.getMin();
            Slice max = stringStatistics.getMax();
            if (min == null || max == null) {
                return Optional.empty();
            }
            return Optional.of(new IcebergMinMax(icebergType, min.toStringUtf8(), max.toStringUtf8()));
        }
        DateStatistics dateStatistics = orcColumnStats.getDateStatistics();
        if (dateStatistics != null) {
            Integer min = dateStatistics.getMin();
            Integer max = dateStatistics.getMax();
            if (min == null || max == null) {
                return Optional.empty();
            }
            return Optional.of(new IcebergMinMax(icebergType, min, max));
        }
        DecimalStatistics decimalStatistics = orcColumnStats.getDecimalStatistics();
        if (decimalStatistics != null) {
            BigDecimal min = decimalStatistics.getMin();
            BigDecimal max = decimalStatistics.getMax();
            if (min == null || max == null) {
                return Optional.empty();
            }
            min = min.setScale(((Types.DecimalType)icebergType).scale());
            max = max.setScale(((Types.DecimalType)icebergType).scale());
            return Optional.of(new IcebergMinMax(icebergType, min, max));
        }
        return Optional.empty();
    }

    private static class IcebergMinMax {
        private ByteBuffer min;
        private ByteBuffer max;

        private IcebergMinMax(Type type, Object min, Object max) {
            this.min = Conversions.toByteBuffer((Type)type, (Object)min);
            this.max = Conversions.toByteBuffer((Type)type, (Object)max);
        }

        public ByteBuffer getMin() {
            return this.min;
        }

        public ByteBuffer getMax() {
            return this.max;
        }
    }
}

