/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.iceberg.CommitTaskData;
import com.facebook.presto.iceberg.IcebergFileWriterFactory;
import com.facebook.presto.iceberg.IcebergPageSink;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.iceberg.IcebergWritableTableHandle;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PageIndexerFactory;
import com.facebook.presto.spi.PageSinkContext;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.io.LocationProvider;

public class IcebergPageSinkProvider
implements ConnectorPageSinkProvider {
    private final HdfsEnvironment hdfsEnvironment;
    private final JsonCodec<CommitTaskData> jsonCodec;
    private final IcebergFileWriterFactory fileWriterFactory;
    private final PageIndexerFactory pageIndexerFactory;

    @Inject
    public IcebergPageSinkProvider(HdfsEnvironment hdfsEnvironment, JsonCodec<CommitTaskData> jsonCodec, IcebergFileWriterFactory fileWriterFactory, PageIndexerFactory pageIndexerFactory) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.jsonCodec = Objects.requireNonNull(jsonCodec, "jsonCodec is null");
        this.fileWriterFactory = Objects.requireNonNull(fileWriterFactory, "fileWriterFactory is null");
        this.pageIndexerFactory = Objects.requireNonNull(pageIndexerFactory, "pageIndexerFactory is null");
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle, PageSinkContext pageSinkContext) {
        return this.createPageSink(session, (IcebergWritableTableHandle)outputTableHandle);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle, PageSinkContext pageSinkContext) {
        return this.createPageSink(session, (IcebergWritableTableHandle)insertTableHandle);
    }

    private ConnectorPageSink createPageSink(ConnectorSession session, IcebergWritableTableHandle tableHandle) {
        HdfsContext hdfsContext = new HdfsContext(session, tableHandle.getSchemaName(), tableHandle.getTableName());
        Schema schema = SchemaParser.fromJson((String)tableHandle.getSchemaAsJson());
        PartitionSpec partitionSpec = PartitionSpecParser.fromJson((Schema)schema, (String)tableHandle.getPartitionSpecAsJson());
        LocationProvider locationProvider = IcebergUtil.getLocationProvider(new SchemaTableName(tableHandle.getSchemaName(), tableHandle.getTableName()), tableHandle.getOutputPath(), tableHandle.getStorageProperties());
        return new IcebergPageSink(schema, partitionSpec, locationProvider, this.fileWriterFactory, this.pageIndexerFactory, this.hdfsEnvironment, hdfsContext, tableHandle.getInputColumns(), this.jsonCodec, session, tableHandle.getFileFormat());
    }
}

