/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.iceberg.CatalogType;
import com.facebook.presto.iceberg.IcebergCatalogName;
import com.facebook.presto.iceberg.IcebergConfig;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.security.ConnectorIdentity;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.SupportsNamespaces;

public class IcebergResourceFactory {
    private final Cache<String, Catalog> catalogCache;
    private final String catalogName;
    private final CatalogType catalogType;
    private final String catalogWarehouse;
    private final List<String> hadoopConfigResources;

    @Inject
    public IcebergResourceFactory(IcebergConfig config, IcebergCatalogName catalogName) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null").getCatalogName();
        Objects.requireNonNull(config, "config is null");
        this.catalogType = config.getCatalogType();
        this.catalogWarehouse = config.getCatalogWarehouse();
        this.hadoopConfigResources = config.getHadoopConfigResources();
        this.catalogCache = CacheBuilder.newBuilder().maximumSize((long)config.getCatalogCacheSize()).build();
    }

    public Catalog getCatalog(ConnectorSession session) {
        try {
            return (Catalog)this.catalogCache.get((Object)this.getCatalogCacheKey(session), () -> CatalogUtil.loadCatalog((String)this.catalogType.getCatalogImpl(), (String)this.catalogName, this.getCatalogProperties(session), (Object)this.getHadoopConfiguration(session)));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new UncheckedExecutionException(e);
        }
    }

    public SupportsNamespaces getNamespaces(ConnectorSession session) {
        Catalog catalog = this.getCatalog(session);
        if (catalog instanceof SupportsNamespaces) {
            return (SupportsNamespaces)catalog;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Iceberg catalog of type " + (Object)((Object)this.catalogType) + " does not support namespace operations");
    }

    private String getCatalogCacheKey(ConnectorSession session) {
        StringBuilder sb = new StringBuilder();
        ConnectorIdentity identity = session.getIdentity();
        sb.append("User:");
        sb.append(identity.getUser());
        if (identity.getPrincipal().isPresent()) {
            sb.append(",Principle:");
            sb.append(identity.getPrincipal().toString());
        }
        if (identity.getRole().isPresent()) {
            sb.append(",Role:");
            sb.append(identity.getRole());
        }
        if (identity.getExtraCredentials() != null) {
            identity.getExtraCredentials().forEach((key, value) -> {
                sb.append(",");
                sb.append((String)key);
                sb.append(":");
                sb.append((String)value);
            });
        }
        return sb.toString();
    }

    private Configuration getHadoopConfiguration(ConnectorSession session) {
        Configuration configuration = new Configuration(false);
        if (this.hadoopConfigResources.isEmpty()) {
            configuration.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
            configuration.set("fs.file.impl", LocalFileSystem.class.getName());
        }
        for (String resourcePath : this.hadoopConfigResources) {
            Configuration resourceProperties = new Configuration(false);
            resourceProperties.addResource(new Path(resourcePath));
            for (Map.Entry entry : resourceProperties) {
                configuration.set((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return configuration;
    }

    public Map<String, String> getCatalogProperties(ConnectorSession session) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (this.catalogWarehouse != null) {
            properties.put("warehouse", this.catalogWarehouse);
        }
        return properties;
    }
}

