/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class IcebergTransactionManager {
    private final Map<ConnectorTransactionHandle, ConnectorMetadata> transactions = new ConcurrentHashMap<ConnectorTransactionHandle, ConnectorMetadata>();

    public ConnectorMetadata get(ConnectorTransactionHandle transaction) {
        ConnectorMetadata metadata = this.transactions.get(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        return metadata;
    }

    public ConnectorMetadata remove(ConnectorTransactionHandle transaction) {
        ConnectorMetadata metadata = this.transactions.remove(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        return metadata;
    }

    public void put(ConnectorTransactionHandle transaction, ConnectorMetadata metadata) {
        ConnectorMetadata existing = this.transactions.putIfAbsent(transaction, metadata);
        Preconditions.checkState((existing == null ? 1 : 0) != 0, (String)"transaction already exists: %s", (Object)existing);
    }
}

