/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

class Partition {
    private final Map<Integer, Type.PrimitiveType> idToTypeMapping;
    private final List<Types.NestedField> nonPartitionPrimitiveColumns;
    private final StructLike values;
    private long recordCount;
    private long fileCount;
    private long size;
    private final Map<Integer, Object> minValues;
    private final Map<Integer, Object> maxValues;
    private final Map<Integer, Long> nullCounts;
    private final Map<Integer, Long> columnSizes;
    private final Set<Integer> corruptedStats;
    private boolean hasValidColumnMetrics;

    public Partition(Map<Integer, Type.PrimitiveType> idToTypeMapping, List<Types.NestedField> nonPartitionPrimitiveColumns, StructLike values, long recordCount, long size, Map<Integer, Object> minValues, Map<Integer, Object> maxValues, Map<Integer, Long> nullCounts, Map<Integer, Long> columnSizes) {
        this.idToTypeMapping = ImmutableMap.copyOf(Objects.requireNonNull(idToTypeMapping, "idToTypeMapping is null"));
        this.nonPartitionPrimitiveColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(nonPartitionPrimitiveColumns, "nonPartitionPrimitiveColumns is null"));
        this.values = Objects.requireNonNull(values, "values is null");
        this.recordCount = recordCount;
        this.fileCount = 1L;
        this.size = size;
        if (minValues == null || maxValues == null || nullCounts == null) {
            this.minValues = null;
            this.maxValues = null;
            this.nullCounts = null;
            this.columnSizes = null;
            this.corruptedStats = null;
        } else {
            this.minValues = new HashMap<Integer, Object>(minValues);
            this.maxValues = new HashMap<Integer, Object>(maxValues);
            this.corruptedStats = nonPartitionPrimitiveColumns.stream().map(Types.NestedField::fieldId).filter(id -> !minValues.containsKey(id) && (!nullCounts.containsKey(id) || (Long)nullCounts.get(id) != recordCount)).collect(Collectors.toSet());
            this.nullCounts = new HashMap<Integer, Long>(nullCounts);
            this.columnSizes = columnSizes != null ? new HashMap<Integer, Long>(columnSizes) : null;
            this.hasValidColumnMetrics = true;
        }
    }

    public Map<Integer, Type.PrimitiveType> getIdToTypeMapping() {
        return this.idToTypeMapping;
    }

    public List<Types.NestedField> getNonPartitionPrimitiveColumns() {
        return this.nonPartitionPrimitiveColumns;
    }

    public StructLike getValues() {
        return this.values;
    }

    public long getRecordCount() {
        return this.recordCount;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public long getSize() {
        return this.size;
    }

    public Map<Integer, Object> getMinValues() {
        return this.minValues;
    }

    public Map<Integer, Object> getMaxValues() {
        return this.maxValues;
    }

    public Map<Integer, Long> getNullCounts() {
        return this.nullCounts;
    }

    public Map<Integer, Long> getColumnSizes() {
        return this.columnSizes;
    }

    public Set<Integer> getCorruptedStats() {
        return this.corruptedStats;
    }

    public boolean hasValidColumnMetrics() {
        return this.hasValidColumnMetrics;
    }

    public void incrementRecordCount(long count) {
        this.recordCount += count;
    }

    public void incrementFileCount() {
        ++this.fileCount;
    }

    public void incrementSize(long numberOfBytes) {
        this.size += numberOfBytes;
    }

    public void updateMin(Map<Integer, Object> lowerBounds, Map<Integer, Long> nullCounts, long recordCount) {
        this.updateStats(this.minValues, lowerBounds, nullCounts, recordCount, i -> i > 0);
    }

    public void updateMax(Map<Integer, Object> upperBounds, Map<Integer, Long> nullCounts, long recordCount) {
        this.updateStats(this.maxValues, upperBounds, nullCounts, recordCount, i -> i < 0);
    }

    public void updateStats(Map<Integer, Object> current, Map<Integer, Object> newStat, Map<Integer, Long> nullCounts, long recordCount, Predicate<Integer> predicate) {
        if (!this.hasValidColumnMetrics) {
            return;
        }
        if (newStat == null || nullCounts == null) {
            this.hasValidColumnMetrics = false;
            return;
        }
        for (Types.NestedField column : this.nonPartitionPrimitiveColumns) {
            Comparator comparator;
            int id = column.fieldId();
            if (this.corruptedStats.contains(id)) continue;
            Object newValue = newStat.get(id);
            if (newValue == null) {
                Long nullCount = nullCounts.get(id);
                if (nullCount != null && nullCount == recordCount) continue;
                current.remove(id);
                this.corruptedStats.add(id);
                continue;
            }
            Object oldValue = current.putIfAbsent(id, newValue);
            if (oldValue == null || !predicate.test((comparator = Comparators.forType((Type.PrimitiveType)this.idToTypeMapping.get(id))).compare(oldValue, newValue))) continue;
            current.put(id, newValue);
        }
    }

    public void updateNullCount(Map<Integer, Long> nullCounts) {
        if (!this.hasValidColumnMetrics) {
            return;
        }
        if (nullCounts == null) {
            this.hasValidColumnMetrics = false;
            return;
        }
        nullCounts.forEach((key, counts) -> this.nullCounts.merge((Integer)key, (Long)counts, Long::sum));
    }

    public static Map<Integer, Object> toMap(Map<Integer, Type.PrimitiveType> idToTypeMapping, Map<Integer, ByteBuffer> idToMetricMap) {
        if (idToMetricMap == null) {
            return null;
        }
        ImmutableMap.Builder map = ImmutableMap.builder();
        idToMetricMap.forEach((id, value) -> {
            Type.PrimitiveType type = (Type.PrimitiveType)idToTypeMapping.get(id);
            map.put(id, Conversions.fromByteBuffer((Type)type, (ByteBuffer)value));
        });
        return map.build();
    }
}

