/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.iceberg.util.PageListBuilder;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.FixedPageSource;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iceberg.Table;

public class SnapshotsTable
implements SystemTable {
    private final ConnectorTableMetadata tableMetadata;
    private final Table icebergTable;

    public SnapshotsTable(SchemaTableName tableName, TypeManager typeManager, Table icebergTable) {
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.icebergTable = Objects.requireNonNull(icebergTable, "icebergTable is null");
        this.tableMetadata = new ConnectorTableMetadata(Objects.requireNonNull(tableName, "tableName is null"), (List)ImmutableList.builder().add((Object)new ColumnMetadata("committed_at", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)).add((Object)new ColumnMetadata("snapshot_id", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("parent_id", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("operation", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("manifest_list", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("summary", typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)VarcharType.VARCHAR.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)VarcharType.VARCHAR.getTypeSignature()))))).build());
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        return new FixedPageSource(SnapshotsTable.buildPages(this.tableMetadata, session, this.icebergTable));
    }

    private static List<Page> buildPages(ConnectorTableMetadata tableMetadata, ConnectorSession session, Table icebergTable) {
        PageListBuilder pagesBuilder = PageListBuilder.forTable(tableMetadata);
        icebergTable.snapshots().forEach(snapshot -> {
            pagesBuilder.beginRow();
            pagesBuilder.appendTimestampTzMillis(snapshot.timestampMillis(), session.getSqlFunctionProperties().getTimeZoneKey());
            pagesBuilder.appendBigint(snapshot.snapshotId());
            if (SnapshotsTable.checkNonNull(snapshot.parentId(), pagesBuilder)) {
                pagesBuilder.appendBigint(snapshot.parentId());
            }
            if (SnapshotsTable.checkNonNull(snapshot.operation(), pagesBuilder)) {
                pagesBuilder.appendVarchar(snapshot.operation());
            }
            if (SnapshotsTable.checkNonNull(snapshot.manifestListLocation(), pagesBuilder)) {
                pagesBuilder.appendVarchar(snapshot.manifestListLocation());
            }
            if (SnapshotsTable.checkNonNull(snapshot.summary(), pagesBuilder)) {
                pagesBuilder.appendVarcharVarcharMap(snapshot.summary());
            }
            pagesBuilder.endRow();
        });
        return pagesBuilder.build();
    }

    private static boolean checkNonNull(Object object, PageListBuilder pagesBuilder) {
        if (object == null) {
            pagesBuilder.appendNull();
            return false;
        }
        return true;
    }
}

