/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg.util;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class PrimitiveTypeMapBuilder {
    private final ImmutableMap.Builder<List<String>, Type> builder = ImmutableMap.builder();

    private PrimitiveTypeMapBuilder() {
    }

    public static Map<List<String>, Type> makeTypeMap(List<Type> types, List<String> columnNames) {
        return new PrimitiveTypeMapBuilder().buildTypeMap(types, columnNames);
    }

    private Map<List<String>, Type> buildTypeMap(List<Type> types, List<String> columnNames) {
        for (int i = 0; i < types.size(); ++i) {
            this.visitType(types.get(i), columnNames.get(i), (List<String>)ImmutableList.of());
        }
        return this.builder.build();
    }

    private void visitType(Type type, String name, List<String> parent) {
        if ("row".equals(type.getTypeSignature().getBase())) {
            this.visitRowType((RowType)type, name, parent);
        } else if ("map".equals(type.getTypeSignature().getBase())) {
            this.visitMapType((MapType)type, name, parent);
        } else if ("array".equals(type.getTypeSignature().getBase())) {
            this.visitArrayType((ArrayType)type, name, parent);
        } else {
            this.builder.put((Object)ImmutableList.builder().addAll(parent).add((Object)name).build(), (Object)type);
        }
    }

    private void visitArrayType(ArrayType type, String name, List<String> parent) {
        parent = ImmutableList.builder().addAll(parent).add((Object)name).add((Object)"list").build();
        this.visitType(type.getElementType(), "element", (List<String>)parent);
    }

    private void visitMapType(MapType type, String name, List<String> parent) {
        parent = ImmutableList.builder().addAll(parent).add((Object)name).add((Object)"map").build();
        this.visitType(type.getKeyType(), "key", (List<String>)parent);
        this.visitType(type.getValueType(), "value", (List<String>)parent);
    }

    private void visitRowType(RowType type, String name, List<String> parent) {
        parent = ImmutableList.builder().addAll(parent).add((Object)name).build();
        for (RowType.Field field : type.getFields()) {
            Preconditions.checkArgument((boolean)field.getName().isPresent(), (Object)"field in struct type doesn't have name");
            this.visitType(field.getType(), (String)field.getName().get(), (List<String>)parent);
        }
    }
}

