/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.password.file;

import com.facebook.airlift.http.server.BasicPrincipal;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.password.file.FileConfig;
import com.facebook.presto.password.file.PasswordStore;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.PasswordAuthenticator;
import com.google.common.base.Suppliers;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.Principal;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.inject.Inject;

public class FileAuthenticator
implements PasswordAuthenticator {
    private static final Logger log = Logger.get(FileAuthenticator.class);
    private final Supplier<PasswordStore> passwordStoreSupplier;

    @Inject
    public FileAuthenticator(FileConfig config) throws FileNotFoundException {
        File file = config.getPasswordFile();
        if (!file.exists()) {
            log.error("File %s does not exist", new Object[]{file.getAbsolutePath()});
            throw new FileNotFoundException("File " + file.getAbsolutePath() + " does not exist");
        }
        int cacheMaxSize = config.getAuthTokenCacheMaxSize();
        this.passwordStoreSupplier = Suppliers.memoizeWithExpiration(() -> new PasswordStore(file, cacheMaxSize), (long)config.getRefreshPeriod().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public Principal createAuthenticatedPrincipal(String user, String password) {
        if (!this.passwordStoreSupplier.get().authenticate(user, password)) {
            throw new AccessDeniedException("Invalid credentials");
        }
        return new BasicPrincipal(user);
    }
}

