/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.BaseMetadataTableScan;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.events.Listeners;
import org.apache.iceberg.events.ScanEvent;
import org.apache.iceberg.io.CloseableIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseAllMetadataTableScan
extends BaseMetadataTableScan {
    private static final Logger LOG = LoggerFactory.getLogger(BaseAllMetadataTableScan.class);

    BaseAllMetadataTableScan(TableOperations ops, Table table, Schema fileSchema) {
        super(ops, table, fileSchema);
    }

    BaseAllMetadataTableScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
        super(ops, table, schema, context);
    }

    protected abstract String tableType();

    @Override
    public TableScan appendsBetween(long fromSnapshotId, long toSnapshotId) {
        throw new UnsupportedOperationException(String.format("Cannot incrementally scan table of type %s", this.tableType()));
    }

    @Override
    public TableScan appendsAfter(long fromSnapshotId) {
        throw new UnsupportedOperationException(String.format("Cannot incrementally scan table of type %s", this.tableType()));
    }

    @Override
    public CloseableIterable<FileScanTask> planFiles() {
        LOG.info("Scanning metadata table {} with filter {}.", (Object)this.table(), (Object)this.filter());
        Listeners.notifyAll((Object)new ScanEvent(this.table().name(), 0L, this.filter(), this.schema()));
        return this.planFiles(this.tableOps(), this.snapshot(), this.filter(), this.shouldIgnoreResiduals(), this.isCaseSensitive(), this.colStats());
    }
}

