/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Collection;
import java.util.List;
import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;

public class BaseCombinedScanTask
implements CombinedScanTask {
    private final FileScanTask[] tasks;

    public BaseCombinedScanTask(FileScanTask ... tasks) {
        Preconditions.checkNotNull((Object)tasks, (Object)"tasks cannot be null");
        this.tasks = tasks;
    }

    public BaseCombinedScanTask(List<FileScanTask> tasks) {
        Preconditions.checkNotNull(tasks, (Object)"tasks cannot be null");
        this.tasks = (FileScanTask[])BaseFileScanTask.combineAdjacentTasks(tasks).stream().toArray(FileScanTask[]::new);
    }

    public Collection<FileScanTask> files() {
        return ImmutableList.copyOf((Object[])this.tasks);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tasks", (Object)Joiner.on((String)", ").join((Object[])this.tasks)).toString();
    }
}

