/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

class BaseFileScanTask
implements FileScanTask {
    private final DataFile file;
    private final DeleteFile[] deletes;
    private final String schemaString;
    private final String specString;
    private final ResidualEvaluator residuals;
    private transient PartitionSpec spec = null;

    BaseFileScanTask(DataFile file, DeleteFile[] deletes, String schemaString, String specString, ResidualEvaluator residuals) {
        this.file = file;
        this.deletes = deletes != null ? deletes : new DeleteFile[]{};
        this.schemaString = schemaString;
        this.specString = specString;
        this.residuals = residuals;
    }

    public DataFile file() {
        return this.file;
    }

    public List<DeleteFile> deletes() {
        return ImmutableList.copyOf((Object[])this.deletes);
    }

    public PartitionSpec spec() {
        if (this.spec == null) {
            this.spec = PartitionSpecParser.fromJson(SchemaParser.fromJson(this.schemaString), this.specString);
        }
        return this.spec;
    }

    public long start() {
        return 0L;
    }

    public long length() {
        return this.file.fileSizeInBytes();
    }

    public Expression residual() {
        return this.residuals.residualFor(this.file.partition());
    }

    public Iterable<FileScanTask> split(long targetSplitSize) {
        if (this.file.format().isSplittable()) {
            if (this.file.splitOffsets() != null) {
                return () -> new OffsetsAwareTargetSplitSizeScanTaskIterator(this.file.splitOffsets(), this);
            }
            return () -> new FixedSizeSplitScanTaskIterator(targetSplitSize, this);
        }
        return ImmutableList.of((Object)this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("file", (Object)this.file.path()).add("partition_data", (Object)this.file.partition()).add("residual", (Object)this.residual()).toString();
    }

    static List<FileScanTask> combineAdjacentTasks(List<FileScanTask> tasks) {
        if (tasks.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList combinedScans = Lists.newArrayList();
        SplitScanTask lastSplit = null;
        for (FileScanTask fileScanTask : tasks) {
            if (!(fileScanTask instanceof SplitScanTask)) {
                combinedScans.add(fileScanTask);
                continue;
            }
            SplitScanTask split = (SplitScanTask)fileScanTask;
            if (lastSplit != null) {
                if (lastSplit.isAdjacent(split)) {
                    lastSplit = new SplitScanTask(lastSplit.offset, lastSplit.len + split.len, lastSplit.fileScanTask);
                    continue;
                }
                combinedScans.add(lastSplit);
                lastSplit = split;
                continue;
            }
            lastSplit = split;
        }
        if (lastSplit != null) {
            combinedScans.add(lastSplit);
        }
        return combinedScans;
    }

    private static final class SplitScanTask
    implements FileScanTask {
        private final long len;
        private final long offset;
        private final FileScanTask fileScanTask;

        SplitScanTask(long offset, long len, FileScanTask fileScanTask) {
            this.offset = offset;
            this.len = len;
            this.fileScanTask = fileScanTask;
        }

        public DataFile file() {
            return this.fileScanTask.file();
        }

        public List<DeleteFile> deletes() {
            return this.fileScanTask.deletes();
        }

        public PartitionSpec spec() {
            return this.fileScanTask.spec();
        }

        public long start() {
            return this.offset;
        }

        public long length() {
            return this.len;
        }

        public Expression residual() {
            return this.fileScanTask.residual();
        }

        public Iterable<FileScanTask> split(long splitSize) {
            throw new UnsupportedOperationException("Cannot split a task which is already split");
        }

        public boolean isAdjacent(SplitScanTask other) {
            return other != null && this.file().equals(other.file()) && this.offset + this.len == other.offset;
        }
    }

    @VisibleForTesting
    static final class FixedSizeSplitScanTaskIterator
    implements Iterator<FileScanTask> {
        private long offset = 0L;
        private long remainingLen;
        private long splitSize;
        private final FileScanTask fileScanTask;

        FixedSizeSplitScanTaskIterator(long splitSize, FileScanTask fileScanTask) {
            this.remainingLen = fileScanTask.length();
            this.splitSize = splitSize;
            this.fileScanTask = fileScanTask;
        }

        @Override
        public boolean hasNext() {
            return this.remainingLen > 0L;
        }

        @Override
        public FileScanTask next() {
            long len = Math.min(this.splitSize, this.remainingLen);
            SplitScanTask splitTask = new SplitScanTask(this.offset, len, this.fileScanTask);
            this.offset += len;
            this.remainingLen -= len;
            return splitTask;
        }
    }

    @VisibleForTesting
    static final class OffsetsAwareTargetSplitSizeScanTaskIterator
    implements Iterator<FileScanTask> {
        private final List<Long> offsets;
        private final List<Long> splitSizes;
        private final FileScanTask parentScanTask;
        private int sizeIdx = 0;

        OffsetsAwareTargetSplitSizeScanTaskIterator(List<Long> offsetList, FileScanTask parentScanTask) {
            this.offsets = ImmutableList.copyOf(offsetList);
            this.parentScanTask = parentScanTask;
            this.splitSizes = Lists.newArrayListWithCapacity((int)this.offsets.size());
            if (this.offsets.size() > 0) {
                int lastIndex = this.offsets.size() - 1;
                for (int index = 0; index < lastIndex; ++index) {
                    this.splitSizes.add(this.offsets.get(index + 1) - this.offsets.get(index));
                }
                this.splitSizes.add(parentScanTask.length() - this.offsets.get(lastIndex));
            }
        }

        @Override
        public boolean hasNext() {
            return this.sizeIdx < this.splitSizes.size();
        }

        @Override
        public FileScanTask next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int offsetIdx = this.sizeIdx;
            long currentSize = this.splitSizes.get(this.sizeIdx);
            ++this.sizeIdx;
            SplitScanTask combinedTask = new SplitScanTask(this.offsets.get(offsetIdx), currentSize, this.parentScanTask);
            return combinedTask;
        }
    }
}

