/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.events.Listeners;
import org.apache.iceberg.events.ScanEvent;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.iceberg.util.TableScanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseTableScan
implements TableScan {
    private static final Logger LOG = LoggerFactory.getLogger(BaseTableScan.class);
    private final TableOperations ops;
    private final Table table;
    private final Schema schema;
    private final TableScanContext context;

    protected BaseTableScan(TableOperations ops, Table table, Schema schema) {
        this(ops, table, schema, new TableScanContext());
    }

    protected BaseTableScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
        this.ops = ops;
        this.table = table;
        this.schema = schema;
        this.context = context;
    }

    protected TableOperations tableOps() {
        return this.ops;
    }

    protected Long snapshotId() {
        return this.context.snapshotId();
    }

    protected boolean colStats() {
        return this.context.returnColumnStats();
    }

    protected boolean shouldIgnoreResiduals() {
        return this.context.ignoreResiduals();
    }

    protected Collection<String> selectedColumns() {
        return this.context.selectedColumns();
    }

    protected Map<String, String> options() {
        return this.context.options();
    }

    protected TableScanContext context() {
        return this.context;
    }

    protected abstract TableScan newRefinedScan(TableOperations var1, Table var2, Schema var3, TableScanContext var4);

    protected abstract CloseableIterable<FileScanTask> planFiles(TableOperations var1, Snapshot var2, Expression var3, boolean var4, boolean var5, boolean var6);

    public Table table() {
        return this.table;
    }

    public TableScan appendsBetween(long fromSnapshotId, long toSnapshotId) {
        throw new UnsupportedOperationException("Incremental scan is not supported");
    }

    public TableScan appendsAfter(long fromSnapshotId) {
        throw new UnsupportedOperationException("Incremental scan is not supported");
    }

    public TableScan useSnapshot(long scanSnapshotId) {
        Preconditions.checkArgument((this.context.snapshotId() == null ? 1 : 0) != 0, (String)"Cannot override snapshot, already set to id=%s", (Object)this.context.snapshotId());
        Preconditions.checkArgument((this.ops.current().snapshot(scanSnapshotId) != null ? 1 : 0) != 0, (String)"Cannot find snapshot with ID %s", (long)scanSnapshotId);
        return this.newRefinedScan(this.ops, this.table, this.schema, this.context.useSnapshotId(scanSnapshotId));
    }

    public TableScan asOfTime(long timestampMillis) {
        Preconditions.checkArgument((this.context.snapshotId() == null ? 1 : 0) != 0, (String)"Cannot override snapshot, already set to id=%s", (Object)this.context.snapshotId());
        return this.useSnapshot(SnapshotUtil.snapshotIdAsOfTime(this.table(), timestampMillis));
    }

    public TableScan option(String property, String value) {
        return this.newRefinedScan(this.ops, this.table, this.schema, this.context.withOption(property, value));
    }

    public TableScan project(Schema projectedSchema) {
        return this.newRefinedScan(this.ops, this.table, this.schema, this.context.project(projectedSchema));
    }

    public TableScan caseSensitive(boolean scanCaseSensitive) {
        return this.newRefinedScan(this.ops, this.table, this.schema, this.context.setCaseSensitive(scanCaseSensitive));
    }

    public TableScan includeColumnStats() {
        return this.newRefinedScan(this.ops, this.table, this.schema, this.context.shouldReturnColumnStats(true));
    }

    public TableScan select(Collection<String> columns) {
        return this.newRefinedScan(this.ops, this.table, this.schema, this.context.selectColumns(columns));
    }

    public TableScan filter(Expression expr) {
        return this.newRefinedScan(this.ops, this.table, this.schema, this.context.filterRows(Expressions.and((Expression)this.context.rowFilter(), (Expression)expr)));
    }

    public Expression filter() {
        return this.context.rowFilter();
    }

    public TableScan ignoreResiduals() {
        return this.newRefinedScan(this.ops, this.table, this.schema, this.context.ignoreResiduals(true));
    }

    public CloseableIterable<FileScanTask> planFiles() {
        Snapshot snapshot = this.snapshot();
        if (snapshot != null) {
            LOG.info("Scanning table {} snapshot {} created at {} with filter {}", new Object[]{this.table, snapshot.snapshotId(), DateTimeUtil.formatTimestampMillis(snapshot.timestampMillis()), this.context.rowFilter()});
            Listeners.notifyAll((Object)new ScanEvent(this.table.name(), snapshot.snapshotId(), this.context.rowFilter(), this.schema()));
            return this.planFiles(this.ops, snapshot, this.context.rowFilter(), this.context.ignoreResiduals(), this.context.caseSensitive(), this.context.returnColumnStats());
        }
        LOG.info("Scanning empty table {}", (Object)this.table);
        return CloseableIterable.empty();
    }

    public CloseableIterable<CombinedScanTask> planTasks() {
        CloseableIterable<FileScanTask> fileScanTasks = this.planFiles();
        CloseableIterable<FileScanTask> splitFiles = TableScanUtil.splitFiles(fileScanTasks, this.targetSplitSize());
        return TableScanUtil.planTasks(splitFiles, this.targetSplitSize(), this.splitLookback(), this.splitOpenFileCost());
    }

    public int splitLookback() {
        int tableValue = this.tableOps().current().propertyAsInt("read.split.planning-lookback", 10);
        return PropertyUtil.propertyAsInt(this.options(), "read.split.planning-lookback", tableValue);
    }

    public long splitOpenFileCost() {
        long tableValue = this.tableOps().current().propertyAsLong("read.split.open-file-cost", 0x400000L);
        return PropertyUtil.propertyAsLong(this.options(), "read.split.open-file-cost", tableValue);
    }

    public Schema schema() {
        return this.lazyColumnProjection();
    }

    public Snapshot snapshot() {
        return this.context.snapshotId() != null ? this.ops.current().snapshot(this.context.snapshotId()) : this.ops.current().currentSnapshot();
    }

    public boolean isCaseSensitive() {
        return this.context.caseSensitive();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("projection", (Object)this.schema().asStruct()).add("filter", (Object)this.context.rowFilter()).add("ignoreResiduals", this.context.ignoreResiduals()).add("caseSensitive", this.context.caseSensitive()).toString();
    }

    private Schema lazyColumnProjection() {
        Collection<String> selectedColumns = this.context.selectedColumns();
        if (selectedColumns != null) {
            HashSet requiredFieldIds = Sets.newHashSet();
            requiredFieldIds.addAll(Binder.boundReferences((Types.StructType)this.schema.asStruct(), Collections.singletonList(this.context.rowFilter()), (boolean)this.context.caseSensitive()));
            Set selectedIds = this.context.caseSensitive() ? TypeUtil.getProjectedIds((Schema)this.schema.select(selectedColumns)) : TypeUtil.getProjectedIds((Schema)this.schema.caseInsensitiveSelect(selectedColumns));
            requiredFieldIds.addAll(selectedIds);
            return TypeUtil.project((Schema)this.schema, (Set)requiredFieldIds);
        }
        if (this.context.projectedSchema() != null) {
            return this.context.projectedSchema();
        }
        return this.schema;
    }
}

