/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.MetricsModes;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.SerializableMap;
import org.apache.iceberg.util.SortOrderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class MetricsConfig
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsConfig.class);
    private static final Joiner DOT = Joiner.on((char)'.');
    private static final MetricsConfig DEFAULT = new MetricsConfig((Map<String, MetricsModes.MetricsMode>)ImmutableMap.of(), MetricsModes.fromString("truncate(16)"));
    private final Map<String, MetricsModes.MetricsMode> columnModes;
    private final MetricsModes.MetricsMode defaultMode;

    private MetricsConfig(Map<String, MetricsModes.MetricsMode> columnModes, MetricsModes.MetricsMode defaultMode) {
        this.columnModes = SerializableMap.copyOf(columnModes).immutableMap();
        this.defaultMode = defaultMode;
    }

    public static MetricsConfig getDefault() {
        return DEFAULT;
    }

    static Map<String, String> updateProperties(Map<String, String> props, List<String> deletedColumns, Map<String, String> renamedColumns) {
        if (props.keySet().stream().noneMatch(key -> key.startsWith("write.metadata.metrics.column."))) {
            return props;
        }
        HashMap updatedProperties = Maps.newHashMap();
        props.keySet().forEach(key -> {
            if (key.startsWith("write.metadata.metrics.column.")) {
                String columnAlias = key.replaceFirst("write.metadata.metrics.column.", "");
                if (renamedColumns.get(columnAlias) != null) {
                    String newKey = "write.metadata.metrics.column." + (String)renamedColumns.get(columnAlias);
                    updatedProperties.put(newKey, (String)props.get(key));
                } else if (!deletedColumns.contains(columnAlias)) {
                    updatedProperties.put(key, (String)props.get(key));
                }
            } else {
                updatedProperties.put(key, (String)props.get(key));
            }
        });
        return updatedProperties;
    }

    @Deprecated
    public static MetricsConfig fromProperties(Map<String, String> props) {
        return MetricsConfig.from(props, null);
    }

    public static MetricsConfig forTable(Table table) {
        return MetricsConfig.from(table.properties(), table.sortOrder());
    }

    public static MetricsConfig forPositionDelete(Table table) {
        ImmutableMap.Builder columnModes = ImmutableMap.builder();
        columnModes.put((Object)MetadataColumns.DELETE_FILE_PATH.name(), (Object)MetricsModes.Full.get());
        columnModes.put((Object)MetadataColumns.DELETE_FILE_POS.name(), (Object)MetricsModes.Full.get());
        MetricsConfig tableConfig = MetricsConfig.forTable(table);
        MetricsModes.MetricsMode defaultMode = tableConfig.defaultMode;
        tableConfig.columnModes.forEach((columnAlias, mode) -> {
            String positionDeleteColumnAlias = DOT.join((Object)"row", columnAlias, new Object[0]);
            columnModes.put((Object)positionDeleteColumnAlias, mode);
        });
        return new MetricsConfig((Map<String, MetricsModes.MetricsMode>)columnModes.build(), defaultMode);
    }

    private static MetricsConfig from(Map<String, String> props, SortOrder order) {
        MetricsModes.MetricsMode defaultMode;
        HashMap columnModes = Maps.newHashMap();
        String defaultModeAsString = props.getOrDefault("write.metadata.metrics.default", "truncate(16)");
        try {
            defaultMode = MetricsModes.fromString(defaultModeAsString);
        }
        catch (IllegalArgumentException err) {
            LOG.warn("Ignoring invalid default metrics mode: {}", (Object)defaultModeAsString, (Object)err);
            defaultMode = MetricsModes.fromString("truncate(16)");
        }
        MetricsModes.MetricsMode sortedColDefaultMode = MetricsConfig.sortedColumnDefaultMode(defaultMode);
        Set<String> sortedCols = SortOrderUtil.orderPreservingSortedColumns(order);
        sortedCols.forEach(sc -> columnModes.put(sc, sortedColDefaultMode));
        MetricsModes.MetricsMode defaultModeFinal = defaultMode;
        props.keySet().stream().filter(key -> key.startsWith("write.metadata.metrics.column.")).forEach(key -> {
            MetricsModes.MetricsMode mode;
            String columnAlias = key.replaceFirst("write.metadata.metrics.column.", "");
            try {
                mode = MetricsModes.fromString((String)props.get(key));
            }
            catch (IllegalArgumentException err) {
                LOG.warn("Ignoring invalid metrics mode for column {}: {}", new Object[]{columnAlias, props.get(key), err});
                mode = defaultModeFinal;
            }
            columnModes.put(columnAlias, mode);
        });
        return new MetricsConfig(columnModes, defaultMode);
    }

    private static MetricsModes.MetricsMode sortedColumnDefaultMode(MetricsModes.MetricsMode defaultMode) {
        if (defaultMode == MetricsModes.None.get() || defaultMode == MetricsModes.Counts.get()) {
            return MetricsModes.Truncate.withLength(16);
        }
        return defaultMode;
    }

    public void validateReferencedColumns(Schema schema) {
        for (String column : this.columnModes.keySet()) {
            ValidationException.check((schema.findField(column) != null ? 1 : 0) != 0, (String)"Invalid metrics config, could not find column %s from table prop %s in schema %s", (Object[])new Object[]{column, "write.metadata.metrics.column." + column, schema});
        }
    }

    public MetricsModes.MetricsMode columnMode(String columnAlias) {
        return this.columnModes.getOrDefault(columnAlias, this.defaultMode);
    }
}

