/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.deletes;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.apache.iceberg.Accessor;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.deletes.BitmapPositionDeleteIndex;
import org.apache.iceberg.deletes.PositionDeleteIndex;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FilterIterator;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Filter;
import org.apache.iceberg.util.SortedMerge;
import org.apache.iceberg.util.StructLikeSet;

public class Deletes {
    private static final Schema POSITION_DELETE_SCHEMA = new Schema(new Types.NestedField[]{MetadataColumns.DELETE_FILE_PATH, MetadataColumns.DELETE_FILE_POS});
    private static final Accessor<StructLike> FILENAME_ACCESSOR = POSITION_DELETE_SCHEMA.accessorForField(MetadataColumns.DELETE_FILE_PATH.fieldId());
    private static final Accessor<StructLike> POSITION_ACCESSOR = POSITION_DELETE_SCHEMA.accessorForField(MetadataColumns.DELETE_FILE_POS.fieldId());

    private Deletes() {
    }

    public static <T> CloseableIterable<T> filter(CloseableIterable<T> rows, Function<T, StructLike> rowToDeleteKey, StructLikeSet deleteSet) {
        if (deleteSet.isEmpty()) {
            return rows;
        }
        EqualitySetDeleteFilter<T> equalityFilter = new EqualitySetDeleteFilter<T>(rowToDeleteKey, deleteSet);
        return equalityFilter.filter(rows);
    }

    public static <T> CloseableIterable<T> filter(CloseableIterable<T> rows, Function<T, Long> rowToPosition, PositionDeleteIndex deleteSet) {
        if (deleteSet.isEmpty()) {
            return rows;
        }
        PositionSetDeleteFilter<T> filter = new PositionSetDeleteFilter<T>(rowToPosition, deleteSet);
        return filter.filter(rows);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StructLikeSet toEqualitySet(CloseableIterable<StructLike> eqDeletes, Types.StructType eqType) {
        try (CloseableIterable<StructLike> deletes = eqDeletes;){
            StructLikeSet deleteSet = StructLikeSet.create(eqType);
            Iterables.addAll((Collection)deleteSet, deletes);
            StructLikeSet structLikeSet = deleteSet;
            return structLikeSet;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close equality delete source", e);
        }
    }

    public static <T extends StructLike> PositionDeleteIndex toPositionIndex(CharSequence dataLocation, List<CloseableIterable<T>> deleteFiles) {
        DataFileFilter locationFilter = new DataFileFilter(dataLocation);
        List positions = Lists.transform(deleteFiles, deletes -> CloseableIterable.transform(locationFilter.filter(deletes), row -> (Long)POSITION_ACCESSOR.get(row)));
        return Deletes.toPositionIndex((CloseableIterable<Long>)CloseableIterable.concat((Iterable)positions));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PositionDeleteIndex toPositionIndex(CloseableIterable<Long> posDeletes) {
        try (CloseableIterable<Long> deletes = posDeletes;){
            BitmapPositionDeleteIndex positionDeleteIndex = new BitmapPositionDeleteIndex();
            deletes.forEach(positionDeleteIndex::delete);
            BitmapPositionDeleteIndex bitmapPositionDeleteIndex = positionDeleteIndex;
            return bitmapPositionDeleteIndex;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close position delete source", e);
        }
    }

    public static <T> CloseableIterable<T> streamingFilter(CloseableIterable<T> rows, Function<T, Long> rowToPosition, CloseableIterable<Long> posDeletes) {
        return new PositionStreamDeleteFilter(rows, rowToPosition, posDeletes);
    }

    public static CloseableIterable<Long> deletePositions(CharSequence dataLocation, CloseableIterable<StructLike> deleteFile) {
        return Deletes.deletePositions(dataLocation, ImmutableList.of(deleteFile));
    }

    public static <T extends StructLike> CloseableIterable<Long> deletePositions(CharSequence dataLocation, List<CloseableIterable<T>> deleteFiles) {
        DataFileFilter locationFilter = new DataFileFilter(dataLocation);
        List positions = Lists.transform(deleteFiles, deletes -> CloseableIterable.transform(locationFilter.filter(deletes), row -> (Long)POSITION_ACCESSOR.get(row)));
        return new SortedMerge<Long>(Long::compare, positions);
    }

    private static class DataFileFilter<T extends StructLike>
    extends Filter<T> {
        private final CharSequence dataLocation;

        DataFileFilter(CharSequence dataLocation) {
            this.dataLocation = dataLocation;
        }

        @Override
        protected boolean shouldKeep(T posDelete) {
            return this.charSeqEquals(this.dataLocation, (CharSequence)FILENAME_ACCESSOR.get(posDelete));
        }

        private boolean charSeqEquals(CharSequence s1, CharSequence s2) {
            if (s1 == s2) {
                return true;
            }
            int count = s1.length();
            if (count != s2.length()) {
                return false;
            }
            if (s1 instanceof String && s2 instanceof String && s1.hashCode() != s2.hashCode()) {
                return false;
            }
            for (int i = count - 1; i >= 0; --i) {
                if (s1.charAt(i) == s2.charAt(i)) continue;
                return false;
            }
            return true;
        }
    }

    private static class PositionStreamDeleteFilter<T>
    extends CloseableGroup
    implements CloseableIterable<T> {
        private final CloseableIterable<T> rows;
        private final Function<T, Long> extractPos;
        private final CloseableIterable<Long> deletePositions;

        private PositionStreamDeleteFilter(CloseableIterable<T> rows, Function<T, Long> extractPos, CloseableIterable<Long> deletePositions) {
            this.rows = rows;
            this.extractPos = extractPos;
            this.deletePositions = deletePositions;
        }

        public CloseableIterator<T> iterator() {
            Object iter;
            CloseableIterator deletePosIterator = this.deletePositions.iterator();
            if (deletePosIterator.hasNext()) {
                iter = new PositionFilterIterator(this.rows.iterator(), (CloseableIterator<Long>)deletePosIterator);
            } else {
                iter = this.rows.iterator();
                try {
                    deletePosIterator.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to close delete positions iterator", e);
                }
            }
            this.addCloseable((Closeable)iter);
            return iter;
        }

        private class PositionFilterIterator
        extends FilterIterator<T> {
            private final CloseableIterator<Long> deletePosIterator;
            private long nextDeletePos;

            protected PositionFilterIterator(CloseableIterator<T> items, CloseableIterator<Long> deletePositions) {
                super(items);
                this.deletePosIterator = deletePositions;
                this.nextDeletePos = (Long)this.deletePosIterator.next();
            }

            protected boolean shouldKeep(T row) {
                boolean keep;
                long currentPos = (Long)PositionStreamDeleteFilter.this.extractPos.apply(row);
                if (currentPos < this.nextDeletePos) {
                    return true;
                }
                boolean bl = keep = currentPos != this.nextDeletePos;
                while (this.deletePosIterator.hasNext() && this.nextDeletePos <= currentPos) {
                    this.nextDeletePos = (Long)this.deletePosIterator.next();
                    if (!keep || currentPos != this.nextDeletePos) continue;
                    keep = false;
                }
                return keep;
            }

            public void close() {
                super.close();
                try {
                    this.deletePosIterator.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to close delete positions iterator", e);
                }
            }
        }
    }

    private static class PositionSetDeleteFilter<T>
    extends Filter<T> {
        private final Function<T, Long> rowToPosition;
        private final PositionDeleteIndex deleteSet;

        private PositionSetDeleteFilter(Function<T, Long> rowToPosition, PositionDeleteIndex deleteSet) {
            this.rowToPosition = rowToPosition;
            this.deleteSet = deleteSet;
        }

        @Override
        protected boolean shouldKeep(T row) {
            return !this.deleteSet.isDeleted(this.rowToPosition.apply(row));
        }
    }

    private static class EqualitySetDeleteFilter<T>
    extends Filter<T> {
        private final StructLikeSet deletes;
        private final Function<T, StructLike> extractEqStruct;

        protected EqualitySetDeleteFilter(Function<T, StructLike> extractEq, StructLikeSet deletes) {
            this.extractEqStruct = extractEq;
            this.deletes = deletes;
        }

        @Override
        protected boolean shouldKeep(T row) {
            return !this.deletes.contains(this.extractEqStruct.apply(row));
        }
    }
}

