/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.util.List;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.io.DataWriteResult;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.RollingFileWriter;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

public class RollingDataWriter<T>
extends RollingFileWriter<T, DataWriter<T>, DataWriteResult> {
    private final FileWriterFactory<T> writerFactory;
    private final List<DataFile> dataFiles;

    public RollingDataWriter(FileWriterFactory<T> writerFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSizeInBytes, PartitionSpec spec, StructLike partition) {
        super(fileFactory, io, targetFileSizeInBytes, spec, partition);
        this.writerFactory = writerFactory;
        this.dataFiles = Lists.newArrayList();
        this.openCurrentWriter();
    }

    @Override
    protected DataWriter<T> newWriter(EncryptedOutputFile file) {
        return this.writerFactory.newDataWriter(file, this.spec(), this.partition());
    }

    @Override
    protected void addResult(DataWriteResult result) {
        this.dataFiles.addAll(result.dataFiles());
    }

    @Override
    protected DataWriteResult aggregatedResult() {
        return new DataWriteResult(this.dataFiles);
    }
}

