/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.s3;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.s3.HiveS3Config;
import com.facebook.presto.hive.s3.PrestoS3ConfigurationUpdater;
import com.facebook.presto.hive.s3.PrestoS3FileSystem;
import com.facebook.presto.hive.s3.PrestoS3FileSystemStats;
import com.facebook.presto.hive.s3.S3ConfigurationUpdater;
import com.facebook.presto.hive.s3.S3FileSystemType;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.weakref.jmx.ObjectNames;
import org.weakref.jmx.guice.ExportBinder;

public class HiveS3Module
extends AbstractConfigurationAwareModule {
    private static final String EMR_FS_CLASS_NAME = "com.amazon.ws.emr.hadoop.fs.EmrFileSystem";
    private final String connectorId;

    public HiveS3Module(String connectorId) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
    }

    protected void setup(Binder binder) {
        S3FileSystemType type = ((HiveClientConfig)this.buildConfigObject(HiveClientConfig.class)).getS3FileSystemType();
        if (type == S3FileSystemType.PRESTO) {
            binder.bind(S3ConfigurationUpdater.class).to(PrestoS3ConfigurationUpdater.class).in(Scopes.SINGLETON);
            ConfigBinder.configBinder((Binder)binder).bindConfig(HiveS3Config.class);
            binder.bind(PrestoS3FileSystemStats.class).toInstance((Object)PrestoS3FileSystem.getFileSystemStats());
            ExportBinder.newExporter((Binder)binder).export(PrestoS3FileSystemStats.class).as(ObjectNames.generatedNameOf(PrestoS3FileSystem.class, (String)this.connectorId));
        } else if (type == S3FileSystemType.EMRFS) {
            HiveS3Module.validateEmrFsClass();
            binder.bind(S3ConfigurationUpdater.class).to(EmrFsS3ConfigurationUpdater.class).in(Scopes.SINGLETON);
        } else if (type == S3FileSystemType.HADOOP_DEFAULT) {
            binder.bind(S3ConfigurationUpdater.class).to(HadoopDefaultConfigurationUpdater.class).in(Scopes.SINGLETON);
        } else {
            throw new RuntimeException("Unknown file system type: " + (Object)((Object)type));
        }
    }

    private static void validateEmrFsClass() {
        try {
            Class.forName(EMR_FS_CLASS_NAME, true, JavaUtils.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("EMR File System class not found: com.amazon.ws.emr.hadoop.fs.EmrFileSystem", e);
        }
    }

    public static class HadoopDefaultConfigurationUpdater
    implements S3ConfigurationUpdater {
        @Override
        public void updateConfiguration(Configuration config) {
        }
    }

    public static class EmrFsS3ConfigurationUpdater
    implements S3ConfigurationUpdater {
        @Override
        public void updateConfiguration(Configuration config) {
            config.set("fs.s3.impl", HiveS3Module.EMR_FS_CLASS_NAME);
            config.set("fs.s3a.impl", HiveS3Module.EMR_FS_CLASS_NAME);
            config.set("fs.s3n.impl", HiveS3Module.EMR_FS_CLASS_NAME);
        }
    }
}

