/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.analytics;

import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.analytics.LogRecord;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.analytics.LogRecordStreamReader;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.blob.ListBlobItem;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Iterator;
import java.util.NoSuchElementException;

class LogRecordIterator
implements Iterator<LogRecord> {
    private final Iterator<ListBlobItem> logBlobIterator;
    private LogRecordStreamReader reader;
    private LogRecord pendingLogRecord;
    private boolean isLogRecordPending = false;

    public LogRecordIterator(Iterator<ListBlobItem> logBlobIterator) {
        this.logBlobIterator = logBlobIterator;
    }

    @Override
    public boolean hasNext() {
        if (this.isLogRecordPending) {
            return true;
        }
        try {
            if (this.reader == null || this.reader.isEndOfFile()) {
                if (this.logBlobIterator.hasNext()) {
                    if (this.reader != null) {
                        this.reader.close();
                    }
                    CloudBlockBlob nextBlob = (CloudBlockBlob)this.logBlobIterator.next();
                    this.reader = new LogRecordStreamReader(nextBlob.openInputStream());
                    return this.hasNext();
                }
                return false;
            }
            this.pendingLogRecord = new LogRecord(this.reader);
            this.isLogRecordPending = true;
            return true;
        }
        catch (IOException e) {
            NoSuchElementException ex = new NoSuchElementException("An error occurred while enumerating the result, check the original exception for details.");
            ex.initCause(e);
            throw ex;
        }
        catch (StorageException e) {
            NoSuchElementException ex = new NoSuchElementException("An error occurred while enumerating the result, check the original exception for details.");
            ex.initCause(e);
            throw ex;
        }
        catch (ParseException e) {
            NoSuchElementException ex = new NoSuchElementException("An error occurred while enumerating the result, check the original exception for details.");
            ex.initCause(e);
            throw ex;
        }
        catch (URISyntaxException e) {
            NoSuchElementException ex = new NoSuchElementException("An error occurred while enumerating the result, check the original exception for details.");
            ex.initCause(e);
            throw ex;
        }
    }

    @Override
    public LogRecord next() {
        if (this.isLogRecordPending) {
            this.isLogRecordPending = false;
            return this.pendingLogRecord;
        }
        if (this.hasNext()) {
            return this.next();
        }
        throw new NoSuchElementException("There are no more elements in this enumeration.");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

