/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.realtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.InputSplitWithLocationInfo;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hadoop.InputSplitUtils;
import org.apache.hudi.hadoop.realtime.HoodieVirtualKeyInfo;

public interface RealtimeSplit
extends InputSplitWithLocationInfo {
    public List<String> getDeltaLogPaths();

    public List<HoodieLogFile> getDeltaLogFiles();

    public String getMaxCommitTime();

    public String getBasePath();

    public Option<HoodieVirtualKeyInfo> getHoodieVirtualKeyInfo();

    public void setDeltaLogPaths(List<String> var1);

    public void setMaxCommitTime(String var1);

    public void setBasePath(String var1);

    public void setHoodieVirtualKeyInfo(Option<HoodieVirtualKeyInfo> var1);

    default public void writeToOutput(DataOutput out) throws IOException {
        InputSplitUtils.writeString(this.getBasePath(), out);
        InputSplitUtils.writeString(this.getMaxCommitTime(), out);
        out.writeInt(this.getDeltaLogPaths().size());
        for (String logFilePath : this.getDeltaLogPaths()) {
            InputSplitUtils.writeString(logFilePath, out);
        }
        if (!this.getHoodieVirtualKeyInfo().isPresent()) {
            InputSplitUtils.writeBoolean(false, out);
        } else {
            InputSplitUtils.writeBoolean(true, out);
            InputSplitUtils.writeString(this.getHoodieVirtualKeyInfo().get().getRecordKeyField(), out);
            InputSplitUtils.writeString(this.getHoodieVirtualKeyInfo().get().getPartitionPathField(), out);
            InputSplitUtils.writeString(String.valueOf(this.getHoodieVirtualKeyInfo().get().getRecordKeyFieldIndex()), out);
            InputSplitUtils.writeString(String.valueOf(this.getHoodieVirtualKeyInfo().get().getPartitionPathFieldIndex()), out);
        }
    }

    default public void readFromInput(DataInput in) throws IOException {
        this.setBasePath(InputSplitUtils.readString(in));
        this.setMaxCommitTime(InputSplitUtils.readString(in));
        int totalLogFiles = in.readInt();
        ArrayList<String> deltaLogPaths = new ArrayList<String>(totalLogFiles);
        for (int i = 0; i < totalLogFiles; ++i) {
            deltaLogPaths.add(InputSplitUtils.readString(in));
        }
        this.setDeltaLogPaths(deltaLogPaths);
        boolean hoodieVirtualKeyPresent = InputSplitUtils.readBoolean(in);
        if (hoodieVirtualKeyPresent) {
            String recordKeyField = InputSplitUtils.readString(in);
            String partitionPathField = InputSplitUtils.readString(in);
            int recordFieldIndex = Integer.parseInt(InputSplitUtils.readString(in));
            int partitionPathIndex = Integer.parseInt(InputSplitUtils.readString(in));
            this.setHoodieVirtualKeyInfo(Option.of(new HoodieVirtualKeyInfo(recordKeyField, partitionPathField, recordFieldIndex, partitionPathIndex)));
        }
    }

    public Path getPath();

    public long getStart();

    public long getLength();
}

