/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.exceptions;

import org.apache.hadoop.ipc.RemoteException;
import org.apache.hudi.org.apache.hadoop.hbase.CallQueueTooBigException;
import org.apache.hudi.org.apache.hadoop.hbase.MultiActionResultTooLarge;
import org.apache.hudi.org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hudi.org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hudi.org.apache.hadoop.hbase.RetryImmediatelyException;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.RegionOpeningException;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.ThrottlingException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class ClientExceptionsUtil {
    private ClientExceptionsUtil() {
    }

    public static boolean isMetaClearingException(Throwable cur) {
        if ((cur = ClientExceptionsUtil.findException(cur)) == null) {
            return true;
        }
        return !ClientExceptionsUtil.isSpecialException(cur) || cur instanceof RegionMovedException || cur instanceof NotServingRegionException;
    }

    public static boolean isSpecialException(Throwable cur) {
        return cur instanceof RegionMovedException || cur instanceof RegionOpeningException || cur instanceof RegionTooBusyException || cur instanceof ThrottlingException || cur instanceof MultiActionResultTooLarge || cur instanceof RetryImmediatelyException || cur instanceof CallQueueTooBigException || cur instanceof NotServingRegionException;
    }

    public static Throwable findException(Object exception) {
        if (exception == null || !(exception instanceof Throwable)) {
            return null;
        }
        Throwable cur = (Throwable)exception;
        while (cur != null) {
            if (ClientExceptionsUtil.isSpecialException(cur)) {
                return cur;
            }
            if (cur instanceof RemoteException) {
                RemoteException re = (RemoteException)cur;
                if ((cur = re.unwrapRemoteException(new Class[]{RegionOpeningException.class, RegionMovedException.class, RegionTooBusyException.class})) == null) {
                    cur = re.unwrapRemoteException();
                }
                if (cur != re) continue;
                return cur;
            }
            if (cur.getCause() != null) {
                cur = cur.getCause();
                continue;
            }
            return cur;
        }
        return null;
    }
}

