/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hudi.org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSinkSource;
import org.apache.hudi.org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceFactory;

@InterfaceAudience.Private
public class MetricsSink {
    private long lastTimestampForAge = System.currentTimeMillis();
    private final MetricsReplicationSinkSource mss = ((MetricsReplicationSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsReplicationSourceFactory.class)).getSink();

    public long setAgeOfLastAppliedOp(long timestamp) {
        long age = 0L;
        if (this.lastTimestampForAge != timestamp) {
            this.lastTimestampForAge = timestamp;
            age = System.currentTimeMillis() - this.lastTimestampForAge;
        }
        this.mss.setLastAppliedOpAge(age);
        return age;
    }

    public long refreshAgeOfLastAppliedOp() {
        return this.setAgeOfLastAppliedOp(this.lastTimestampForAge);
    }

    public void applyBatch(long batchSize) {
        this.mss.incrAppliedBatches(1L);
        this.mss.incrAppliedOps(batchSize);
    }

    public long getAgeOfLastAppliedOp() {
        return this.mss.getLastAppliedOpAge();
    }

    public long getTimeStampOfLastAppliedOp() {
        return this.lastTimestampForAge;
    }
}

