/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.zookeeper;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hudi.org.apache.hadoop.hbase.util.RetryCounterFactory;
import org.apache.hudi.org.apache.htrace.Trace;
import org.apache.hudi.org.apache.htrace.TraceScope;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.proto.CreateRequest;
import org.apache.zookeeper.proto.SetDataRequest;

@InterfaceAudience.Private
public class RecoverableZooKeeper {
    private static final Log LOG = LogFactory.getLog(RecoverableZooKeeper.class);
    private ZooKeeper zk;
    private final RetryCounterFactory retryCounterFactory;
    private final String identifier;
    private final byte[] id;
    private Watcher watcher;
    private int sessionTimeout;
    private String quorumServers;
    private final Random salter;
    private static final byte MAGIC = -1;
    private static final int MAGIC_SIZE = 1;
    private static final int ID_LENGTH_OFFSET = 1;
    private static final int ID_LENGTH_SIZE = 4;

    public RecoverableZooKeeper(String quorumServers, int sessionTimeout, Watcher watcher, int maxRetries, int retryIntervalMillis) throws IOException {
        this(quorumServers, sessionTimeout, watcher, maxRetries, retryIntervalMillis, null);
    }

    @SuppressWarnings(value={"DE_MIGHT_IGNORE"}, justification="None. Its always been this way.")
    public RecoverableZooKeeper(String quorumServers, int sessionTimeout, Watcher watcher, int maxRetries, int retryIntervalMillis, String identifier) throws IOException {
        this.retryCounterFactory = new RetryCounterFactory(maxRetries + 1, retryIntervalMillis);
        if (identifier == null || identifier.length() == 0) {
            identifier = ManagementFactory.getRuntimeMXBean().getName();
        }
        LOG.info((Object)("Process identifier=" + identifier + " connecting to ZooKeeper ensemble=" + quorumServers));
        this.identifier = identifier;
        this.id = Bytes.toBytes(identifier);
        this.watcher = watcher;
        this.sessionTimeout = sessionTimeout;
        this.quorumServers = quorumServers;
        try {
            this.checkZk();
        }
        catch (Exception x) {
            // empty catch block
        }
        this.salter = new Random();
    }

    protected synchronized ZooKeeper checkZk() throws KeeperException {
        if (this.zk == null) {
            try {
                this.zk = new ZooKeeper(this.quorumServers, this.sessionTimeout, this.watcher);
            }
            catch (IOException ex) {
                LOG.warn((Object)"Unable to create ZooKeeper Connection", (Throwable)ex);
                throw new KeeperException.OperationTimeoutException();
            }
        }
        return this.zk;
    }

    public synchronized void reconnectAfterExpiration() throws IOException, KeeperException, InterruptedException {
        if (this.zk != null) {
            LOG.info((Object)("Closing dead ZooKeeper connection, session was: 0x" + Long.toHexString(this.zk.getSessionId())));
            this.zk.close();
            this.zk = null;
        }
        this.checkZk();
        LOG.info((Object)("Recreated a ZooKeeper, session is: 0x" + Long.toHexString(this.zk.getSessionId())));
    }

    /*
     * Exception decompiling
     */
    public void delete(String path, int version) throws InterruptedException, KeeperException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Stat exists(String path, Watcher watcher) throws KeeperException, InterruptedException {
        try (TraceScope traceScope = null;){
            traceScope = Trace.startSpan("RecoverableZookeeper.exists");
            RetryCounter retryCounter = this.retryCounterFactory.create();
            while (true) {
                try {
                    Stat stat = this.checkZk().exists(path, watcher);
                    return stat;
                }
                catch (KeeperException e) {
                    switch (e.code()) {
                        case CONNECTIONLOSS: 
                        case OPERATIONTIMEOUT: {
                            this.retryOrThrow(retryCounter, e, "exists");
                            break;
                        }
                        default: {
                            throw e;
                        }
                    }
                    retryCounter.sleepUntilNextRetry();
                    continue;
                }
                break;
            }
        }
    }

    public Stat exists(String path, boolean watch) throws KeeperException, InterruptedException {
        try (TraceScope traceScope = null;){
            traceScope = Trace.startSpan("RecoverableZookeeper.exists");
            RetryCounter retryCounter = this.retryCounterFactory.create();
            while (true) {
                try {
                    Stat stat = this.checkZk().exists(path, watch);
                    return stat;
                }
                catch (KeeperException e) {
                    switch (e.code()) {
                        case CONNECTIONLOSS: 
                        case OPERATIONTIMEOUT: {
                            this.retryOrThrow(retryCounter, e, "exists");
                            break;
                        }
                        default: {
                            throw e;
                        }
                    }
                    retryCounter.sleepUntilNextRetry();
                    continue;
                }
                break;
            }
        }
    }

    private void retryOrThrow(RetryCounter retryCounter, KeeperException e, String opName) throws KeeperException {
        LOG.debug((Object)("Possibly transient ZooKeeper, quorum=" + this.quorumServers + ", exception=" + (Object)((Object)e)));
        if (!retryCounter.shouldRetry()) {
            LOG.error((Object)("ZooKeeper " + opName + " failed after " + retryCounter.getMaxAttempts() + " attempts"));
            throw e;
        }
    }

    public List<String> getChildren(String path, Watcher watcher) throws KeeperException, InterruptedException {
        try (TraceScope traceScope = null;){
            traceScope = Trace.startSpan("RecoverableZookeeper.getChildren");
            RetryCounter retryCounter = this.retryCounterFactory.create();
            while (true) {
                try {
                    List list = this.checkZk().getChildren(path, watcher);
                    return list;
                }
                catch (KeeperException e) {
                    switch (e.code()) {
                        case CONNECTIONLOSS: 
                        case OPERATIONTIMEOUT: {
                            this.retryOrThrow(retryCounter, e, "getChildren");
                            break;
                        }
                        default: {
                            throw e;
                        }
                    }
                    retryCounter.sleepUntilNextRetry();
                    continue;
                }
                break;
            }
        }
    }

    public List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
        try (TraceScope traceScope = null;){
            traceScope = Trace.startSpan("RecoverableZookeeper.getChildren");
            RetryCounter retryCounter = this.retryCounterFactory.create();
            while (true) {
                try {
                    List list = this.checkZk().getChildren(path, watch);
                    return list;
                }
                catch (KeeperException e) {
                    switch (e.code()) {
                        case CONNECTIONLOSS: 
                        case OPERATIONTIMEOUT: {
                            this.retryOrThrow(retryCounter, e, "getChildren");
                            break;
                        }
                        default: {
                            throw e;
                        }
                    }
                    retryCounter.sleepUntilNextRetry();
                    continue;
                }
                break;
            }
        }
    }

    public byte[] getData(String path, Watcher watcher, Stat stat) throws KeeperException, InterruptedException {
        try (TraceScope traceScope = null;){
            traceScope = Trace.startSpan("RecoverableZookeeper.getData");
            RetryCounter retryCounter = this.retryCounterFactory.create();
            while (true) {
                try {
                    byte[] revData = this.checkZk().getData(path, watcher, stat);
                    byte[] byArray = this.removeMetaData(revData);
                    return byArray;
                }
                catch (KeeperException e) {
                    switch (e.code()) {
                        case CONNECTIONLOSS: 
                        case OPERATIONTIMEOUT: {
                            this.retryOrThrow(retryCounter, e, "getData");
                            break;
                        }
                        default: {
                            throw e;
                        }
                    }
                    retryCounter.sleepUntilNextRetry();
                    continue;
                }
                break;
            }
        }
    }

    public byte[] getData(String path, boolean watch, Stat stat) throws KeeperException, InterruptedException {
        try (TraceScope traceScope = null;){
            traceScope = Trace.startSpan("RecoverableZookeeper.getData");
            RetryCounter retryCounter = this.retryCounterFactory.create();
            while (true) {
                try {
                    byte[] revData = this.checkZk().getData(path, watch, stat);
                    byte[] byArray = this.removeMetaData(revData);
                    return byArray;
                }
                catch (KeeperException e) {
                    switch (e.code()) {
                        case CONNECTIONLOSS: 
                        case OPERATIONTIMEOUT: {
                            this.retryOrThrow(retryCounter, e, "getData");
                            break;
                        }
                        default: {
                            throw e;
                        }
                    }
                    retryCounter.sleepUntilNextRetry();
                    continue;
                }
                break;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public Stat setData(String path, byte[] data, int version) throws KeeperException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 7[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<ACL> getAcl(String path, Stat stat) throws KeeperException, InterruptedException {
        try (TraceScope traceScope = null;){
            traceScope = Trace.startSpan("RecoverableZookeeper.getAcl");
            RetryCounter retryCounter = this.retryCounterFactory.create();
            while (true) {
                try {
                    List list = this.checkZk().getACL(path, stat);
                    return list;
                }
                catch (KeeperException e) {
                    switch (e.code()) {
                        case CONNECTIONLOSS: 
                        case OPERATIONTIMEOUT: {
                            this.retryOrThrow(retryCounter, e, "getAcl");
                            break;
                        }
                        default: {
                            throw e;
                        }
                    }
                    retryCounter.sleepUntilNextRetry();
                    continue;
                }
                break;
            }
        }
    }

    public Stat setAcl(String path, List<ACL> acls, int version) throws KeeperException, InterruptedException {
        try (TraceScope traceScope = null;){
            traceScope = Trace.startSpan("RecoverableZookeeper.setAcl");
            RetryCounter retryCounter = this.retryCounterFactory.create();
            while (true) {
                try {
                    Stat stat = this.checkZk().setACL(path, acls, version);
                    return stat;
                }
                catch (KeeperException e) {
                    switch (e.code()) {
                        case CONNECTIONLOSS: 
                        case OPERATIONTIMEOUT: {
                            this.retryOrThrow(retryCounter, e, "setAcl");
                            break;
                        }
                        default: {
                            throw e;
                        }
                    }
                    retryCounter.sleepUntilNextRetry();
                    continue;
                }
                break;
            }
        }
    }

    public String create(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        try (TraceScope traceScope = null;){
            traceScope = Trace.startSpan("RecoverableZookeeper.create");
            byte[] newData = this.appendMetaData(data);
            switch (createMode) {
                case EPHEMERAL: 
                case PERSISTENT: {
                    String string = this.createNonSequential(path, newData, acl, createMode);
                    return string;
                }
                case EPHEMERAL_SEQUENTIAL: 
                case PERSISTENT_SEQUENTIAL: {
                    String string = this.createSequential(path, newData, acl, createMode);
                    return string;
                }
            }
            throw new IllegalArgumentException("Unrecognized CreateMode: " + createMode);
        }
    }

    private String createNonSequential(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        RetryCounter retryCounter = this.retryCounterFactory.create();
        boolean isRetry = false;
        while (true) {
            try {
                return this.checkZk().create(path, data, acl, createMode);
            }
            catch (KeeperException e) {
                switch (e.code()) {
                    case NODEEXISTS: {
                        if (isRetry) {
                            byte[] currentData = this.checkZk().getData(path, false, null);
                            if (currentData != null && Bytes.compareTo(currentData, data) == 0) {
                                return path;
                            }
                            LOG.error((Object)("Node " + path + " already exists with " + Bytes.toStringBinary(currentData) + ", could not write " + Bytes.toStringBinary(data)));
                            throw e;
                        }
                        LOG.debug((Object)("Node " + path + " already exists"));
                        throw e;
                    }
                    case CONNECTIONLOSS: 
                    case OPERATIONTIMEOUT: {
                        this.retryOrThrow(retryCounter, e, "create");
                        break;
                    }
                    default: {
                        throw e;
                    }
                }
                retryCounter.sleepUntilNextRetry();
                isRetry = true;
                continue;
            }
            break;
        }
    }

    private String createSequential(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        RetryCounter retryCounter = this.retryCounterFactory.create();
        boolean first = true;
        String newPath = path + this.identifier;
        while (true) {
            try {
                String previousResult;
                if (!first && (previousResult = this.findPreviousSequentialNode(newPath)) != null) {
                    return previousResult;
                }
                first = false;
                return this.checkZk().create(newPath, data, acl, createMode);
            }
            catch (KeeperException e) {
                switch (e.code()) {
                    case CONNECTIONLOSS: 
                    case OPERATIONTIMEOUT: {
                        this.retryOrThrow(retryCounter, e, "create");
                        break;
                    }
                    default: {
                        throw e;
                    }
                }
                retryCounter.sleepUntilNextRetry();
                continue;
            }
            break;
        }
    }

    private Iterable<Op> prepareZKMulti(Iterable<Op> ops) throws UnsupportedOperationException {
        if (ops == null) {
            return null;
        }
        LinkedList<Op> preparedOps = new LinkedList<Op>();
        for (Op op : ops) {
            if (op.getType() == 1) {
                CreateRequest create = (CreateRequest)op.toRequestRecord();
                preparedOps.add(Op.create((String)create.getPath(), (byte[])this.appendMetaData(create.getData()), (List)create.getAcl(), (int)create.getFlags()));
                continue;
            }
            if (op.getType() == 2) {
                preparedOps.add(op);
                continue;
            }
            if (op.getType() == 5) {
                SetDataRequest setData = (SetDataRequest)op.toRequestRecord();
                preparedOps.add(Op.setData((String)setData.getPath(), (byte[])this.appendMetaData(setData.getData()), (int)setData.getVersion()));
                continue;
            }
            throw new UnsupportedOperationException("Unexpected ZKOp type: " + op.getClass().getName());
        }
        return preparedOps;
    }

    public List<OpResult> multi(Iterable<Op> ops) throws KeeperException, InterruptedException {
        try (TraceScope traceScope = null;){
            traceScope = Trace.startSpan("RecoverableZookeeper.multi");
            RetryCounter retryCounter = this.retryCounterFactory.create();
            Iterable<Op> multiOps = this.prepareZKMulti(ops);
            while (true) {
                try {
                    List list = this.checkZk().multi(multiOps);
                    return list;
                }
                catch (KeeperException e) {
                    switch (e.code()) {
                        case CONNECTIONLOSS: 
                        case OPERATIONTIMEOUT: {
                            this.retryOrThrow(retryCounter, e, "multi");
                            break;
                        }
                        default: {
                            throw e;
                        }
                    }
                    retryCounter.sleepUntilNextRetry();
                    continue;
                }
                break;
            }
        }
    }

    private String findPreviousSequentialNode(String path) throws KeeperException, InterruptedException {
        int lastSlashIdx = path.lastIndexOf(47);
        assert (lastSlashIdx != -1);
        String parent = path.substring(0, lastSlashIdx);
        String nodePrefix = path.substring(lastSlashIdx + 1);
        List nodes = this.checkZk().getChildren(parent, false);
        List<String> matching = RecoverableZooKeeper.filterByPrefix(nodes, nodePrefix);
        for (String node : matching) {
            String nodePath = parent + "/" + node;
            Stat stat = this.checkZk().exists(nodePath, false);
            if (stat == null) continue;
            return nodePath;
        }
        return null;
    }

    public byte[] removeMetaData(byte[] data) {
        if (data == null || data.length == 0) {
            return data;
        }
        byte magic = data[0];
        if (magic != -1) {
            return data;
        }
        int idLength = Bytes.toInt(data, 1);
        int dataLength = data.length - 1 - 4 - idLength;
        int dataOffset = 5 + idLength;
        byte[] newData = new byte[dataLength];
        System.arraycopy(data, dataOffset, newData, 0, dataLength);
        return newData;
    }

    private byte[] appendMetaData(byte[] data) {
        if (data == null || data.length == 0) {
            return data;
        }
        byte[] salt = Bytes.toBytes(this.salter.nextLong());
        int idLength = this.id.length + salt.length;
        byte[] newData = new byte[5 + idLength + data.length];
        int pos = 0;
        pos = Bytes.putByte(newData, pos, (byte)-1);
        pos = Bytes.putInt(newData, pos, idLength);
        pos = Bytes.putBytes(newData, pos, this.id, 0, this.id.length);
        pos = Bytes.putBytes(newData, pos, salt, 0, salt.length);
        pos = Bytes.putBytes(newData, pos, data, 0, data.length);
        return newData;
    }

    public synchronized long getSessionId() {
        return this.zk == null ? -1L : this.zk.getSessionId();
    }

    public synchronized void close() throws InterruptedException {
        if (this.zk != null) {
            this.zk.close();
        }
    }

    public synchronized ZooKeeper.States getState() {
        return this.zk == null ? null : this.zk.getState();
    }

    public synchronized ZooKeeper getZooKeeper() {
        return this.zk;
    }

    public synchronized byte[] getSessionPasswd() {
        return this.zk == null ? null : this.zk.getSessionPasswd();
    }

    public void sync(String path, AsyncCallback.VoidCallback cb, Object ctx) throws KeeperException {
        this.checkZk().sync(path, null, null);
    }

    private static List<String> filterByPrefix(List<String> nodes, String ... prefixes) {
        ArrayList<String> lockChildren = new ArrayList<String>();
        block0: for (String child : nodes) {
            for (String prefix : prefixes) {
                if (!child.startsWith(prefix)) continue;
                lockChildren.add(child);
                continue block0;
            }
        }
        return lockChildren;
    }

    public String getIdentifier() {
        return this.identifier;
    }
}

