/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.internal.compiler;

import com.facebook.airlift.bytecode.Access;
import com.facebook.airlift.bytecode.BytecodeBlock;
import com.facebook.airlift.bytecode.BytecodeNode;
import com.facebook.airlift.bytecode.BytecodeUtils;
import com.facebook.airlift.bytecode.ClassDefinition;
import com.facebook.airlift.bytecode.ClassGenerator;
import com.facebook.airlift.bytecode.DynamicClassLoader;
import com.facebook.airlift.bytecode.FieldDefinition;
import com.facebook.airlift.bytecode.MethodDefinition;
import com.facebook.airlift.bytecode.Parameter;
import com.facebook.airlift.bytecode.ParameterizedType;
import com.facebook.airlift.bytecode.Variable;
import com.facebook.airlift.bytecode.control.IfStatement;
import com.facebook.airlift.bytecode.control.SwitchStatement;
import com.facebook.airlift.bytecode.control.WhileLoop;
import com.facebook.airlift.bytecode.expression.BytecodeExpression;
import com.facebook.airlift.bytecode.expression.BytecodeExpressions;
import com.facebook.airlift.bytecode.instruction.LabelNode;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.codec.ThriftProtocolType;
import com.facebook.drift.codec.internal.ProtocolReader;
import com.facebook.drift.codec.internal.ProtocolWriter;
import com.facebook.drift.codec.metadata.DefaultThriftTypeReference;
import com.facebook.drift.codec.metadata.FieldKind;
import com.facebook.drift.codec.metadata.ReflectionHelper;
import com.facebook.drift.codec.metadata.ThriftConstructorInjection;
import com.facebook.drift.codec.metadata.ThriftExtraction;
import com.facebook.drift.codec.metadata.ThriftFieldExtractor;
import com.facebook.drift.codec.metadata.ThriftFieldInjection;
import com.facebook.drift.codec.metadata.ThriftFieldMetadata;
import com.facebook.drift.codec.metadata.ThriftInjection;
import com.facebook.drift.codec.metadata.ThriftMethodExtractor;
import com.facebook.drift.codec.metadata.ThriftMethodInjection;
import com.facebook.drift.codec.metadata.ThriftParameterInjection;
import com.facebook.drift.codec.metadata.ThriftStructMetadata;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.codec.metadata.ThriftTypeReference;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ThriftCodecByteCodeGenerator<T> {
    private static final String PACKAGE = "$drift";
    private static final Map<ThriftProtocolType, Method> READ_METHODS;
    private static final Map<ThriftProtocolType, Method> WRITE_METHODS;
    private static final Map<Type, Method> ARRAY_READ_METHODS;
    private static final Map<Type, Method> ARRAY_WRITE_METHODS;
    private static final Method OPTIONAL_READ_METHOD;
    private static final Method OPTIONAL_WRITE_METHOD;
    private final ThriftCodecManager codecManager;
    private final ThriftStructMetadata metadata;
    private final ParameterizedType structType;
    private final ClassDefinition classDefinition;
    private final ConstructorParameters parameters = new ConstructorParameters();
    private final FieldDefinition typeField;
    private final Map<Short, FieldDefinition> codecFields;
    private final ThriftCodec<T> thriftCodec;

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    public ThriftCodecByteCodeGenerator(ThriftCodecManager codecManager, ThriftStructMetadata metadata, DynamicClassLoader classLoader, boolean debug) {
        this.codecManager = codecManager;
        this.metadata = metadata;
        this.structType = ParameterizedType.type(metadata.getStructClass());
        this.classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.SUPER}), ThriftCodecByteCodeGenerator.toCodecType(metadata).getClassName(), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(ThriftCodec.class, (ParameterizedType[])new ParameterizedType[]{this.structType})});
        this.typeField = this.declareTypeField();
        this.codecFields = this.declareCodecFields();
        this.defineConstructor();
        this.defineGetTypeMethod();
        switch (metadata.getMetadataType()) {
            case STRUCT: {
                this.defineReadStructMethod();
                this.defineWriteStructMethod();
                break;
            }
            case UNION: {
                this.defineReadUnionMethod();
                this.defineWriteUnionMethod();
                break;
            }
            default: {
                throw new IllegalStateException(String.format("encountered type %s", new Object[]{metadata.getMetadataType()}));
            }
        }
        this.defineReadBridgeMethod();
        this.defineWriteBridgeMethod();
        if (debug) {
            System.out.println(BytecodeUtils.dumpBytecodeTree((ClassDefinition)this.classDefinition));
        }
        Class codecClass = ClassGenerator.classGenerator((DynamicClassLoader)classLoader).runAsmVerifier(debug).dumpRawBytecode(debug).outputTo((Writer)new PrintWriter(System.out)).defineClass(this.classDefinition, Object.class);
        try {
            Class<?>[] types = this.parameters.getTypes();
            Constructor constructor = codecClass.getConstructor(types);
            this.thriftCodec = (ThriftCodec)constructor.newInstance(this.parameters.getValues());
        }
        catch (Exception e) {
            throw new IllegalStateException("Generated class is invalid", e);
        }
    }

    public ThriftCodec<T> getThriftCodec() {
        return this.thriftCodec;
    }

    private FieldDefinition declareTypeField() {
        FieldDefinition typeField = this.classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "type", ParameterizedType.type(ThriftType.class));
        this.parameters.add(typeField, ThriftType.struct(this.metadata));
        return typeField;
    }

    private Map<Short, FieldDefinition> declareCodecFields() {
        TreeMap<Short, FieldDefinition> codecFields = new TreeMap<Short, FieldDefinition>();
        for (ThriftFieldMetadata fieldMetadata : this.metadata.getFields()) {
            if (!ThriftCodecByteCodeGenerator.needsCodec(fieldMetadata)) continue;
            ThriftCodec<?> codec = this.codecManager.getCodec(fieldMetadata.getThriftType());
            String fieldName = fieldMetadata.getName() + "Codec";
            FieldDefinition codecField = this.classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), fieldName, ParameterizedType.type(codec.getClass()));
            codecFields.put(fieldMetadata.getId(), codecField);
            this.parameters.add(codecField, codec);
        }
        return codecFields;
    }

    private void defineConstructor() {
        List arguments = (List)this.parameters.getFields().stream().map(field -> Parameter.arg((String)field.getName(), (ParameterizedType)field.getType())).collect(ImmutableList.toImmutableList());
        MethodDefinition constructor = this.classDefinition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), (Iterable)arguments);
        constructor.getBody().comment("super()").append((BytecodeNode)constructor.getThis()).invokeConstructor(Object.class, new Class[0]);
        for (int i = 0; i < this.parameters.getFields().size(); ++i) {
            FieldDefinition field2 = this.parameters.getFields().get(i);
            Parameter argument = (Parameter)arguments.get(i);
            constructor.getBody().append((BytecodeNode)constructor.getThis().setField(field2, (BytecodeExpression)argument));
        }
        constructor.getBody().ret();
    }

    private void defineGetTypeMethod() {
        MethodDefinition method = this.classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getType", ParameterizedType.type(ThriftType.class), new Parameter[0]);
        method.getBody().append((BytecodeNode)method.getThis().getField(this.typeField).ret());
    }

    private void defineReadStructMethod() {
        Parameter protocol = Parameter.arg((String)"protocol", TProtocolReader.class);
        MethodDefinition method = this.classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "read", this.structType, new Parameter[]{protocol}).addException(Exception.class);
        Variable reader = method.getScope().declareVariable(ProtocolReader.class, "reader");
        method.getBody().append((BytecodeNode)reader.set(BytecodeExpressions.newInstance(ProtocolReader.class, (BytecodeExpression[])new BytecodeExpression[]{protocol})));
        Map<Short, Variable> structData = this.readFieldValues(method, reader);
        Variable result = this.buildStruct(method, structData);
        method.getBody().append((BytecodeNode)result.ret());
    }

    private Map<Short, Variable> readFieldValues(MethodDefinition method, Variable reader) {
        TreeMap<Short, Variable> structData = new TreeMap<Short, Variable>();
        for (ThriftFieldMetadata field : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            Variable variable = method.getScope().declareVariable(ThriftCodecByteCodeGenerator.toParameterizedType(field.getThriftType()), "f_" + field.getName());
            structData.put(field.getId(), variable);
            method.getBody().append((BytecodeNode)variable.set(BytecodeExpressions.defaultValue((ParameterizedType)variable.getType())));
        }
        method.getBody().append((BytecodeNode)reader.invoke("readStructBegin", Void.TYPE, new BytecodeExpression[0]));
        WhileLoop whileLoop = new WhileLoop().condition((BytecodeNode)reader.invoke("nextField", Boolean.TYPE, new BytecodeExpression[0]));
        SwitchStatement.SwitchBuilder switchBuilder = SwitchStatement.switchBuilder().expression(reader.invoke("getFieldId", Short.TYPE, new BytecodeExpression[0]));
        this.buildFieldIdSwitch(method, reader, structData, switchBuilder);
        switchBuilder.defaultCase((BytecodeNode)new BytecodeBlock().append((BytecodeNode)reader.invoke("skipFieldData", Void.TYPE, new BytecodeExpression[0])));
        whileLoop.body((BytecodeNode)switchBuilder.build());
        method.getBody().append((BytecodeNode)whileLoop);
        method.getBody().append((BytecodeNode)reader.invoke("readStructEnd", Void.TYPE, new BytecodeExpression[0]));
        return structData;
    }

    private Variable buildStruct(MethodDefinition read, Map<Short, Variable> structData) {
        Variable instance = this.constructStructInstance(read, structData);
        this.injectStructFields(read, instance, structData);
        this.injectStructMethods(read, instance, structData);
        instance = this.invokeFactoryMethod(read, structData, instance);
        return instance;
    }

    private Variable constructStructInstance(MethodDefinition method, Map<Short, Variable> structData) {
        BytecodeExpression value;
        Variable instance;
        ArrayList<BytecodeExpression> parameters = new ArrayList<BytecodeExpression>();
        ThriftConstructorInjection constructor = this.metadata.getConstructorInjection().get();
        for (ThriftParameterInjection parameter : constructor.getParameters()) {
            BytecodeExpression data = (BytecodeExpression)structData.get(parameter.getId());
            FieldDefinition codecField = this.codecFields.get(parameter.getId());
            if (codecField != null) {
                BytecodeExpression codec = method.getThis().getField(codecField);
                data = BytecodeExpressions.inlineIf((BytecodeExpression)BytecodeExpressions.isNull((BytecodeExpression)data), (BytecodeExpression)codec.invoke("getType", ThriftType.class, new BytecodeExpression[0]).invoke("getNullValue", Object.class, new BytecodeExpression[0]).cast(data.getType()), (BytecodeExpression)data);
            }
            parameters.add(data);
        }
        if (this.metadata.getBuilderClass() == null) {
            instance = method.getScope().declareVariable(this.structType, "instance");
            value = BytecodeExpressions.newInstance(constructor.getConstructor(), parameters);
        } else {
            instance = method.getScope().declareVariable(this.metadata.getBuilderClass(), "builder");
            value = BytecodeExpressions.newInstance(this.metadata.getBuilderClass(), parameters);
        }
        method.getBody().append((BytecodeNode)instance.set(value));
        return instance;
    }

    private void injectStructFields(MethodDefinition method, Variable instance, Map<Short, Variable> structData) {
        for (ThriftFieldMetadata field : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            method.getBody().append((BytecodeNode)ThriftCodecByteCodeGenerator.injectField(field, instance, structData.get(field.getId())));
        }
    }

    private void injectStructMethods(MethodDefinition method, Variable instance, Map<Short, Variable> structData) {
        for (ThriftMethodInjection methodInjection : this.metadata.getMethodInjections()) {
            method.getBody().append((BytecodeNode)ThriftCodecByteCodeGenerator.injectMethod(methodInjection, instance, structData));
        }
    }

    private void defineReadUnionMethod() {
        Parameter protocol = Parameter.arg((String)"protocol", TProtocolReader.class);
        MethodDefinition method = this.classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "read", this.structType, new Parameter[]{protocol}).addException(Exception.class);
        Variable reader = method.getScope().declareVariable(ParameterizedType.type(ProtocolReader.class), "reader");
        method.getBody().append((BytecodeNode)reader.set(BytecodeExpressions.newInstance(ProtocolReader.class, (BytecodeExpression[])new BytecodeExpression[]{protocol})));
        Variable fieldId = method.getScope().declareVariable(Short.TYPE, "fieldId");
        method.getBody().append((BytecodeNode)fieldId.set(BytecodeExpressions.defaultValue((ParameterizedType)fieldId.getType())));
        Map<Short, Variable> unionData = this.readSingleFieldValue(method, reader, fieldId);
        Variable result = this.buildUnion(method, fieldId, unionData);
        method.getBody().append((BytecodeNode)result.ret());
    }

    private Map<Short, Variable> readSingleFieldValue(MethodDefinition method, Variable reader, Variable fieldId) {
        TreeMap<Short, Variable> unionData = new TreeMap<Short, Variable>();
        for (ThriftFieldMetadata field : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            Variable variable = method.getScope().declareVariable(ThriftCodecByteCodeGenerator.toParameterizedType(field.getThriftType()), "f_" + field.getName());
            unionData.put(field.getId(), variable);
            method.getBody().append((BytecodeNode)variable.set(BytecodeExpressions.defaultValue((ParameterizedType)variable.getType())));
        }
        method.getBody().append((BytecodeNode)reader.invoke("readStructBegin", Void.TYPE, new BytecodeExpression[0]));
        WhileLoop whileLoop = new WhileLoop().condition((BytecodeNode)reader.invoke("nextField", Boolean.TYPE, new BytecodeExpression[0]));
        whileLoop.body().append((BytecodeNode)fieldId.set(reader.invoke("getFieldId", Short.TYPE, new BytecodeExpression[0])));
        SwitchStatement.SwitchBuilder switchBuilder = SwitchStatement.switchBuilder().expression((BytecodeExpression)fieldId);
        this.buildFieldIdSwitch(method, reader, unionData, switchBuilder);
        switchBuilder.defaultCase((BytecodeNode)new BytecodeBlock().append((BytecodeNode)reader.invoke("skipFieldData", Void.TYPE, new BytecodeExpression[0])));
        whileLoop.body().append((BytecodeNode)switchBuilder.build());
        method.getBody().append((BytecodeNode)whileLoop);
        method.getBody().append((BytecodeNode)reader.invoke("readStructEnd", Void.TYPE, new BytecodeExpression[0]));
        return unionData;
    }

    private Variable buildUnion(MethodDefinition method, Variable fieldId, Map<Short, Variable> unionData) {
        Variable instance = this.constructUnionInstance(method, fieldId, unionData);
        SwitchStatement.SwitchBuilder switchBuilder = SwitchStatement.switchBuilder().expression((BytecodeExpression)fieldId);
        for (ThriftFieldMetadata field : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            BytecodeBlock block = ThriftCodecByteCodeGenerator.injectField(field, instance, unionData.get(field.getId()));
            field.getMethodInjection().ifPresent(injection -> block.append((BytecodeNode)ThriftCodecByteCodeGenerator.injectMethod(injection, instance, unionData)));
            switchBuilder.addCase((int)field.getId(), (BytecodeNode)block);
        }
        method.getBody().append((BytecodeNode)switchBuilder.build());
        ThriftFieldMetadata idField = (ThriftFieldMetadata)Iterables.getOnlyElement(this.metadata.getFields(FieldKind.THRIFT_UNION_ID));
        ThriftCodecByteCodeGenerator.injectIdField(method, idField, instance, fieldId);
        this.invokeFactoryMethod(method, unionData, instance);
        return instance;
    }

    private Variable constructUnionInstance(MethodDefinition method, Variable fieldId, Map<Short, Variable> unionData) {
        Variable instance = this.metadata.getBuilderClass() == null ? method.getScope().declareVariable(this.structType, "instance") : method.getScope().declareVariable(this.metadata.getBuilderClass(), "builder");
        SwitchStatement.SwitchBuilder switchBuilder = SwitchStatement.switchBuilder().expression((BytecodeExpression)fieldId);
        for (ThriftFieldMetadata field : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            field.getConstructorInjection().ifPresent(constructor -> {
                Variable fieldValue = (Variable)unionData.get(field.getId());
                switchBuilder.addCase((int)field.getId(), (BytecodeNode)new BytecodeBlock().append((BytecodeNode)instance.set(BytecodeExpressions.newInstance(constructor.getConstructor(), (BytecodeExpression[])new BytecodeExpression[]{fieldValue}))));
            });
        }
        BytecodeBlock defaultBlock = new BytecodeBlock();
        if (this.metadata.getConstructorInjection().isPresent()) {
            ThriftConstructorInjection constructor2 = this.metadata.getConstructorInjection().get();
            defaultBlock.append((BytecodeNode)instance.set(BytecodeExpressions.newInstance(constructor2.getConstructor(), (BytecodeExpression[])new BytecodeExpression[0])));
        } else {
            BytecodeExpression exception = BytecodeExpressions.newInstance(IllegalStateException.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.invokeStatic(String.class, (String)"format", String.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantString((String)"No constructor for union [%s] with field ID [%s] found"), BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(Object[].class), (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantString((String)this.metadata.getStructClass().getName()), fieldId.cast(Object.class)})})});
            defaultBlock.append((BytecodeNode)exception).throwObject();
        }
        method.getBody().append((BytecodeNode)switchBuilder.defaultCase((BytecodeNode)defaultBlock).build());
        return instance;
    }

    private static BytecodeBlock injectField(ThriftFieldMetadata field, Variable instance, Variable sourceVariable) {
        BytecodeBlock block = new BytecodeBlock();
        for (ThriftInjection injection : field.getInjections()) {
            if (!(injection instanceof ThriftFieldInjection)) continue;
            ThriftFieldInjection fieldInjection = (ThriftFieldInjection)injection;
            BytecodeBlock writeField = new BytecodeBlock().append((BytecodeNode)instance.setField(fieldInjection.getField(), (BytecodeExpression)sourceVariable));
            if (!fieldInjection.getField().getType().isPrimitive()) {
                writeField = new IfStatement().condition((BytecodeNode)BytecodeExpressions.isNotNull((BytecodeExpression)sourceVariable)).ifTrue((BytecodeNode)writeField);
            }
            block.append((BytecodeNode)writeField);
        }
        return block;
    }

    private void buildFieldIdSwitch(MethodDefinition method, Variable reader, Map<Short, Variable> structData, SwitchStatement.SwitchBuilder switchBuilder) {
        for (ThriftFieldMetadata field : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            Method readMethod = this.getReadMethod(field.getThriftType());
            if (readMethod == null) {
                throw new IllegalArgumentException("Unsupported field type " + (Object)((Object)field.getThriftType().getProtocolType()));
            }
            FieldDefinition codecField = this.codecFields.get(field.getId());
            BytecodeExpression result = codecField != null ? reader.invoke(readMethod, new BytecodeExpression[]{method.getThis().getField(codecField)}) : reader.invoke(readMethod, new BytecodeExpression[0]);
            if (ThriftCodecByteCodeGenerator.needsCastAfterRead(field, readMethod)) {
                result = result.cast(ThriftCodecByteCodeGenerator.toParameterizedType(field.getThriftType()));
            }
            if (field.getCoercion().isPresent()) {
                result = BytecodeExpressions.invokeStatic((Method)field.getCoercion().get().getFromThrift(), (BytecodeExpression[])new BytecodeExpression[]{result});
            }
            switchBuilder.addCase((int)field.getId(), (BytecodeNode)new BytecodeBlock().append((BytecodeNode)structData.get(field.getId()).set(result)));
        }
    }

    private static BytecodeBlock injectMethod(ThriftMethodInjection methodInjection, Variable instance, Map<Short, Variable> structData) {
        String methodName = methodInjection.getMethod().toGenericString();
        LabelNode invokeLabel = new LabelNode("invoke_" + methodName);
        LabelNode skipInvokeLabel = new LabelNode("skip_invoke_" + methodName);
        BytecodeBlock read = new BytecodeBlock();
        for (ThriftParameterInjection parameter : methodInjection.getParameters()) {
            if (!ThriftCodecByteCodeGenerator.isParameterTypeJavaPrimitive(parameter)) {
                read.getVariable(structData.get(parameter.getId())).ifNotNullGoto(invokeLabel);
                continue;
            }
            read.gotoLabel(invokeLabel);
        }
        read.gotoLabel(skipInvokeLabel);
        read.visitLabel(invokeLabel).getVariable(instance);
        for (ThriftParameterInjection parameter : methodInjection.getParameters()) {
            read.getVariable(structData.get(parameter.getId()));
        }
        read.invokeVirtual(methodInjection.getMethod());
        if (methodInjection.getMethod().getReturnType() != Void.TYPE) {
            read.pop();
        }
        read.visitLabel(skipInvokeLabel);
        return read;
    }

    private Variable invokeFactoryMethod(MethodDefinition method, Map<Short, Variable> structData, Variable instance) {
        if (this.metadata.getBuilderMethod().isPresent()) {
            ThriftMethodInjection builderMethod = this.metadata.getBuilderMethod().get();
            List parameters = (List)builderMethod.getParameters().stream().map(ThriftParameterInjection::getId).map(structData::get).collect(ImmutableList.toImmutableList());
            BytecodeExpression result = instance.invoke(builderMethod.getMethod(), (Iterable)parameters);
            instance = method.getScope().declareVariable(this.structType, "instance");
            method.getBody().append((BytecodeNode)instance.set(result));
        }
        return instance;
    }

    private static void injectIdField(MethodDefinition method, ThriftFieldMetadata field, Variable instance, Variable fieldId) {
        for (ThriftInjection injection : field.getInjections()) {
            if (!(injection instanceof ThriftFieldInjection)) continue;
            ThriftFieldInjection fieldInjection = (ThriftFieldInjection)injection;
            BytecodeBlock writeField = new BytecodeBlock().append((BytecodeNode)instance.setField(fieldInjection.getField(), (BytecodeExpression)fieldId));
            if (!fieldInjection.getField().getType().isPrimitive()) {
                writeField = new IfStatement().condition((BytecodeNode)BytecodeExpressions.isNotNull((BytecodeExpression)fieldId)).ifTrue((BytecodeNode)writeField);
            }
            method.getBody().append((BytecodeNode)writeField);
        }
    }

    private void defineWriteStructMethod() {
        Parameter struct = Parameter.arg((String)"struct", (ParameterizedType)this.structType);
        Parameter protocol = Parameter.arg((String)"protocol", TProtocolWriter.class);
        MethodDefinition method = this.classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "write", null, new Parameter[]{struct, protocol});
        BytecodeBlock body = method.getBody();
        Variable writer = method.getScope().declareVariable(ParameterizedType.type(ProtocolWriter.class), "writer");
        body.append((BytecodeNode)writer.set(BytecodeExpressions.newInstance(ProtocolWriter.class, (BytecodeExpression[])new BytecodeExpression[]{protocol})));
        body.append((BytecodeNode)writer.invoke("writeStructBegin", Void.TYPE, new BytecodeExpression[]{BytecodeExpressions.constantString((String)this.metadata.getStructName())}));
        for (ThriftFieldMetadata field : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            body.append((BytecodeNode)this.writeField(method, writer, field));
        }
        body.append((BytecodeNode)writer.invoke("writeStructEnd", Void.TYPE, new BytecodeExpression[0]));
        body.ret();
    }

    private void defineWriteUnionMethod() {
        Parameter struct = Parameter.arg((String)"struct", (ParameterizedType)this.structType);
        Parameter protocol = Parameter.arg((String)"protocol", TProtocolWriter.class);
        MethodDefinition method = this.classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "write", null, new Parameter[]{struct, protocol});
        BytecodeBlock body = method.getBody();
        Variable writer = method.getScope().declareVariable(ParameterizedType.type(ProtocolWriter.class), "writer");
        body.append((BytecodeNode)writer.set(BytecodeExpressions.newInstance(ProtocolWriter.class, (BytecodeExpression[])new BytecodeExpression[]{protocol})));
        body.append((BytecodeNode)writer.invoke("writeStructBegin", Void.TYPE, new BytecodeExpression[]{BytecodeExpressions.constantString((String)this.metadata.getStructName())}));
        ThriftFieldMetadata idField = (ThriftFieldMetadata)Iterables.getOnlyElement(this.metadata.getFields(FieldKind.THRIFT_UNION_ID));
        BytecodeExpression value = this.getFieldValue(method, idField);
        SwitchStatement.SwitchBuilder switchBuilder = SwitchStatement.switchBuilder().expression(value);
        for (ThriftFieldMetadata field : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            switchBuilder.addCase((int)field.getId(), (BytecodeNode)this.writeField(method, writer, field));
        }
        method.getBody().append((BytecodeNode)switchBuilder.build());
        body.append((BytecodeNode)writer.invoke("writeStructEnd", Void.TYPE, new BytecodeExpression[0]));
        body.ret();
    }

    private BytecodeBlock writeField(MethodDefinition method, Variable writer, ThriftFieldMetadata field) {
        Method writeMethod;
        LabelNode fieldIsNull = new LabelNode("field_is_null_" + field.getName());
        LabelNode fieldEnd = new LabelNode("field_end_" + field.getName());
        BytecodeBlock write = new BytecodeBlock();
        write.getVariable(writer);
        write.push(field.getName());
        write.push((int)field.getId());
        FieldDefinition codecField = this.codecFields.get(field.getId());
        if (codecField != null) {
            write.append((BytecodeNode)method.getThis().getField(codecField));
        }
        write.append((BytecodeNode)this.getFieldValue(method, field));
        if (!ThriftCodecByteCodeGenerator.isFieldTypeJavaPrimitive(field)) {
            write.dup();
            write.ifNullGoto(fieldIsNull);
        }
        if (field.getCoercion().isPresent()) {
            write.invokeStatic(field.getCoercion().get().getToThrift());
            if (!ThriftCodecByteCodeGenerator.isProtocolTypeJavaPrimitive(field)) {
                write.dup();
                write.ifNullGoto(fieldIsNull);
            }
        }
        if ((writeMethod = this.getWriteMethod(field.getThriftType())) == null) {
            throw new IllegalArgumentException("Unsupported field type " + (Object)((Object)field.getThriftType().getProtocolType()));
        }
        write.invokeVirtual(writeMethod);
        if (!ThriftCodecByteCodeGenerator.isProtocolTypeJavaPrimitive(field) || !ThriftCodecByteCodeGenerator.isFieldTypeJavaPrimitive(field)) {
            write.gotoLabel(fieldEnd);
            write.visitLabel(fieldIsNull);
            write.pop();
            if (codecField != null) {
                write.pop();
            }
            write.pop();
            write.pop();
            write.pop();
            write.visitLabel(fieldEnd);
        }
        return write;
    }

    private BytecodeExpression getFieldValue(MethodDefinition method, ThriftFieldMetadata field) {
        Variable value = method.getScope().getVariable("struct");
        if (field.getExtraction().isPresent()) {
            ThriftExtraction extraction = field.getExtraction().get();
            if (extraction instanceof ThriftFieldExtractor) {
                ThriftFieldExtractor fieldExtractor = (ThriftFieldExtractor)extraction;
                value = value.getField(fieldExtractor.getField());
                if (fieldExtractor.isGeneric()) {
                    value = value.cast(ParameterizedType.type(fieldExtractor.getType()));
                }
            } else if (extraction instanceof ThriftMethodExtractor) {
                ThriftMethodExtractor methodExtractor = (ThriftMethodExtractor)extraction;
                value = value.invoke(methodExtractor.getMethod(), new BytecodeExpression[0]);
                if (methodExtractor.isGeneric()) {
                    value = value.cast(ParameterizedType.type(methodExtractor.getType()));
                }
            }
        }
        return value;
    }

    private void defineReadBridgeMethod() {
        Parameter protocol = Parameter.arg((String)"protocol", TProtocolReader.class);
        MethodDefinition method = new MethodDefinition(this.classDefinition, Access.a((Access[])new Access[]{Access.PUBLIC, Access.BRIDGE, Access.SYNTHETIC}), "read", ParameterizedType.type(Object.class), new Parameter[]{protocol}).addException(Exception.class);
        method.getBody().append((BytecodeNode)method.getThis().invoke("read", this.structType, (Iterable)ImmutableList.of((Object)protocol)).ret());
        this.classDefinition.addMethod(method);
    }

    private void defineWriteBridgeMethod() {
        Parameter struct = Parameter.arg((String)"struct", Object.class);
        Parameter protocol = Parameter.arg((String)"protocol", TProtocolWriter.class);
        MethodDefinition method = new MethodDefinition(this.classDefinition, Access.a((Access[])new Access[]{Access.PUBLIC, Access.BRIDGE, Access.SYNTHETIC}), "write", null, new Parameter[]{struct, protocol}).addException(Exception.class);
        method.getBody().append((BytecodeNode)method.getThis().invoke("write", ParameterizedType.type(Void.TYPE), (Iterable)ImmutableList.of((Object)this.structType, (Object)protocol.getType()), (Iterable)ImmutableList.of((Object)struct.cast(this.structType), (Object)protocol)).ret());
        this.classDefinition.addMethod(method);
    }

    private static boolean isParameterTypeJavaPrimitive(ThriftParameterInjection parameter) {
        return ThriftCodecByteCodeGenerator.isJavaPrimitive(TypeToken.of((Type)parameter.getJavaType()));
    }

    private static boolean isFieldTypeJavaPrimitive(ThriftFieldMetadata field) {
        return ThriftCodecByteCodeGenerator.isJavaPrimitive(TypeToken.of((Type)field.getThriftType().getJavaType()));
    }

    private static boolean isProtocolTypeJavaPrimitive(ThriftFieldMetadata field) {
        if (field.getThriftType().isCoerced()) {
            return ThriftCodecByteCodeGenerator.isJavaPrimitive(TypeToken.of((Type)field.getThriftType().getUncoercedType().getJavaType()));
        }
        return ThriftCodecByteCodeGenerator.isJavaPrimitive(TypeToken.of((Type)field.getThriftType().getJavaType()));
    }

    private static boolean isJavaPrimitive(TypeToken<?> typeToken) {
        return typeToken.getRawType().isPrimitive();
    }

    private static boolean needsCastAfterRead(ThriftFieldMetadata field, Method readMethod) {
        Class<?> methodReturn = readMethod.getReturnType();
        Class<?> fieldType = field.getCoercion().isPresent() ? field.getCoercion().get().getFromThrift().getParameterTypes()[0] : TypeToken.of((Type)field.getThriftType().getJavaType()).getRawType();
        return !fieldType.isAssignableFrom(methodReturn);
    }

    private static boolean needsCodec(ThriftFieldMetadata fieldMetadata) {
        Type javaType = fieldMetadata.getThriftType().getJavaType();
        if (ReflectionHelper.isArray(javaType)) {
            return false;
        }
        if (ThriftCodecByteCodeGenerator.isOptionalWrapper(javaType)) {
            return true;
        }
        ThriftProtocolType protocolType = fieldMetadata.getThriftType().getProtocolType();
        return protocolType == ThriftProtocolType.ENUM || protocolType == ThriftProtocolType.STRUCT || protocolType == ThriftProtocolType.SET || protocolType == ThriftProtocolType.LIST || protocolType == ThriftProtocolType.MAP;
    }

    private static ParameterizedType toCodecType(ThriftStructMetadata metadata) {
        String className = ParameterizedType.getPathName(metadata.getStructClass()) + "Codec";
        Type type = metadata.getStructType();
        if (type instanceof java.lang.reflect.ParameterizedType) {
            className = className + Arrays.stream(((java.lang.reflect.ParameterizedType)type).getActualTypeArguments()).map(arg -> arg.getTypeName().replaceAll("[^a-zA-Z0-9]+", "_")).collect(Collectors.joining("$", "$$", ""));
        }
        return ParameterizedType.typeFromPathName((String)("$drift/" + className));
    }

    private static boolean isOptionalWrapper(Type javaType) {
        return ReflectionHelper.isOptional(javaType) || javaType == OptionalDouble.class || javaType == OptionalInt.class || javaType == OptionalLong.class;
    }

    public static ParameterizedType toParameterizedType(ThriftType type) {
        return ThriftCodecByteCodeGenerator.toParameterizedType(new DefaultThriftTypeReference(type));
    }

    public static ParameterizedType toParameterizedType(ThriftTypeReference typeRef) {
        if (ReflectionHelper.isArray(typeRef.getJavaType())) {
            return ParameterizedType.type((Class)((Class)typeRef.getJavaType()));
        }
        if (ReflectionHelper.isOptional(typeRef.getJavaType())) {
            return ParameterizedType.type(Optional.class, (ParameterizedType[])new ParameterizedType[]{ThriftCodecByteCodeGenerator.toParameterizedType(typeRef.get().getValueTypeReference())});
        }
        switch (typeRef.getProtocolType()) {
            case BOOL: 
            case BYTE: 
            case DOUBLE: 
            case I16: 
            case I32: 
            case I64: 
            case STRING: 
            case BINARY: 
            case STRUCT: 
            case ENUM: {
                return ParameterizedType.type((Class)((Class)typeRef.getJavaType()));
            }
            case MAP: {
                return ParameterizedType.type(Map.class, (ParameterizedType[])new ParameterizedType[]{ThriftCodecByteCodeGenerator.toParameterizedType(typeRef.get().getKeyTypeReference()), ThriftCodecByteCodeGenerator.toParameterizedType(typeRef.get().getValueTypeReference())});
            }
            case SET: {
                return ParameterizedType.type(Set.class, (ParameterizedType[])new ParameterizedType[]{ThriftCodecByteCodeGenerator.toParameterizedType(typeRef.get().getValueTypeReference())});
            }
            case LIST: {
                return ParameterizedType.type(List.class, (ParameterizedType[])new ParameterizedType[]{ThriftCodecByteCodeGenerator.toParameterizedType(typeRef.get().getValueTypeReference())});
            }
        }
        throw new IllegalArgumentException("Unsupported thrift field type " + typeRef.getJavaType());
    }

    private Method getWriteMethod(ThriftType thriftType) {
        if (ReflectionHelper.isArray(thriftType.getJavaType())) {
            return ARRAY_WRITE_METHODS.get(thriftType.getJavaType());
        }
        if (ThriftCodecByteCodeGenerator.isOptionalWrapper(thriftType.getJavaType())) {
            return OPTIONAL_WRITE_METHOD;
        }
        return WRITE_METHODS.get((Object)thriftType.getProtocolType());
    }

    private Method getReadMethod(ThriftType thriftType) {
        if (ReflectionHelper.isArray(thriftType.getJavaType())) {
            return ARRAY_READ_METHODS.get(thriftType.getJavaType());
        }
        if (ThriftCodecByteCodeGenerator.isOptionalWrapper(thriftType.getJavaType())) {
            return OPTIONAL_READ_METHOD;
        }
        return READ_METHODS.get((Object)thriftType.getProtocolType());
    }

    static {
        ImmutableMap.Builder writeBuilder = ImmutableMap.builder();
        ImmutableMap.Builder readBuilder = ImmutableMap.builder();
        try {
            writeBuilder.put((Object)ThriftProtocolType.BOOL, (Object)ProtocolWriter.class.getMethod("writeBoolField", String.class, Short.TYPE, Boolean.TYPE));
            writeBuilder.put((Object)ThriftProtocolType.BYTE, (Object)ProtocolWriter.class.getMethod("writeByteField", String.class, Short.TYPE, Byte.TYPE));
            writeBuilder.put((Object)ThriftProtocolType.DOUBLE, (Object)ProtocolWriter.class.getMethod("writeDoubleField", String.class, Short.TYPE, Double.TYPE));
            writeBuilder.put((Object)ThriftProtocolType.I16, (Object)ProtocolWriter.class.getMethod("writeI16Field", String.class, Short.TYPE, Short.TYPE));
            writeBuilder.put((Object)ThriftProtocolType.I32, (Object)ProtocolWriter.class.getMethod("writeI32Field", String.class, Short.TYPE, Integer.TYPE));
            writeBuilder.put((Object)ThriftProtocolType.I64, (Object)ProtocolWriter.class.getMethod("writeI64Field", String.class, Short.TYPE, Long.TYPE));
            writeBuilder.put((Object)ThriftProtocolType.STRING, (Object)ProtocolWriter.class.getMethod("writeStringField", String.class, Short.TYPE, String.class));
            writeBuilder.put((Object)ThriftProtocolType.BINARY, (Object)ProtocolWriter.class.getMethod("writeBinaryField", String.class, Short.TYPE, ByteBuffer.class));
            writeBuilder.put((Object)ThriftProtocolType.STRUCT, (Object)ProtocolWriter.class.getMethod("writeStructField", String.class, Short.TYPE, ThriftCodec.class, Object.class));
            writeBuilder.put((Object)ThriftProtocolType.MAP, (Object)ProtocolWriter.class.getMethod("writeMapField", String.class, Short.TYPE, ThriftCodec.class, Map.class));
            writeBuilder.put((Object)ThriftProtocolType.SET, (Object)ProtocolWriter.class.getMethod("writeSetField", String.class, Short.TYPE, ThriftCodec.class, Set.class));
            writeBuilder.put((Object)ThriftProtocolType.LIST, (Object)ProtocolWriter.class.getMethod("writeListField", String.class, Short.TYPE, ThriftCodec.class, List.class));
            writeBuilder.put((Object)ThriftProtocolType.ENUM, (Object)ProtocolWriter.class.getMethod("writeEnumField", String.class, Short.TYPE, ThriftCodec.class, Enum.class));
            readBuilder.put((Object)ThriftProtocolType.BOOL, (Object)ProtocolReader.class.getMethod("readBoolField", new Class[0]));
            readBuilder.put((Object)ThriftProtocolType.BYTE, (Object)ProtocolReader.class.getMethod("readByteField", new Class[0]));
            readBuilder.put((Object)ThriftProtocolType.DOUBLE, (Object)ProtocolReader.class.getMethod("readDoubleField", new Class[0]));
            readBuilder.put((Object)ThriftProtocolType.I16, (Object)ProtocolReader.class.getMethod("readI16Field", new Class[0]));
            readBuilder.put((Object)ThriftProtocolType.I32, (Object)ProtocolReader.class.getMethod("readI32Field", new Class[0]));
            readBuilder.put((Object)ThriftProtocolType.I64, (Object)ProtocolReader.class.getMethod("readI64Field", new Class[0]));
            readBuilder.put((Object)ThriftProtocolType.STRING, (Object)ProtocolReader.class.getMethod("readStringField", new Class[0]));
            readBuilder.put((Object)ThriftProtocolType.BINARY, (Object)ProtocolReader.class.getMethod("readBinaryField", new Class[0]));
            readBuilder.put((Object)ThriftProtocolType.STRUCT, (Object)ProtocolReader.class.getMethod("readStructField", ThriftCodec.class));
            readBuilder.put((Object)ThriftProtocolType.MAP, (Object)ProtocolReader.class.getMethod("readMapField", ThriftCodec.class));
            readBuilder.put((Object)ThriftProtocolType.SET, (Object)ProtocolReader.class.getMethod("readSetField", ThriftCodec.class));
            readBuilder.put((Object)ThriftProtocolType.LIST, (Object)ProtocolReader.class.getMethod("readListField", ThriftCodec.class));
            readBuilder.put((Object)ThriftProtocolType.ENUM, (Object)ProtocolReader.class.getMethod("readEnumField", ThriftCodec.class));
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        WRITE_METHODS = writeBuilder.build();
        READ_METHODS = readBuilder.build();
        ImmutableMap.Builder arrayWriteBuilder = ImmutableMap.builder();
        ImmutableMap.Builder arrayReadBuilder = ImmutableMap.builder();
        try {
            arrayWriteBuilder.put(boolean[].class, (Object)ProtocolWriter.class.getMethod("writeBoolArrayField", String.class, Short.TYPE, boolean[].class));
            arrayWriteBuilder.put(short[].class, (Object)ProtocolWriter.class.getMethod("writeI16ArrayField", String.class, Short.TYPE, short[].class));
            arrayWriteBuilder.put(int[].class, (Object)ProtocolWriter.class.getMethod("writeI32ArrayField", String.class, Short.TYPE, int[].class));
            arrayWriteBuilder.put(long[].class, (Object)ProtocolWriter.class.getMethod("writeI64ArrayField", String.class, Short.TYPE, long[].class));
            arrayWriteBuilder.put(double[].class, (Object)ProtocolWriter.class.getMethod("writeDoubleArrayField", String.class, Short.TYPE, double[].class));
            arrayReadBuilder.put(boolean[].class, (Object)ProtocolReader.class.getMethod("readBoolArrayField", new Class[0]));
            arrayReadBuilder.put(short[].class, (Object)ProtocolReader.class.getMethod("readI16ArrayField", new Class[0]));
            arrayReadBuilder.put(int[].class, (Object)ProtocolReader.class.getMethod("readI32ArrayField", new Class[0]));
            arrayReadBuilder.put(long[].class, (Object)ProtocolReader.class.getMethod("readI64ArrayField", new Class[0]));
            arrayReadBuilder.put(double[].class, (Object)ProtocolReader.class.getMethod("readDoubleArrayField", new Class[0]));
            arrayWriteBuilder.put(byte[].class, (Object)ProtocolWriter.class.getMethod("writeBinaryField", String.class, Short.TYPE, ByteBuffer.class));
            arrayReadBuilder.put(byte[].class, (Object)ProtocolReader.class.getMethod("readBinaryField", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        ARRAY_WRITE_METHODS = arrayWriteBuilder.build();
        ARRAY_READ_METHODS = arrayReadBuilder.build();
        try {
            OPTIONAL_READ_METHOD = ProtocolReader.class.getMethod("readField", ThriftCodec.class);
            OPTIONAL_WRITE_METHOD = ProtocolWriter.class.getMethod("writeField", String.class, Short.TYPE, ThriftCodec.class, Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class ConstructorParameters {
        private final List<FieldDefinition> fields = new ArrayList<FieldDefinition>();
        private final List<Object> values = new ArrayList<Object>();

        private ConstructorParameters() {
        }

        private void add(FieldDefinition field, Object value) {
            this.fields.add(field);
            this.values.add(value);
        }

        public List<FieldDefinition> getFields() {
            return this.fields;
        }

        public Object[] getValues() {
            return this.values.toArray(new Object[0]);
        }

        public Class<?>[] getTypes() {
            return (Class[])this.values.stream().map(Object::getClass).toArray(Class[]::new);
        }
    }
}

