/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.OrcFile;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.Reader;
import com.facebook.hive.orc.RecordReader;
import com.facebook.hive.orc.lazy.OrcLazyRow;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.InputFormatChecker;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;

public class OrcInputFormat
extends FileInputFormat<NullWritable, OrcLazyRow>
implements InputFormatChecker {
    public OrcInputFormat() {
        this.setMinSplitSize(16384L);
    }

    private static void includeColumnRecursive(List<OrcProto.Type> types, boolean[] result, int typeId) {
        result[typeId] = true;
        OrcProto.Type type = types.get(typeId);
        int children = type.getSubtypesCount();
        for (int i = 0; i < children; ++i) {
            OrcInputFormat.includeColumnRecursive(types, result, type.getSubtypes(i));
        }
    }

    private static boolean[] findIncludedColumns(List<OrcProto.Type> types, Configuration conf) {
        String includedStr = conf.get("hive.io.file.readcolumn.ids");
        if (includedStr == null || includedStr.trim().length() == 0) {
            return null;
        }
        int numColumns = types.size();
        boolean[] result = new boolean[numColumns];
        result[0] = true;
        OrcProto.Type root = types.get(0);
        List included = ColumnProjectionUtils.getReadColumnIDs((Configuration)conf);
        for (int i = 0; i < root.getSubtypesCount(); ++i) {
            if (!included.contains(i)) continue;
            OrcInputFormat.includeColumnRecursive(types, result, root.getSubtypes(i));
        }
        for (boolean include : result) {
            if (include) continue;
            return result;
        }
        return null;
    }

    public org.apache.hadoop.mapred.RecordReader<NullWritable, OrcLazyRow> getRecordReader(InputSplit inputSplit, JobConf conf, Reporter reporter) throws IOException {
        FileSplit fileSplit = (FileSplit)inputSplit;
        Path path = fileSplit.getPath();
        FileSystem fs = path.getFileSystem((Configuration)conf);
        reporter.setStatus(fileSplit.toString());
        return new OrcRecordReader(OrcFile.createReader(fs, path, (Configuration)conf), (Configuration)conf, fileSplit.getStart(), fileSplit.getLength());
    }

    public boolean validateInput(FileSystem fs, HiveConf conf, ArrayList<FileStatus> files) throws IOException {
        if (files.size() <= 0) {
            return false;
        }
        for (FileStatus file : files) {
            try {
                OrcFile.createReader(fs, file.getPath(), (Configuration)conf);
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    static class OrcRecordReader
    implements org.apache.hadoop.mapred.RecordReader<NullWritable, OrcLazyRow> {
        private final RecordReader reader;
        private final long offset;
        private final long length;
        private float progress = 0.0f;

        OrcRecordReader(Reader file, Configuration conf, long offset, long length) throws IOException {
            this.reader = file.rows(offset, length, OrcInputFormat.findIncludedColumns(file.getTypes(), conf));
            this.offset = offset;
            this.length = length;
        }

        public boolean next(NullWritable key, OrcLazyRow value) throws IOException {
            if (this.reader.hasNext()) {
                this.reader.next(value);
                this.progress = this.reader.getProgress();
                return true;
            }
            return false;
        }

        public NullWritable createKey() {
            return NullWritable.get();
        }

        public OrcLazyRow createValue() {
            return this.reader.getReader();
        }

        public long getPos() throws IOException {
            return this.offset + (long)(this.progress * (float)this.length);
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public float getProgress() throws IOException {
            return this.progress;
        }
    }
}

