/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hadoop.HadoopNative;
import com.facebook.presto.hive.ForMetastoreHdfsEnvironment;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.authentication.GenericExceptionAction;
import com.facebook.presto.hive.authentication.HdfsAuthentication;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.HadoopExtendedFileSystemCache;
import org.apache.hadoop.fs.Path;

public class HdfsEnvironment {
    private final HdfsConfiguration hdfsConfiguration;
    private final HdfsAuthentication hdfsAuthentication;
    private final boolean verifyChecksum;

    @Inject
    public HdfsEnvironment(@ForMetastoreHdfsEnvironment HdfsConfiguration hdfsConfiguration, MetastoreClientConfig config, HdfsAuthentication hdfsAuthentication) {
        this.hdfsConfiguration = Objects.requireNonNull(hdfsConfiguration, "hdfsConfiguration is null");
        this.verifyChecksum = Objects.requireNonNull(config, "config is null").isVerifyChecksum();
        this.hdfsAuthentication = Objects.requireNonNull(hdfsAuthentication, "hdfsAuthentication is null");
        if (config.isRequireHadoopNative()) {
            HadoopNative.requireHadoopNative();
        }
    }

    public Configuration getConfiguration(HdfsContext context, Path path) {
        return this.hdfsConfiguration.getConfiguration(context, path.toUri());
    }

    public ExtendedFileSystem getFileSystem(HdfsContext context, Path path) throws IOException {
        return this.getFileSystem(context.getIdentity().getUser(), path, this.getConfiguration(context, path));
    }

    public ExtendedFileSystem getFileSystem(String user, Path path, Configuration configuration) throws IOException {
        return this.hdfsAuthentication.doAs(user, () -> {
            FileSystem fileSystem = path.getFileSystem(configuration);
            fileSystem.setVerifyChecksum(this.verifyChecksum);
            Preconditions.checkState((boolean)(fileSystem instanceof ExtendedFileSystem));
            return (ExtendedFileSystem)fileSystem;
        });
    }

    public <R, E extends Exception> R doAs(String user, GenericExceptionAction<R, E> action) throws E {
        return this.hdfsAuthentication.doAs(user, action);
    }

    public void doAs(String user, Runnable action) {
        this.hdfsAuthentication.doAs(user, action);
    }

    static {
        HadoopExtendedFileSystemCache.initialize();
    }
}

