/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.hive.ColumnConverter;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.metastore.Column;
import com.google.common.base.Strings;
import java.util.Optional;
import org.apache.hadoop.hive.metastore.api.FieldSchema;

public class HiveColumnConverter
implements ColumnConverter {
    @Override
    public Column toColumn(FieldSchema fieldSchema) {
        return new Column(fieldSchema.getName(), HiveType.valueOf(fieldSchema.getType()), Optional.ofNullable(Strings.emptyToNull((String)fieldSchema.getComment())), Optional.empty());
    }

    @Override
    public FieldSchema fromColumn(Column column) {
        return new FieldSchema(column.getName(), column.getType().getHiveTypeName().toString(), (String)column.getComment().orElse(null));
    }

    @Override
    public TypeSignature getTypeSignature(HiveType hiveType, Optional<String> typeMetadata) {
        return hiveType.getTypeSignature();
    }

    @Override
    public Optional<String> getTypeMetadata(HiveType hiveType, TypeSignature typeSignature) {
        return Optional.empty();
    }
}

