/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorCommitHandle;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.joda.time.DateTime;

public class HiveCommitHandle
implements ConnectorCommitHandle {
    public static final HiveCommitHandle EMPTY_HIVE_COMMIT_HANDLE = new HiveCommitHandle((Map<SchemaTableName, List<DateTime>>)ImmutableMap.of());
    private static final int JSON_LENGTH_LIMIT = Math.toIntExact(new DataSize(10.0, DataSize.Unit.MEGABYTE).toBytes());
    private static final JsonCodec<Object> JSON_CODEC = JsonCodec.jsonCodec(Object.class);
    private final Map<SchemaTableName, List<DateTime>> lastDataCommitTimes;

    public HiveCommitHandle(Map<SchemaTableName, List<DateTime>> lastDataCommitTimes) {
        this.lastDataCommitTimes = Objects.requireNonNull(lastDataCommitTimes, "lastDataCommitTimes is null");
    }

    public String getSerializedCommitOutput(SchemaTableName table) {
        Optional serializedCommitOutput = JSON_CODEC.toJsonWithLengthLimit(this.lastDataCommitTimes.get(table), JSON_LENGTH_LIMIT);
        return serializedCommitOutput.orElse("");
    }
}

