/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.file;

import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.PrincipalType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class PermissionMetadata {
    private final HivePrivilegeInfo.HivePrivilege permission;
    private final boolean grantOption;

    @JsonCreator
    public PermissionMetadata(@JsonProperty(value="permission") HivePrivilegeInfo.HivePrivilege permission, @JsonProperty(value="grantOption") boolean grantOption) {
        this.permission = Objects.requireNonNull(permission, "permission is null");
        this.grantOption = grantOption;
    }

    public PermissionMetadata(HivePrivilegeInfo privilegeInfo) {
        this.permission = privilegeInfo.getHivePrivilege();
        this.grantOption = privilegeInfo.isGrantOption();
    }

    @JsonProperty
    public HivePrivilegeInfo.HivePrivilege getPermission() {
        return this.permission;
    }

    @JsonProperty
    public boolean isGrantOption() {
        return this.grantOption;
    }

    public HivePrivilegeInfo toHivePrivilegeInfo(String user) {
        return new HivePrivilegeInfo(this.permission, this.grantOption, new PrestoPrincipal(PrincipalType.USER, user), new PrestoPrincipal(PrincipalType.USER, user));
    }
}

