/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.glue.converter;

import com.amazonaws.services.glue.model.Order;
import com.amazonaws.services.glue.model.SerDeInfo;
import com.amazonaws.services.glue.model.StorageDescriptor;
import com.facebook.presto.hive.BucketFunctionType;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.SortingColumn;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.util.Memoizers;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.security.PrincipalType;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public final class GlueToPrestoConverter {
    private static final String PUBLIC_OWNER = "PUBLIC";

    private GlueToPrestoConverter() {
    }

    public static Database convertDatabase(com.amazonaws.services.glue.model.Database glueDb) {
        return Database.builder().setDatabaseName(glueDb.getName()).setLocation(Optional.ofNullable(glueDb.getLocationUri())).setComment(Optional.ofNullable(glueDb.getDescription())).setParameters(GlueToPrestoConverter.convertParameters(glueDb.getParameters())).setOwnerName(PUBLIC_OWNER).setOwnerType(PrincipalType.ROLE).build();
    }

    public static Table convertTable(com.amazonaws.services.glue.model.Table glueTable, String dbName) {
        Objects.requireNonNull(glueTable.getStorageDescriptor(), "Table StorageDescriptor is null");
        StorageDescriptor sd = glueTable.getStorageDescriptor();
        Table.Builder tableBuilder = Table.builder().setDatabaseName(dbName).setTableName(glueTable.getName()).setOwner(Strings.nullToEmpty((String)glueTable.getOwner())).setTableType(PrestoTableType.optionalValueOf(glueTable.getTableType()).orElse(PrestoTableType.EXTERNAL_TABLE)).setDataColumns(GlueToPrestoConverter.convertColumns(sd.getColumns())).setParameters(GlueToPrestoConverter.convertParameters(glueTable.getParameters())).setViewOriginalText(Optional.ofNullable(glueTable.getViewOriginalText())).setViewExpandedText(Optional.ofNullable(glueTable.getViewExpandedText()));
        if (glueTable.getPartitionKeys() != null) {
            tableBuilder.setPartitionColumns(GlueToPrestoConverter.convertColumns(glueTable.getPartitionKeys()));
        } else {
            tableBuilder.setPartitionColumns((List<Column>)ImmutableList.of());
        }
        new StorageConverter().setConvertedStorage(sd, tableBuilder.getStorageBuilder());
        return tableBuilder.build();
    }

    private static Column convertColumn(com.amazonaws.services.glue.model.Column glueColumn) {
        return new Column(glueColumn.getName(), HiveType.valueOf(glueColumn.getType().toLowerCase(Locale.ENGLISH)), Optional.ofNullable(glueColumn.getComment()), Optional.empty());
    }

    private static List<Column> convertColumns(List<com.amazonaws.services.glue.model.Column> glueColumns) {
        return GlueToPrestoConverter.mappedCopy(glueColumns, GlueToPrestoConverter::convertColumn);
    }

    private static Map<String, String> convertParameters(Map<String, String> input) {
        if (input == null || input.isEmpty()) {
            return ImmutableMap.of();
        }
        return ImmutableMap.copyOf(input);
    }

    private static Function<Map<String, String>, Map<String, String>> parametersConverter() {
        return Memoizers.memoizeLast(GlueToPrestoConverter::convertParameters);
    }

    private static boolean isNullOrEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    public static <T, R> List<R> mappedCopy(List<T> list, Function<T, R> mapper) {
        Objects.requireNonNull(list, "list is null");
        Objects.requireNonNull(mapper, "mapper is null");
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)list.size());
        for (T item : list) {
            builder.add(mapper.apply(item));
        }
        return builder.build();
    }

    static /* synthetic */ Function access$100() {
        return GlueToPrestoConverter.parametersConverter();
    }

    private static final class StorageFormatConverter {
        private static final StorageFormat ALL_NULLS = StorageFormat.createNullable(null, null, null);
        private final UnaryOperator<String> serializationLib = Memoizers.memoizeLast();
        private final UnaryOperator<String> inputFormat = Memoizers.memoizeLast();
        private final UnaryOperator<String> outputFormat = Memoizers.memoizeLast();
        private final UnaryOperator<StorageFormat> storageFormat = Memoizers.memoizeLast();

        private StorageFormatConverter() {
        }

        public StorageFormat createStorageFormat(SerDeInfo serdeInfo, StorageDescriptor storageDescriptor) {
            String serializationLib = (String)this.serializationLib.apply(serdeInfo.getSerializationLibrary());
            String inputFormat = (String)this.inputFormat.apply(storageDescriptor.getInputFormat());
            String outputFormat = (String)this.outputFormat.apply(storageDescriptor.getOutputFormat());
            if (serializationLib == null && inputFormat == null && outputFormat == null) {
                return ALL_NULLS;
            }
            return (StorageFormat)this.storageFormat.apply(StorageFormat.createNullable(serializationLib, inputFormat, outputFormat));
        }
    }

    private static final class StorageConverter {
        private final Function<List<String>, List<String>> bucketColumns = Memoizers.memoizeLast(ImmutableList::copyOf);
        private final Function<List<Order>, List<SortingColumn>> sortColumns = Memoizers.memoizeLast(StorageConverter::createSortingColumns);
        private final UnaryOperator<Optional<HiveBucketProperty>> bucketProperty = Memoizers.memoizeLast();
        private final Function<Map<String, String>, Map<String, String>> serdeParametersConverter = GlueToPrestoConverter.access$100();
        private final Function<Map<String, String>, Map<String, String>> partitionParametersConverter = GlueToPrestoConverter.access$100();
        private final StorageFormatConverter storageFormatConverter = new StorageFormatConverter();

        private StorageConverter() {
        }

        public void setConvertedStorage(StorageDescriptor sd, Storage.Builder storageBuilder) {
            Objects.requireNonNull(sd.getSerdeInfo(), "StorageDescriptor SerDeInfo is null");
            SerDeInfo serdeInfo = sd.getSerdeInfo();
            storageBuilder.setLocation(Strings.nullToEmpty((String)sd.getLocation())).setBucketProperty(this.createBucketProperty(sd)).setSkewed(sd.getSkewedInfo() != null && !GlueToPrestoConverter.isNullOrEmpty(sd.getSkewedInfo().getSkewedColumnNames())).setSerdeParameters(this.serdeParametersConverter.apply(serdeInfo.getParameters())).setParameters(this.partitionParametersConverter.apply(sd.getParameters())).setStorageFormat(this.storageFormatConverter.createStorageFormat(serdeInfo, sd));
        }

        private Optional<HiveBucketProperty> createBucketProperty(StorageDescriptor sd) {
            if (sd.getNumberOfBuckets() > 0) {
                if (GlueToPrestoConverter.isNullOrEmpty(sd.getBucketColumns())) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table/partition metadata has 'numBuckets' set, but 'bucketCols' is not set");
                }
                List<String> bucketColumns = this.bucketColumns.apply(sd.getBucketColumns());
                List<SortingColumn> sortedBy = this.sortColumns.apply(sd.getSortColumns());
                return (Optional)this.bucketProperty.apply(Optional.of(new HiveBucketProperty(bucketColumns, sd.getNumberOfBuckets(), sortedBy, BucketFunctionType.HIVE_COMPATIBLE, Optional.empty())));
            }
            return Optional.empty();
        }

        private static List<SortingColumn> createSortingColumns(List<Order> sortColumns) {
            if (GlueToPrestoConverter.isNullOrEmpty(sortColumns)) {
                return ImmutableList.of();
            }
            return GlueToPrestoConverter.mappedCopy(sortColumns, column -> new SortingColumn(column.getColumn(), SortingColumn.Order.fromMetastoreApiOrder(column.getSortOrder(), "unknown")));
        }
    }

    public static final class GluePartitionConverter
    implements Function<com.amazonaws.services.glue.model.Partition, Partition> {
        private final Function<List<com.amazonaws.services.glue.model.Column>, List<Column>> columnsConverter = Memoizers.memoizeLast(x$0 -> GlueToPrestoConverter.access$200(x$0));
        private final Function<Map<String, String>, Map<String, String>> parametersConverter = GlueToPrestoConverter.access$100();
        private final StorageConverter storageConverter = new StorageConverter();
        private final String databaseName;
        private final String tableName;

        public GluePartitionConverter(String databaseName, String tableName) {
            this.databaseName = Objects.requireNonNull(databaseName, "databaseName is null");
            this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        }

        @Override
        public Partition apply(com.amazonaws.services.glue.model.Partition gluePartition) {
            Objects.requireNonNull(gluePartition.getStorageDescriptor(), "Partition StorageDescriptor is null");
            StorageDescriptor sd = gluePartition.getStorageDescriptor();
            if (!this.databaseName.equals(gluePartition.getDatabaseName())) {
                throw new IllegalArgumentException(String.format("Unexpected databaseName, expected: %s, but found: %s", this.databaseName, gluePartition.getDatabaseName()));
            }
            if (!this.tableName.equals(gluePartition.getTableName())) {
                throw new IllegalArgumentException(String.format("Unexpected tableName, expected: %s, but found: %s", this.tableName, gluePartition.getTableName()));
            }
            Partition.Builder partitionBuilder = Partition.builder().setDatabaseName(this.databaseName).setTableName(this.tableName).setValues(gluePartition.getValues()).setColumns(this.columnsConverter.apply(sd.getColumns())).setParameters(this.parametersConverter.apply(gluePartition.getParameters()));
            this.storageConverter.setConvertedStorage(sd, partitionBuilder.getStorageBuilder());
            return partitionBuilder.build();
        }
    }
}

