/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.rpc.RpcHeader;
import org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.kudu.shaded.com.google.protobuf.TextFormat;
import org.apache.kudu.shaded.io.netty.buffer.ByteBuf;
import org.apache.kudu.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.kudu.shaded.io.netty.handler.codec.MessageToByteEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RpcOutboundMessage {
    private static final Logger LOG = LoggerFactory.getLogger(RpcOutboundMessage.class);
    private final RpcHeader.RequestHeader.Builder headerBuilder;
    private final Message body;

    RpcOutboundMessage(RpcHeader.RequestHeader.Builder header, Message body) {
        this.headerBuilder = header;
        this.body = body;
    }

    public RpcHeader.RequestHeader.Builder getHeaderBuilder() {
        return this.headerBuilder;
    }

    public Message getBody() {
        return this.body;
    }

    public String toString() {
        return "RpcOutboundMessage[header={" + TextFormat.shortDebugString(this.headerBuilder) + "}, body={" + TextFormat.shortDebugString(this.body) + "}]";
    }

    static class Encoder
    extends MessageToByteEncoder<RpcOutboundMessage> {
        Encoder() {
        }

        @Override
        protected void encode(ChannelHandlerContext ctx, RpcOutboundMessage msg, ByteBuf out) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{}: sending RPC {}", (Object)ctx.channel(), (Object)msg);
            }
            KuduRpc.toByteBuf(out, msg.getHeaderBuilder().build(), msg.getBody());
        }
    }
}

