/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.functions;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.functions.ForHiveFunction;
import com.facebook.presto.hive.functions.HiveFunctionNamespaceManager;
import com.facebook.presto.hive.functions.HiveFunctionRegistry;
import com.facebook.presto.hive.functions.StaticHiveFunctionRegistry;
import com.facebook.presto.spi.function.FunctionNamespaceManager;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import java.util.Objects;

public class HiveFunctionModule
extends AbstractConfigurationAwareModule {
    private final String catalogName;
    private final ClassLoader classLoader;
    private final TypeManager typeManager;

    public HiveFunctionModule(String catalogName, ClassLoader classLoader, TypeManager typeManager) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    protected void setup(Binder binder) {
        binder.bind((TypeLiteral)new TypeLiteral<String>(){}).annotatedWith(ForHiveFunction.class).toInstance((Object)this.catalogName);
        binder.bind(HiveFunctionRegistry.class).to(StaticHiveFunctionRegistry.class).in(Scopes.SINGLETON);
        binder.bind(TypeManager.class).toInstance((Object)this.typeManager);
        binder.bind(FunctionNamespaceManager.class).to(HiveFunctionNamespaceManager.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    @ForHiveFunction
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

