/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.functions.scalar;

import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.hive.functions.HiveFunctionErrorCode;
import com.facebook.presto.hive.functions.scalar.ScalarFunctionInvoker;
import com.facebook.presto.hive.functions.type.ObjectEncoder;
import com.facebook.presto.hive.functions.type.ObjectEncoders;
import com.facebook.presto.hive.functions.type.ObjectInputDecoder;
import com.facebook.presto.hive.functions.type.ObjectInputDecoders;
import com.facebook.presto.hive.functions.type.ObjectInspectors;
import com.facebook.presto.hive.functions.type.PrestoTypes;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public class HiveScalarFunctionInvoker
implements ScalarFunctionInvoker {
    private final Signature signature;
    private final Supplier<GenericUDF> udfSupplier;
    private final ObjectInputDecoder[] argumentDecoders;
    private final ObjectEncoder objectEncoder;

    public HiveScalarFunctionInvoker(Signature signature, Supplier<GenericUDF> udfSupplier, ObjectInputDecoder[] argumentDecoders, ObjectEncoder objectEncoder) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.udfSupplier = Objects.requireNonNull(udfSupplier, "udfSupplier is null");
        this.argumentDecoders = Objects.requireNonNull(argumentDecoders, "argumentDecoders is null");
        this.objectEncoder = Objects.requireNonNull(objectEncoder, "objectEncoder is null");
    }

    public static HiveScalarFunctionInvoker createFunctionInvoker(Class<?> cls, QualifiedObjectName name, List<TypeSignature> arguments, TypeManager typeManager) {
        List argumentTypes = arguments.stream().map(arg_0 -> ((TypeManager)typeManager).getType(arg_0)).collect(Collectors.toList());
        try {
            GenericUDF udf = HiveScalarFunctionInvoker.createGenericUDF(name, cls);
            ObjectInspector[] inputInspectors = (ObjectInspector[])argumentTypes.stream().map(argumentType -> ObjectInspectors.create(argumentType, typeManager)).toArray(ObjectInspector[]::new);
            ObjectInspector resultInspector = udf.initialize(inputInspectors);
            Type resultType = PrestoTypes.fromObjectInspector(resultInspector, typeManager);
            ObjectInputDecoder[] argumentDecoders = (ObjectInputDecoder[])argumentTypes.stream().map(argumentsType -> ObjectInputDecoders.createDecoder(argumentsType, typeManager)).toArray(ObjectInputDecoder[]::new);
            ObjectEncoder resultEncoder = ObjectEncoders.createEncoder(resultType, resultInspector);
            Signature signature = new Signature(name, FunctionKind.SCALAR, resultType.getTypeSignature(), arguments);
            ThreadLocal<GenericUDF> genericUDFSupplier = ThreadLocal.withInitial(() -> {
                try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(cls.getClassLoader());){
                    GenericUDF ret = HiveScalarFunctionInvoker.createGenericUDF(name, cls);
                    ret.initialize(inputInspectors);
                    GenericUDF genericUDF = ret;
                    return genericUDF;
                }
                catch (Exception e) {
                    throw HiveFunctionErrorCode.initializationError(e);
                }
            });
            return new HiveScalarFunctionInvoker(signature, genericUDFSupplier::get, argumentDecoders, resultEncoder);
        }
        catch (Exception e) {
            throw HiveFunctionErrorCode.initializationError(e);
        }
    }

    private static GenericUDF createGenericUDF(QualifiedObjectName name, Class<?> cls) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (GenericUDF.class.isAssignableFrom(cls)) {
            Constructor<?> constructor = cls.getConstructor(new Class[0]);
            return (GenericUDF)constructor.newInstance(new Object[0]);
        }
        if (UDF.class.isAssignableFrom(cls)) {
            return new GenericUDFBridge(name.getObjectName(), false, cls.getName());
        }
        throw HiveFunctionErrorCode.unsupportedFunctionType(cls);
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public Object evaluate(Object ... inputs) {
        try {
            GenericUDF.DeferredObject[] objects = new GenericUDF.DeferredObject[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                objects[i] = inputs[i] == null ? new GenericUDF.DeferredJavaObject(null) : new GenericUDF.DeferredJavaObject(this.argumentDecoders[i].decode(inputs[i]));
            }
            Object evaluated = this.udfSupplier.get().evaluate(objects);
            return this.objectEncoder.encode(evaluated);
        }
        catch (HiveException e) {
            throw HiveFunctionErrorCode.executionError(e);
        }
    }
}

