/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.SocketTimeoutException;
import kafka.cluster.BrokerEndPoint;
import kafka.server.BlockingSend;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u000b\u0017\u0001mA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0011!)\u0005A!A!\u0002\u00131\u0005\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\t\u0011U\u0003!\u0011!Q\u0001\nYCQ!\u0017\u0001\u0005\u0002iCqa\u0019\u0001C\u0002\u0013%A\r\u0003\u0004j\u0001\u0001\u0006I!\u001a\u0005\bU\u0002\u0011\r\u0011\"\u0003l\u0011\u0019a\u0007\u0001)A\u0005\r\"QQ\u000e\u0001I\u0001\u0002\u0007\u0005\u000b\u0011\u00028\t\u0013\u00055\u0001A1A\u0005\n\u0005=\u0001bBA\t\u0001\u0001\u0006I!\u001d\u0005\n\u0003'\u0001!\u0019!C\u0005\u0003+Aq!a\u0006\u0001A\u0003%q\u000fC\u0004\u0002\u001a\u0001!\t%a\u0007\t\u000f\u0005\u001d\u0004\u0001\"\u0011\u0002j!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005%$A\u0007*fa2L7-\u0019$fi\u000eDWM\u001d\"m_\u000e\\\u0017N\\4TK:$'BA\f\u0019\u0003\u0019\u0019XM\u001d<fe*\t\u0011$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001a\"\u0005\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0004B]f\u0014VM\u001a\t\u0003G\u0011j\u0011AF\u0005\u0003KY\u0011AB\u00117pG.LgnZ*f]\u0012\fAb]8ve\u000e,'I]8lKJ\u0004\"\u0001K\u0016\u000e\u0003%R!A\u000b\r\u0002\u000f\rdWo\u001d;fe&\u0011A&\u000b\u0002\u000f\u0005J|7.\u001a:F]\u0012\u0004v.\u001b8u\u00031\u0011'o\\6fe\u000e{gNZ5h!\t\u0019s&\u0003\u00021-\tY1*\u00194lC\u000e{gNZ5h\u0003\u001diW\r\u001e:jGN\u0004\"a\r\u001f\u000e\u0003QR!!M\u001b\u000b\u0005Y:\u0014AB2p[6|gN\u0003\u0002\u001aq)\u0011\u0011HO\u0001\u0007CB\f7\r[3\u000b\u0003m\n1a\u001c:h\u0013\tiDGA\u0004NKR\u0014\u0018nY:\u0002\tQLW.\u001a\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005V\nQ!\u001e;jYNL!\u0001R!\u0003\tQKW.Z\u0001\nM\u0016$8\r[3s\u0013\u0012\u0004\"!H$\n\u0005!s\"aA%oi\u0006A1\r\\5f]RLE\r\u0005\u0002L%:\u0011A\n\u0015\t\u0003\u001bzi\u0011A\u0014\u0006\u0003\u001fj\ta\u0001\u0010:p_Rt\u0014BA)\u001f\u0003\u0019\u0001&/\u001a3fM&\u00111\u000b\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Es\u0012A\u00037pO\u000e{g\u000e^3yiB\u0011\u0001iV\u0005\u00031\u0006\u0013!\u0002T8h\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}QA1\fX/_?\u0002\f'\r\u0005\u0002$\u0001!)a\u0005\u0003a\u0001O!)Q\u0006\u0003a\u0001]!)\u0011\u0007\u0003a\u0001e!)a\b\u0003a\u0001\u007f!)Q\t\u0003a\u0001\r\")\u0011\n\u0003a\u0001\u0015\")Q\u000b\u0003a\u0001-\u0006Q1o\\;sG\u0016tu\u000eZ3\u0016\u0003\u0015\u0004\"AZ4\u000e\u0003UJ!\u0001[\u001b\u0003\t9{G-Z\u0001\fg>,(oY3O_\u0012,\u0007%A\u0007t_\u000e\\W\r\u001e+j[\u0016|W\u000f^\u000b\u0002\r\u0006q1o\\2lKR$\u0016.\\3pkR\u0004\u0013a\u0001=%cA!Qd\\9x\u0013\t\u0001hD\u0001\u0004UkBdWM\r\t\u0003eVl\u0011a\u001d\u0006\u0003i^\nqa\u00197jK:$8/\u0003\u0002wg\nia*\u001a;x_J\\7\t\\5f]R\u00042!\b={\u0013\tIhD\u0001\u0004PaRLwN\u001c\n\u0005wv\f9A\u0002\u0003}\u0001\u0001Q(\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004c\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002U\nqA\\3uo>\u00148.C\u0002\u0002\u0006}\u0014ab\u00115b]:,GNQ;jY\u0012,'\u000fE\u0002g\u0003\u0013I1!a\u00036\u00059\u0011VmY8oM&<WO]1cY\u0016\fQB\\3uo>\u00148n\u00117jK:$X#A9\u0002\u001d9,Go^8sW\u000ec\u0017.\u001a8uA\u0005a\"/Z2p]\u001aLw-\u001e:bE2,7\t[1o]\u0016d')^5mI\u0016\u0014X#A<\u0002;I,7m\u001c8gS\u001e,(/\u00192mK\u000eC\u0017M\u001c8fY\n+\u0018\u000e\u001c3fe\u0002\n1b]3oIJ+\u0017/^3tiR!\u0011QDA\u0012!\r\u0011\u0018qD\u0005\u0004\u0003C\u0019(AD\"mS\u0016tGOU3ta>t7/\u001a\u0005\b\u0003K\u0011\u0002\u0019AA\u0014\u00039\u0011X-];fgR\u0014U/\u001b7eKJ\u0004D!!\u000b\u0002TA1\u00111FA%\u0003\u001frA!!\f\u0002D9!\u0011qFA \u001d\u0011\t\t$!\u0010\u000f\t\u0005M\u00121\b\b\u0005\u0003k\tIDD\u0002N\u0003oI\u0011aO\u0005\u0003siJ!!\u0007\u001d\n\u0005Y:\u0014bAA!k\u0005A!/Z9vKN$8/\u0003\u0003\u0002F\u0005\u001d\u0013aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\u000b\u0007\u0005\u0005S'\u0003\u0003\u0002L\u00055#a\u0002\"vS2$WM\u001d\u0006\u0005\u0003\u000b\n9\u0005\u0005\u0003\u0002R\u0005MC\u0002\u0001\u0003\r\u0003+\n\u0019#!A\u0001\u0002\u000b\u0005\u0011q\u000b\u0002\u0004?\u0012\u0012\u0014\u0003BA-\u0003?\u00022!HA.\u0013\r\tiF\b\u0002\b\u001d>$\b.\u001b8h!\u0011\t\t'a\u0019\u000e\u0005\u0005\u001d\u0013\u0002BA3\u0003\u000f\u0012q\"\u00112tiJ\f7\r\u001e*fcV,7\u000f^\u0001\u000eS:LG/[1uK\u000ecwn]3\u0015\u0005\u0005-\u0004cA\u000f\u0002n%\u0019\u0011q\u000e\u0010\u0003\tUs\u0017\u000e^\u0001\u0006G2|7/\u001a")
public class ReplicaFetcherBlockingSend
implements BlockingSend {
    private final BrokerEndPoint sourceBroker;
    private final KafkaConfig brokerConfig;
    private final Time time;
    private final Node sourceNode;
    private final int socketTimeout;
    private final /* synthetic */ Tuple2 x$1;
    private final NetworkClient networkClient;
    private final Option<ChannelBuilder> reconfigurableChannelBuilder;

    private Node sourceNode() {
        return this.sourceNode;
    }

    private int socketTimeout() {
        return this.socketTimeout;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    private Option<ChannelBuilder> reconfigurableChannelBuilder() {
        return this.reconfigurableChannelBuilder;
    }

    @Override
    public ClientResponse sendRequest(AbstractRequest.Builder<? extends AbstractRequest> requestBuilder) {
        ClientResponse clientResponse;
        try {
            if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)this.sourceNode(), (Time)this.time, (long)this.socketTimeout())) {
                throw new SocketTimeoutException(new StringBuilder(28).append("Failed to connect within ").append(this.socketTimeout()).append(" ms").toString());
            }
            ClientRequest clientRequest = this.networkClient().newClientRequest(((Object)BoxesRunTime.boxToInteger((int)this.sourceBroker.id())).toString(), requestBuilder, this.time.milliseconds(), true);
            clientResponse = NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)clientRequest, (Time)this.time);
        }
        catch (Throwable e) {
            this.networkClient().close(((Object)BoxesRunTime.boxToInteger((int)this.sourceBroker.id())).toString());
            throw e;
        }
        return clientResponse;
    }

    @Override
    public void initiateClose() {
        this.reconfigurableChannelBuilder().foreach((Function1 & Serializable & scala.Serializable)reconfigurable -> {
            this.brokerConfig.removeReconfigurable(reconfigurable);
            return BoxedUnit.UNIT;
        });
        this.networkClient().initiateClose();
    }

    @Override
    public void close() {
        this.networkClient().close();
    }

    public ReplicaFetcherBlockingSend(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, Metrics metrics, Time time, int fetcherId, String clientId, LogContext logContext) {
        None$ none$;
        ChannelBuilder channelBuilder;
        this.sourceBroker = sourceBroker;
        this.brokerConfig = brokerConfig;
        this.time = time;
        this.sourceNode = new Node(sourceBroker.id(), sourceBroker.host(), sourceBroker.port());
        this.socketTimeout = Predef$.MODULE$.Integer2int(brokerConfig.replicaSocketTimeoutMs());
        ChannelBuilder channelBuilder2 = channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)brokerConfig.interBrokerSecurityProtocol(), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)brokerConfig, (ListenerName)brokerConfig.interBrokerListenerName(), (String)brokerConfig.saslMechanismInterBrokerProtocol(), (Time)time, (boolean)brokerConfig.saslInterBrokerHandshakeRequestEnable());
        if (channelBuilder2 instanceof Reconfigurable) {
            ChannelBuilder channelBuilder3 = channelBuilder2;
            brokerConfig.addReconfigurable((Reconfigurable)channelBuilder3);
            none$ = new Some((Object)channelBuilder3);
        } else {
            none$ = None$.MODULE$;
        }
        None$ reconfigurableChannelBuilder = none$;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(brokerConfig.connectionsMaxIdleMs()), metrics, time, "replica-fetcher", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)((Object)BoxesRunTime.boxToInteger((int)sourceBroker.id())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fetcher-id"), (Object)((Object)BoxesRunTime.boxToInteger((int)fetcherId)).toString())}))).asJava(), false, channelBuilder, logContext);
        NetworkClient networkClient = new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, 1, 0L, 0L, -1, Predef$.MODULE$.Integer2int(brokerConfig.replicaSocketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(brokerConfig.requestTimeoutMs()), ClientDnsLookup.DEFAULT, time, false, new ApiVersions(), logContext);
        Tuple2 tuple2 = new Tuple2((Object)networkClient, (Object)reconfigurableChannelBuilder);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        NetworkClient networkClient2 = (NetworkClient)tuple2._1();
        Option reconfigurableChannelBuilder2 = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)networkClient2, (Object)reconfigurableChannelBuilder2);
        this.x$1 = tuple22;
        this.networkClient = (NetworkClient)this.x$1._1();
        this.reconfigurableChannelBuilder = (Option)this.x$1._2();
    }
}

