/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.stream;

import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.UnavailableException;
import alluxio.resource.LockResource;
import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.io.grpc.StatusRuntimeException;
import alluxio.shaded.client.io.grpc.stub.ClientCallStreamObserver;
import alluxio.shaded.client.io.grpc.stub.ClientResponseObserver;
import alluxio.shaded.client.io.grpc.stub.StreamObserver;
import alluxio.shaded.client.javax.annotation.concurrent.GuardedBy;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.util.LogUtils;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class GrpcBlockingStream<ReqT, ResT> {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcBlockingStream.class);
    private final StreamObserver<ResT> mResponseObserver;
    private final ClientCallStreamObserver<ReqT> mRequestObserver;
    private final BlockingQueue<Object> mResponses;
    private final String mDescription;
    private volatile boolean mCompleted = false;
    private volatile boolean mClosed = false;
    private volatile boolean mCanceled = false;
    private final ReentrantLock mLock = new ReentrantLock();
    @GuardedBy(value="mLock")
    private Throwable mError;
    private final Condition mReadyOrFailed = this.mLock.newCondition();
    private volatile boolean mClosedFromRemote = false;

    public GrpcBlockingStream(Function<StreamObserver<ResT>, StreamObserver<ReqT>> rpcFunc, int bufferSize, String description) {
        LOG.debug("Opening stream ({})", (Object)description);
        this.mResponses = new ArrayBlockingQueue<Object>(bufferSize);
        this.mResponseObserver = new ResponseStreamObserver();
        this.mRequestObserver = (ClientCallStreamObserver)rpcFunc.apply(this.mResponseObserver);
        this.mDescription = description;
    }

    /*
     * Exception decompiling
     */
    public void send(ReqT request, long timeoutMs) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void send(ReqT request) throws IOException {
        if (this.mClosed || this.mCanceled || this.mClosedFromRemote) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to send request {}: stream is already closed or cancelled. clientClosed: {} clientCancelled: {} serverClosed: {} ({})", new Object[]{LogUtils.truncateMessageLineLength(request), this.mClosed, this.mCanceled, this.mClosedFromRemote, this.mDescription});
            }
            return;
        }
        try (LockResource lr = new LockResource(this.mLock);){
            this.checkError();
        }
        this.mRequestObserver.onNext(request);
    }

    /*
     * Exception decompiling
     */
    public ResT receive(long timeoutMs) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean hasResponseInCache() {
        return !this.mResponses.isEmpty();
    }

    public void close() {
        if (this.isOpen()) {
            LOG.debug("Closing stream ({})", (Object)this.mDescription);
            this.mClosed = true;
            this.mRequestObserver.onCompleted();
        }
    }

    public void cancel() {
        if (this.isOpen()) {
            LOG.debug("Cancelling stream ({})", (Object)this.mDescription);
            this.mCanceled = true;
            this.mRequestObserver.cancel("Request is cancelled by user.", null);
        }
    }

    public void waitForComplete(long timeoutMs) throws IOException {
        if (this.mCompleted || this.mCanceled) {
            return;
        }
        while (this.receive(timeoutMs) != null) {
        }
    }

    public boolean isClosedFromRemote() {
        return this.mClosedFromRemote;
    }

    public boolean isOpen() {
        try (LockResource lr = new LockResource(this.mLock);){
            boolean bl = !this.mClosed && !this.mCanceled && this.mError == null;
            return bl;
        }
    }

    public boolean isClosed() {
        return this.mClosed;
    }

    public boolean isCanceled() {
        return this.mCanceled;
    }

    private void checkError() throws IOException {
        try (LockResource lr = new LockResource(this.mLock);){
            if (this.mError != null) {
                this.mCanceled = true;
                throw this.toAlluxioStatusException(this.mError);
            }
        }
    }

    private AlluxioStatusException toAlluxioStatusException(Throwable t) {
        AlluxioStatusException ex;
        if (t instanceof StatusRuntimeException) {
            ex = AlluxioStatusException.fromStatusRuntimeException((StatusRuntimeException)t);
            if (ex.getStatusCode() == Status.Code.CANCELLED) {
                ex = new UnavailableException(this.formatErrorMessage("Stream is canceled by server.", new Object[0]), ex);
            }
        } else {
            ex = AlluxioStatusException.fromThrowable(this.mError);
        }
        return AlluxioStatusException.from(ex.getStatus().withDescription(this.formatErrorMessage(ex.getMessage(), new Object[0])));
    }

    private String formatErrorMessage(String format, Object ... args) {
        StringBuilder errorMessage = new StringBuilder(format == null ? "Unknown error" : String.format(format, args));
        return new StringBuilder(errorMessage).append(String.format(" (%s)", this.mDescription)).toString();
    }

    private final class ResponseStreamObserver
    implements ClientResponseObserver<ReqT, ResT> {
        private ResponseStreamObserver() {
        }

        @Override
        public void onNext(ResT response) {
            try {
                GrpcBlockingStream.this.mResponses.put(response);
            }
            catch (InterruptedException e) {
                this.handleInterruptedException(e);
            }
        }

        @Override
        public void onError(Throwable t) {
            try (LockResource lr = new LockResource(GrpcBlockingStream.this.mLock);){
                LOG.warn("Received error {} for stream ({})", (Object)t, (Object)GrpcBlockingStream.this.mDescription);
                this.updateException(t);
                GrpcBlockingStream.this.mReadyOrFailed.signal();
            }
        }

        @Override
        public void onCompleted() {
            try {
                LOG.debug("Received completed event for stream ({})", (Object)GrpcBlockingStream.this.mDescription);
                GrpcBlockingStream.this.mResponses.put(this);
                GrpcBlockingStream.this.mClosedFromRemote = true;
            }
            catch (InterruptedException e) {
                this.handleInterruptedException(e);
            }
        }

        @Override
        public void beforeStart(ClientCallStreamObserver<ReqT> requestStream) {
            requestStream.setOnReadyHandler(() -> {
                try (LockResource lr = new LockResource(GrpcBlockingStream.this.mLock);){
                    GrpcBlockingStream.this.mReadyOrFailed.signal();
                }
            });
        }

        private void handleInterruptedException(InterruptedException e) {
            Thread.currentThread().interrupt();
            try (LockResource lr = new LockResource(GrpcBlockingStream.this.mLock);){
                this.updateException(e);
            }
            throw new RuntimeException(e);
        }

        @GuardedBy(value="mLock")
        private void updateException(Throwable e) {
            if (GrpcBlockingStream.this.mError == null || GrpcBlockingStream.this.mError == e) {
                GrpcBlockingStream.this.mError = e;
                GrpcBlockingStream.this.mResponses.offer(e);
            } else {
                GrpcBlockingStream.this.mError.addSuppressed(e);
            }
        }
    }
}

