/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

final class DynamicLongArray {
    static final int DEFAULT_SIZE = 65536;
    private Slice data;
    private int length;

    public DynamicLongArray() {
        this(65536);
    }

    public DynamicLongArray(int size) {
        this.data = Slices.allocate((int)size);
    }

    private void grow(int index) {
        if (index * 8 + 7 >= this.data.length()) {
            int newSize = Math.max(index * 8 + 65536, 2 * this.data.length());
            Slice newSlice = Slices.allocate((int)newSize);
            newSlice.setBytes(0, this.data);
            this.data = newSlice;
        }
    }

    public long get(int index) {
        if (index >= this.length) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of 0.." + (this.length - 1));
        }
        return this.data.getLong(index * 8);
    }

    public void set(int index, long value) {
        this.grow(index);
        if (index >= this.length) {
            this.length = index + 1;
        }
        this.data.setLong(index * 8, value);
    }

    public void increment(int index, long value) {
        this.grow(index);
        if (index >= this.length) {
            this.length = index + 1;
        }
        this.data.setLong(index * 8, this.data.getLong(index * 8) + value);
    }

    public void add(long value) {
        this.grow(this.length);
        this.data.setLong(this.length * 8, value);
        ++this.length;
    }

    public int size() {
        return this.length;
    }

    public void clear() {
        this.length = 0;
        this.data = Slices.allocate((int)65536);
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder(this.length * 4);
        sb.append('{');
        int l = this.length - 1;
        for (i = 0; i < l; ++i) {
            sb.append(this.get(i));
            sb.append(',');
        }
        sb.append(this.get(i));
        sb.append('}');
        return sb.toString();
    }

    public long getSizeInBytes() {
        return this.data.length();
    }
}

