/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.lazy.OrcLazyObjectInspectorUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.Writable;

public final class OrcStruct
implements Writable {
    private Object[] fields;
    private List<String> fieldNames;

    public OrcStruct() {
        this.fields = new Object[0];
        this.fieldNames = new ArrayList<String>();
    }

    public OrcStruct(List<String> fieldNames) {
        this.fields = new Object[fieldNames.size()];
        this.fieldNames = fieldNames;
    }

    public Object getFieldValue(int fieldIndex) {
        return this.fields[fieldIndex];
    }

    public void setFieldValue(int fieldIndex, Object value) {
        this.fields[fieldIndex] = value;
    }

    public int getNumFields() {
        return this.fields.length;
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public void setFieldNames(List<String> fieldNames) {
        this.fieldNames = fieldNames;
        if (this.fields.length != fieldNames.size()) {
            Object[] oldFields = this.fields;
            this.fields = new Object[fieldNames.size()];
            System.arraycopy(oldFields, 0, this.fields, 0, Math.min(oldFields.length, fieldNames.size()));
        }
    }

    public void appendField(String fieldName) {
        this.fieldNames.add(fieldName);
        this.setFieldNames(this.fieldNames);
    }

    public void write(DataOutput dataOutput) throws IOException {
        throw new UnsupportedOperationException("write unsupported");
    }

    public void readFields(DataInput dataInput) throws IOException {
        throw new UnsupportedOperationException("readFields unsupported");
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != OrcStruct.class) {
            return false;
        }
        OrcStruct oth = (OrcStruct)other;
        if (this.fields.length != oth.fields.length) {
            return false;
        }
        for (int i = 0; i < this.fields.length; ++i) {
            if (!(this.fields[i] == null ? oth.fields[i] != null : !this.fields[i].equals(oth.fields[i]))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.fields.length;
        for (Object field : this.fields) {
            if (field == null) continue;
            result ^= field.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{");
        for (int i = 0; i < this.fields.length; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.fields[i]);
        }
        buffer.append("}");
        return buffer.toString();
    }

    public static class OrcListObjectInspector
    implements ListObjectInspector,
    SettableListObjectInspector {
        private final ObjectInspector child;

        public OrcListObjectInspector(ListTypeInfo info) {
            this.child = OrcLazyObjectInspectorUtils.createWritableObjectInspector(info.getListElementTypeInfo());
        }

        public OrcListObjectInspector(int columnId, List<OrcProto.Type> types) {
            OrcProto.Type type = types.get(columnId);
            this.child = OrcLazyObjectInspectorUtils.createWritableObjectInspector(type.getSubtypes(0), types);
        }

        public ObjectInspector getListElementObjectInspector() {
            return this.child;
        }

        public Object getListElement(Object list, int i) {
            return ((List)list).get(i);
        }

        public int getListLength(Object list) {
            return ((List)list).size();
        }

        public List<?> getList(Object list) {
            return (List)list;
        }

        public String getTypeName() {
            return "array<" + this.child.getTypeName() + ">";
        }

        public ObjectInspector.Category getCategory() {
            return ObjectInspector.Category.LIST;
        }

        public Object create(int size) {
            ArrayList<Object> result = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                result.add(null);
            }
            return result;
        }

        public Object set(Object list, int index, Object element) {
            List l = (List)list;
            for (int i = l.size(); i < index + 1; ++i) {
                l.add(null);
            }
            l.set(index, element);
            return list;
        }

        public Object resize(Object list, int newSize) {
            ((ArrayList)list).ensureCapacity(newSize);
            return list;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            if (o == this) {
                return true;
            }
            ObjectInspector other = ((OrcListObjectInspector)o).child;
            return other.equals(this.child);
        }
    }

    public static class OrcMapObjectInspector
    implements MapObjectInspector,
    SettableMapObjectInspector {
        private final ObjectInspector key;
        private final ObjectInspector value;

        public OrcMapObjectInspector(MapTypeInfo info) {
            this.key = OrcLazyObjectInspectorUtils.createWritableObjectInspector(info.getMapKeyTypeInfo());
            this.value = OrcLazyObjectInspectorUtils.createWritableObjectInspector(info.getMapValueTypeInfo());
        }

        public OrcMapObjectInspector(int columnId, List<OrcProto.Type> types) {
            OrcProto.Type type = types.get(columnId);
            this.key = OrcLazyObjectInspectorUtils.createWritableObjectInspector(type.getSubtypes(0), types);
            this.value = OrcLazyObjectInspectorUtils.createWritableObjectInspector(type.getSubtypes(1), types);
        }

        public ObjectInspector getMapKeyObjectInspector() {
            return this.key;
        }

        public ObjectInspector getMapValueObjectInspector() {
            return this.value;
        }

        public Object getMapValueElement(Object map, Object key) {
            return ((Map)map).get(key);
        }

        public Map<Object, Object> getMap(Object map) {
            return (Map)map;
        }

        public int getMapSize(Object map) {
            return ((Map)map).size();
        }

        public String getTypeName() {
            return "map<" + this.key.getTypeName() + "," + this.value.getTypeName() + ">";
        }

        public ObjectInspector.Category getCategory() {
            return ObjectInspector.Category.MAP;
        }

        public Object create() {
            return new HashMap();
        }

        public Object put(Object map, Object key, Object value) {
            ((Map)map).put(key, value);
            return map;
        }

        public Object remove(Object map, Object key) {
            ((Map)map).remove(key);
            return map;
        }

        public Object clear(Object map) {
            ((Map)map).clear();
            return map;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            if (o == this) {
                return true;
            }
            OrcMapObjectInspector other = (OrcMapObjectInspector)o;
            return other.key.equals(this.key) && other.value.equals(this.value);
        }
    }

    public static class OrcStructInspector
    extends SettableStructObjectInspector {
        private final List<StructField> fields;

        public OrcStructInspector(StructTypeInfo info) {
            ArrayList fieldNames = info.getAllStructFieldNames();
            ArrayList fieldTypes = info.getAllStructFieldTypeInfos();
            this.fields = new ArrayList<StructField>(fieldNames.size());
            for (int i = 0; i < fieldNames.size(); ++i) {
                this.fields.add(new Field((String)fieldNames.get(i), OrcLazyObjectInspectorUtils.createWritableObjectInspector((TypeInfo)fieldTypes.get(i)), i));
            }
        }

        public OrcStructInspector(int columnId, List<OrcProto.Type> types) {
            OrcProto.Type type = types.get(columnId);
            int fieldCount = type.getSubtypesCount();
            this.fields = new ArrayList<StructField>(fieldCount);
            for (int i = 0; i < fieldCount; ++i) {
                int fieldType = type.getSubtypes(i);
                this.fields.add(new Field(type.getFieldNames(i), OrcLazyObjectInspectorUtils.createWritableObjectInspector(fieldType, types), i));
            }
        }

        public List<StructField> getAllStructFieldRefs() {
            return this.fields;
        }

        public StructField getStructFieldRef(String s) {
            for (StructField field : this.fields) {
                if (!field.getFieldName().equals(s)) continue;
                return field;
            }
            return null;
        }

        public Object getStructFieldData(Object object, StructField field) {
            OrcStruct struct;
            int offset = ((Field)field).offset;
            if (offset >= (struct = (OrcStruct)object).fields.length) {
                return null;
            }
            return struct.fields[offset];
        }

        public List<Object> getStructFieldsDataAsList(Object object) {
            OrcStruct struct = (OrcStruct)object;
            ArrayList<Object> result = new ArrayList<Object>(struct.fields.length);
            for (Object child : struct.fields) {
                result.add(child);
            }
            return result;
        }

        public String getTypeName() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("struct<");
            for (int i = 0; i < this.fields.size(); ++i) {
                StructField field = this.fields.get(i);
                if (i != 0) {
                    buffer.append(",");
                }
                buffer.append(field.getFieldName());
                buffer.append(":");
                buffer.append(field.getFieldObjectInspector().getTypeName());
            }
            buffer.append(">");
            return buffer.toString();
        }

        public ObjectInspector.Category getCategory() {
            return ObjectInspector.Category.STRUCT;
        }

        public Object create() {
            return new OrcStruct();
        }

        public Object setStructFieldData(Object struct, StructField field, Object fieldValue) {
            OrcStruct orcStruct = (OrcStruct)struct;
            int offset = ((Field)field).offset;
            if (orcStruct.getNumFields() <= offset) {
                orcStruct.appendField(((Field)field).getFieldName());
            }
            orcStruct.setFieldValue(offset, fieldValue);
            return struct;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            if (o == this) {
                return true;
            }
            List<StructField> other = ((OrcStructInspector)((Object)o)).fields;
            if (other.size() != this.fields.size()) {
                return false;
            }
            for (int i = 0; i < this.fields.size(); ++i) {
                StructField left = other.get(i);
                StructField right = this.fields.get(i);
                if (left.getFieldName().equals(right.getFieldName()) && left.getFieldObjectInspector().equals(right.getFieldObjectInspector())) continue;
                return false;
            }
            return true;
        }
    }

    public static class Field
    implements StructField {
        private final String name;
        private final ObjectInspector inspector;
        private final int offset;

        public Field(String name, ObjectInspector inspector, int offset) {
            this.name = name;
            this.inspector = inspector;
            this.offset = offset;
        }

        public String getFieldName() {
            return this.name;
        }

        public ObjectInspector getFieldObjectInspector() {
            return this.inspector;
        }

        public String getFieldComment() {
            return null;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

