/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.metadata;

import com.facebook.drift.annotations.ThriftEnum;
import com.facebook.drift.codec.metadata.ThriftEnumMetadata;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ThriftEnumMetadataBuilder<T extends Enum<T>> {
    private final Class<T> enumClass;
    private final String enumName;

    public static <T extends Enum<T>> ThriftEnumMetadata<T> thriftEnumMetadata(Class<T> enumClass) {
        return super.build();
    }

    private ThriftEnumMetadataBuilder(Class<T> enumClass) {
        this.enumClass = enumClass;
        this.enumName = this.extractEnumName(enumClass);
    }

    private ThriftEnumMetadata<T> build() {
        return new ThriftEnumMetadata<T>(this.enumName, this.enumClass);
    }

    private String extractEnumName(Class<T> enumClass) {
        ThriftEnum annotation = enumClass.getAnnotation(ThriftEnum.class);
        Preconditions.checkArgument((annotation != null ? 1 : 0) != 0, (String)"Enum class %s is not annotated with @ThriftEnum", (Object)enumClass.getName());
        if (!annotation.value().isEmpty()) {
            return annotation.value();
        }
        return enumClass.getSimpleName();
    }
}

