/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.bytecode;

import com.facebook.airlift.bytecode.ClassDefinition;
import com.facebook.airlift.bytecode.DumpBytecodeVisitor;
import com.facebook.airlift.bytecode.ParameterizedType;
import com.google.common.base.CharMatcher;
import java.io.StringWriter;
import java.util.concurrent.atomic.AtomicLong;

public final class BytecodeUtils {
    private static final AtomicLong CLASS_ID = new AtomicLong();

    private BytecodeUtils() {
    }

    public static ParameterizedType uniqueClassName(String basePackage, String baseName) {
        String className = BytecodeUtils.toJavaIdentifierString(baseName) + "_" + CLASS_ID.incrementAndGet();
        return ParameterizedType.typeFromJavaClassName(basePackage + ".$gen." + className);
    }

    public static String toJavaIdentifierString(String className) {
        return CharMatcher.forPredicate(Character::isJavaIdentifierPart).negate().replaceFrom((CharSequence)className, '_');
    }

    public static String dumpBytecodeTree(ClassDefinition classDefinition) {
        StringWriter writer = new StringWriter();
        new DumpBytecodeVisitor(writer).visitClass(classDefinition);
        return writer.toString();
    }
}

