/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import org.roaringbitmap.CharIterator;

final class ReverseBitmapContainerCharIterator
implements CharIterator {
    long word;
    int position;
    long[] bitmap;

    ReverseBitmapContainerCharIterator() {
    }

    ReverseBitmapContainerCharIterator(long[] bitmap) {
        this.wrap(bitmap);
    }

    @Override
    public CharIterator clone() {
        try {
            return (CharIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.position >= 0;
    }

    @Override
    public char next() {
        int shift = Long.numberOfLeadingZeros(this.word) + 1;
        char answer = (char)((this.position + 1) * 64 - shift);
        this.word &= -2L >>> shift;
        while (this.word == 0L) {
            --this.position;
            if (this.position < 0) break;
            this.word = this.bitmap[this.position];
        }
        return answer;
    }

    @Override
    public int nextAsInt() {
        return this.next();
    }

    @Override
    public void remove() {
        throw new RuntimeException("unsupported operation: remove");
    }

    void wrap(long[] b) {
        this.bitmap = b;
        this.position = this.bitmap.length - 1;
        while (this.position >= 0 && (this.word = this.bitmap[this.position]) == 0L) {
            --this.position;
        }
    }
}

