/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal;

import io.delta.standalone.CommitResult;
import io.delta.standalone.DeltaScan;
import io.delta.standalone.Operation;
import io.delta.standalone.OptimisticTransaction;
import io.delta.standalone.exceptions.DeltaStandaloneException;
import io.delta.standalone.expressions.Expression;
import io.delta.standalone.expressions.Literal;
import io.delta.standalone.internal.ConflictChecker;
import io.delta.standalone.internal.CurrentTransactionInfo;
import io.delta.standalone.internal.DeltaConfigs$;
import io.delta.standalone.internal.DeltaLogImpl;
import io.delta.standalone.internal.IsolationLevel;
import io.delta.standalone.internal.Serializable$;
import io.delta.standalone.internal.SnapshotImpl;
import io.delta.standalone.internal.SnapshotIsolation$;
import io.delta.standalone.internal.actions.Action;
import io.delta.standalone.internal.actions.AddFile;
import io.delta.standalone.internal.actions.CommitInfo;
import io.delta.standalone.internal.actions.CommitInfo$;
import io.delta.standalone.internal.actions.FileAction;
import io.delta.standalone.internal.actions.Format;
import io.delta.standalone.internal.actions.Metadata;
import io.delta.standalone.internal.actions.Protocol;
import io.delta.standalone.internal.actions.Protocol$;
import io.delta.standalone.internal.actions.RemoveFile;
import io.delta.standalone.internal.exception.DeltaErrors$;
import io.delta.standalone.internal.logging.Logging;
import io.delta.standalone.internal.scan.DeltaScanImpl;
import io.delta.standalone.internal.util.ConversionUtils$;
import io.delta.standalone.internal.util.DeltaFileOperations$;
import io.delta.standalone.internal.util.FileNames$;
import io.delta.standalone.internal.util.SchemaMergingUtils$;
import io.delta.standalone.internal.util.SchemaUtils$;
import io.delta.standalone.package$;
import io.delta.standalone.types.StructType;
import java.io.Serializable;
import java.nio.file.FileAlreadyExistsException;
import java.util.Iterator;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyBoolean;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tEg!B\u001d;\u0001i\u0012\u0005\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011B,\t\u0011m\u0003!\u0011!Q\u0001\nqCQa\u0018\u0001\u0005\u0002\u0001Dq\u0001\u001a\u0001C\u0002\u0013\u0005Q\r\u0003\u0004m\u0001\u0001\u0006IA\u001a\u0005\b[\u0002\u0011\r\u0011\"\u0003o\u0011\u0019\u0011\b\u0001)A\u0005_\"91\u000f\u0001b\u0001\n\u0013!\bbBA\b\u0001\u0001\u0006I!\u001e\u0005\n\u0003#\u0001!\u0019!C\u0005\u0003'A\u0001\"a\t\u0001A\u0003%\u0011Q\u0003\u0005\n\u0003K\u0001!\u0019!C\u0005\u0003OA\u0001\"a\u000f\u0001A\u0003%\u0011\u0011\u0006\u0005\n\u0003{\u0001\u0001\u0019!C\u0005\u0003\u007fA\u0011\"a\u0012\u0001\u0001\u0004%I!!\u0013\t\u0011\u0005U\u0003\u0001)Q\u0005\u0003\u0003B\u0011\"a\u0016\u0001\u0001\u0004%I!a\u0010\t\u0013\u0005e\u0003\u00011A\u0005\n\u0005m\u0003\u0002CA0\u0001\u0001\u0006K!!\u0011\t\u0013\u0005\u0005\u0004\u00011A\u0005\n\u0005\r\u0004\"CA9\u0001\u0001\u0007I\u0011BA:\u0011!\t9\b\u0001Q!\n\u0005\u0015\u0004\"CA=\u0001\u0001\u0007I\u0011BA>\u0011%\t)\t\u0001a\u0001\n\u0013\t9\t\u0003\u0005\u0002\f\u0002\u0001\u000b\u0015BA?\u0011%\ti\t\u0001a\u0001\n\u0013\ty\u0004C\u0005\u0002\u0010\u0002\u0001\r\u0011\"\u0003\u0002\u0012\"A\u0011Q\u0013\u0001!B\u0013\t\t\u0005C\u0006\u0002\u0018\u0002\u0001\r\u00111A\u0005\n\u0005e\u0005bCAQ\u0001\u0001\u0007\t\u0019!C\u0005\u0003GC1\"a*\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u001c\"9\u0011\u0011\u0016\u0001\u0005\u0002\u0005-\u0006bBAW\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0003c\u0003A\u0011BAM\u0011\u001d\t\u0019\f\u0001C!\u0003kCq!a0\u0001\t\u0003\n\t\rC\u0004\u0002z\u0002!\t%a?\t\u000f\t\u001d\u0001\u0001\"\u0011\u0003\n!9!q\u0002\u0001\u0005B\tE\u0001b\u0002B\n\u0001\u0011\u0005#Q\u0003\u0005\b\u00057\u0001A\u0011\u0002B\u000f\u0011\u001d\u00119\u0004\u0001C\t\u0005sAqAa\u0013\u0001\t\u0013\u0011i\u0005C\u0004\u0003V\u0001!IAa\u0016\t\u000f\tu\u0003\u0001\"\u0003\u0003`!9!q\u000e\u0001\u0005\n\tE\u0004b\u0002B;\u0001\u0011%!q\u000f\u0005\b\u0005\u001f\u0003A\u0011\u0002BI\u0011\u001d\u00119\n\u0001C\u0005\u00033CqA!'\u0001\t\u0013\u0011Y\n\u0003\u0006\u0003 \u0002A)\u0019!C\t\u0005CCqAa)\u0001\t\u0003\u0012)\u000bC\u0004\u00032\u0002!\tEa-\t\u000f\tE\u0006\u0001\"\u0011\u00038\"9!Q\u0019\u0001\u0005B\t\u001d\u0007b\u0002Bc\u0001\u0011\u0005#1\u001a\u0002\u001a\u001fB$\u0018.\\5ti&\u001cGK]1og\u0006\u001cG/[8o\u00136\u0004HN\u0003\u0002<y\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002>}\u0005Q1\u000f^1oI\u0006dwN\\3\u000b\u0005}\u0002\u0015!\u00023fYR\f'\"A!\u0002\u0005%|7\u0003\u0002\u0001D\u0017>\u0003\"\u0001R%\u000e\u0003\u0015S!AR$\u0002\t1\fgn\u001a\u0006\u0002\u0011\u0006!!.\u0019<b\u0013\tQUI\u0001\u0004PE*,7\r\u001e\t\u0003\u00196k\u0011\u0001P\u0005\u0003\u001dr\u0012Qc\u00149uS6L7\u000f^5d)J\fgn]1di&|g\u000e\u0005\u0002Q'6\t\u0011K\u0003\u0002Su\u00059An\\4hS:<\u0017B\u0001+R\u0005\u001daunZ4j]\u001e\f\u0001\u0002Z3mi\u0006dunZ\u0002\u0001!\tA\u0016,D\u0001;\u0013\tQ&H\u0001\u0007EK2$\u0018\rT8h\u00136\u0004H.\u0001\u0005t]\u0006\u00048\u000f[8u!\tAV,\u0003\u0002_u\ta1K\\1qg\"|G/S7qY\u00061A(\u001b8jiz\"2!\u00192d!\tA\u0006\u0001C\u0003V\u0007\u0001\u0007q\u000bC\u0003\\\u0007\u0001\u0007A,A\u0010E\u000b2#\u0016iX'B1~\u0013V\t\u0016*Z?\u000e{U*T%U?\u0006#F+R'Q)N+\u0012A\u001a\t\u0003O*l\u0011\u0001\u001b\u0006\u0002S\u0006)1oY1mC&\u00111\u000e\u001b\u0002\u0004\u0013:$\u0018\u0001\t#F\u0019R\u000bu,T!Y?J+EKU-`\u0007>kU*\u0013+`\u0003R#V)\u0014)U'\u0002\nQ\u0001\u001e=o\u0013\u0012,\u0012a\u001c\t\u0003\tBL!!]#\u0003\rM#(/\u001b8h\u0003\u0019!\bP\\%eA\u00059!/Z1e)btW#A;\u0011\u0007Y\\X0D\u0001x\u0015\tA\u00180A\u0004nkR\f'\r\\3\u000b\u0005iD\u0017AC2pY2,7\r^5p]&\u0011Ap\u001e\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fE\u0002\u007f\u0003\u0017q1a`A\u0004!\r\t\t\u0001[\u0007\u0003\u0003\u0007Q1!!\u0002W\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u00025\u0002\rA\u0013X\rZ3g\u0013\r\t\u0018Q\u0002\u0006\u0004\u0003\u0013A\u0017\u0001\u0003:fC\u0012$\u0006P\u001c\u0011\u0002\u001dI,\u0017\r\u001a)sK\u0012L7-\u0019;fgV\u0011\u0011Q\u0003\t\u0005mn\f9\u0002\u0005\u0003\u0002\u001a\u0005}QBAA\u000e\u0015\r\ti\u0002P\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0003\u0002\"\u0005m!AC#yaJ,7o]5p]\u0006y!/Z1e!J,G-[2bi\u0016\u001c\b%A\u0005sK\u0006$g)\u001b7fgV\u0011\u0011\u0011\u0006\t\u0006m\u0006-\u0012qF\u0005\u0004\u0003[9(a\u0002%bg\"\u001cV\r\u001e\t\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011Q\u0007\u001e\u0002\u000f\u0005\u001cG/[8og&!\u0011\u0011HA\u001a\u0005\u001d\tE\r\u001a$jY\u0016\f!B]3bI\u001aKG.Z:!\u0003E\u0011X-\u00193UQ\u0016<\u0006n\u001c7f)\u0006\u0014G.Z\u000b\u0003\u0003\u0003\u00022aZA\"\u0013\r\t)\u0005\u001b\u0002\b\u0005>|G.Z1o\u0003U\u0011X-\u00193UQ\u0016<\u0006n\u001c7f)\u0006\u0014G.Z0%KF$B!a\u0013\u0002RA\u0019q-!\u0014\n\u0007\u0005=\u0003N\u0001\u0003V]&$\b\"CA*\u001f\u0005\u0005\t\u0019AA!\u0003\rAH%M\u0001\u0013e\u0016\fG\r\u00165f/\"|G.\u001a+bE2,\u0007%A\u0005d_6l\u0017\u000e\u001e;fI\u0006i1m\\7nSR$X\rZ0%KF$B!a\u0013\u0002^!I\u00111\u000b\n\u0002\u0002\u0003\u0007\u0011\u0011I\u0001\u000bG>lW.\u001b;uK\u0012\u0004\u0013a\u00038fo6+G/\u00193bi\u0006,\"!!\u001a\u0011\u000b\u001d\f9'a\u001b\n\u0007\u0005%\u0004N\u0001\u0004PaRLwN\u001c\t\u0005\u0003c\ti'\u0003\u0003\u0002p\u0005M\"\u0001C'fi\u0006$\u0017\r^1\u0002\u001f9,w/T3uC\u0012\fG/Y0%KF$B!a\u0013\u0002v!I\u00111K\u000b\u0002\u0002\u0003\u0007\u0011QM\u0001\r]\u0016<X*\u001a;bI\u0006$\u0018\rI\u0001\f]\u0016<\bK]8u_\u000e|G.\u0006\u0002\u0002~A)q-a\u001a\u0002\u0000A!\u0011\u0011GAA\u0013\u0011\t\u0019)a\r\u0003\u0011A\u0013x\u000e^8d_2\fqB\\3x!J|Go\\2pY~#S-\u001d\u000b\u0005\u0003\u0017\nI\tC\u0005\u0002Ta\t\t\u00111\u0001\u0002~\u0005aa.Z<Qe>$xnY8mA\u0005\u0011\u0012n]\"sK\u0006$\u0018N\\4OK^$\u0016M\u00197f\u0003YI7o\u0011:fCRLgn\u001a(foR\u000b'\r\\3`I\u0015\fH\u0003BA&\u0003'C\u0011\"a\u0015\u001c\u0003\u0003\u0005\r!!\u0011\u0002'%\u001c8I]3bi&twMT3x)\u0006\u0014G.\u001a\u0011\u0002-\r|W.\\5u\u0003R$X-\u001c9u'R\f'\u000f\u001e+j[\u0016,\"!a'\u0011\u0007\u001d\fi*C\u0002\u0002 \"\u0014A\u0001T8oO\u0006Q2m\\7nSR\fE\u000f^3naR\u001cF/\u0019:u)&lWm\u0018\u0013fcR!\u00111JAS\u0011%\t\u0019FHA\u0001\u0002\u0004\tY*A\fd_6l\u0017\u000e^!ui\u0016l\u0007\u000f^*uCJ$H+[7fA\u0005A\u0001O]8u_\u000e|G.\u0006\u0002\u0002\u0000\u0005iQ.\u001a;bI\u0006$\u0018mU2bY\u0006,\"!a\u001b\u0002\u0017I,\u0017\r\u001a,feNLwN\\\u0001\t[\u0016$\u0018\rZ1uCR\u0011\u0011q\u0017\t\u0005\u0003s\u000bi,\u0004\u0002\u0002<*\u0019\u0011Q\u0007\u001f\n\t\u0005=\u00141X\u0001\u0007G>lW.\u001b;\u0016\t\u0005\r\u0017\u0011\u001c\u000b\t\u0003\u000b\fY-a;\u0002vB\u0019A*a2\n\u0007\u0005%GH\u0001\u0007D_6l\u0017\u000e\u001e*fgVdG\u000fC\u0004\u0002N\u0012\u0002\r!a4\u0002\u0011\u0005\u001cG/[8og*\u0003R\u0001RAi\u0003+L1!a5F\u0005!IE/\u001a:bE2,\u0007\u0003BAl\u00033d\u0001\u0001B\u0004\u0002\\\u0012\u0012\r!!8\u0003\u0003Q\u000bB!a8\u0002fB\u0019q-!9\n\u0007\u0005\r\bNA\u0004O_RD\u0017N\\4\u0011\t\u0005e\u0016q]\u0005\u0005\u0003S\fYL\u0001\u0004BGRLwN\u001c\u0005\b\u0003[$\u0003\u0019AAx\u0003\ty\u0007\u000fE\u0002M\u0003cL1!a==\u0005%y\u0005/\u001a:bi&|g\u000e\u0003\u0004\u0002x\u0012\u0002\r!`\u0001\u000bK:<\u0017N\\3J]\u001a|\u0017aD7be.4\u0015\u000e\\3t\u0003N\u0014V-\u00193\u0015\t\u0005u(1\u0001\t\u0004\u0019\u0006}\u0018b\u0001B\u0001y\tIA)\u001a7uCN\u001b\u0017M\u001c\u0005\b\u0005\u000b)\u0003\u0019AA\f\u00035\u0011X-\u00193Qe\u0016$\u0017nY1uK\u0006qQ\u000f\u001d3bi\u0016lU\r^1eCR\fG\u0003BA&\u0005\u0017AqA!\u0004'\u0001\u0004\t9,A\u0005nKR\fG-\u0019;b\u0015\u0006q!/Z1e/\"|G.\u001a+bE2,GCAA&\u0003)!\bP\u001c,feNLwN\u001c\u000b\u0005\u00037\u00139\u0002\u0003\u0004\u0003\u001a!\u0002\r!`\u0001\u0003S\u0012\fQ\u0002\u001d:fa\u0006\u0014XmQ8n[&$H\u0003\u0002B\u0010\u0005k\u0001bA!\t\u0003,\tEb\u0002\u0002B\u0012\u0005OqA!!\u0001\u0003&%\t\u0011.C\u0002\u0003*!\fq\u0001]1dW\u0006<W-\u0003\u0003\u0003.\t=\"aA*fc*\u0019!\u0011\u00065\u0011\t\u0005E\"1G\u0005\u0005\u0003S\f\u0019\u0004C\u0004\u00026%\u0002\rAa\b\u00021\u0011|7i\\7nSR\u0014V\r\u001e:z\u0013R,'/\u0019;jm\u0016d\u0017\u0010\u0006\u0005\u0002\u001c\nm\"q\bB!\u0011\u001d\u0011iD\u000ba\u0001\u00037\u000ba\"\u0019;uK6\u0004HOV3sg&|g\u000eC\u0004\u00026)\u0002\rAa\b\t\u000f\t\r#\u00061\u0001\u0003F\u0005q\u0011n]8mCRLwN\u001c'fm\u0016d\u0007c\u0001-\u0003H%\u0019!\u0011\n\u001e\u0003\u001d%\u001bx\u000e\\1uS>tG*\u001a<fY\u0006AAm\\\"p[6LG\u000f\u0006\u0005\u0002\u001c\n=#\u0011\u000bB*\u0011\u001d\u0011id\u000ba\u0001\u00037Cq!!\u000e,\u0001\u0004\u0011y\u0002C\u0004\u0003D-\u0002\rA!\u0012\u0002\u0015A|7\u000f^\"p[6LG\u000f\u0006\u0003\u0002L\te\u0003b\u0002B.Y\u0001\u0007\u00111T\u0001\u000eG>lW.\u001b;WKJ\u001c\u0018n\u001c8\u0002#\rDWmY6G_J\u001cuN\u001c4mS\u000e$8\u000f\u0006\u0006\u0002\u001c\n\u0005$Q\rB4\u0005WBqAa\u0019.\u0001\u0004\tY*\u0001\u0007dQ\u0016\u001c7NV3sg&|g\u000eC\u0004\u000265\u0002\rAa\b\t\r\t%T\u00061\u0001g\u00035\tG\u000f^3naRtU/\u001c2fe\"9!QN\u0017A\u0002\t\u0015\u0013\u0001F2p[6LG/S:pY\u0006$\u0018n\u001c8MKZ,G.A\twKJLg-\u001f(fo6+G/\u00193bi\u0006$B!a\u0013\u0003t!9\u00111\u0017\u0018A\u0002\u0005-\u0014!\u0007<fe&4\u0017pU2iK6\f7i\\7qCRL'-\u001b7jif$\u0002\"a\u0013\u0003z\t%%Q\u0012\u0005\b\u0005wz\u0003\u0019\u0001B?\u00039)\u00070[:uS:<7k\u00195f[\u0006\u0004BAa \u0003\u00066\u0011!\u0011\u0011\u0006\u0004\u0005\u0007c\u0014!\u0002;za\u0016\u001c\u0018\u0002\u0002BD\u0005\u0003\u0013!b\u0015;sk\u000e$H+\u001f9f\u0011\u001d\u0011Yi\fa\u0001\u0005{\n\u0011B\\3x'\u000eDW-\\1\t\u000f\u0005Ur\u00061\u0001\u0003 \u0005\u00012\u000f[8vY\u0012\u001c\u0005.Z2la>Lg\u000e\u001e\u000b\u0005\u0003\u0003\u0012\u0019\nC\u0004\u0003\u0016B\u0002\r!a'\u0002!\r|W.\\5ui\u0016$g+\u001a:tS>t\u0017!F4fi:+\u0007\u0010^!ui\u0016l\u0007\u000f\u001e,feNLwN\\\u0001\u0019o&$\bn\u00127pE\u0006d7i\u001c8gS\u001e$UMZ1vYR\u001cH\u0003BA6\u0005;Cq!a-3\u0001\u0004\tY'A\u0005m_\u001e\u0004&/\u001a4jqV\tQ0A\u0004m_\u001eLeNZ8\u0015\t\u0005-#q\u0015\u0005\t\u0005S#D\u00111\u0001\u0003,\u0006\u0019Qn]4\u0011\t\u001d\u0014i+`\u0005\u0004\u0005_C'\u0001\u0003\u001fcs:\fW.\u001a \u0002\u00151|wmV1s]&tw\r\u0006\u0003\u0002L\tU\u0006\u0002\u0003BUk\u0011\u0005\rAa+\u0015\r\u0005-#\u0011\u0018B^\u0011!\u0011IK\u000eCA\u0002\t-\u0006b\u0002B_m\u0001\u0007!qX\u0001\ni\"\u0014xn^1cY\u0016\u0004BA!\t\u0003B&!!1\u0019B\u0018\u0005%!\u0006N]8xC\ndW-\u0001\u0005m_\u001e,%O]8s)\u0011\tYE!3\t\u0011\t%v\u0007\"a\u0001\u0005W#b!a\u0013\u0003N\n=\u0007\u0002\u0003BUq\u0011\u0005\rAa+\t\u000f\tu\u0006\b1\u0001\u0003@\u0002")
public class OptimisticTransactionImpl
implements OptimisticTransaction,
Logging {
    private String logPrefix;
    private final DeltaLogImpl deltaLog;
    private final SnapshotImpl snapshot;
    private final int DELTA_MAX_RETRY_COMMIT_ATTEMPTS;
    private final String txnId;
    private final ArrayBuffer<String> readTxn;
    private final ArrayBuffer<Expression> readPredicates;
    private final HashSet<AddFile> readFiles;
    private boolean readTheWholeTable;
    private boolean committed;
    private Option<Metadata> newMetadata;
    private Option<Protocol> newProtocol;
    private boolean isCreatingNewTable;
    private long commitAttemptStartTime;
    private transient Logger io$delta$standalone$internal$logging$Logging$$log_;
    private volatile boolean bitmap$0;

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public Logger io$delta$standalone$internal$logging$Logging$$log_() {
        return this.io$delta$standalone$internal$logging$Logging$$log_;
    }

    @Override
    public void io$delta$standalone$internal$logging$Logging$$log__$eq(Logger x$1) {
        this.io$delta$standalone$internal$logging$Logging$$log_ = x$1;
    }

    public int DELTA_MAX_RETRY_COMMIT_ATTEMPTS() {
        return this.DELTA_MAX_RETRY_COMMIT_ATTEMPTS;
    }

    private String txnId() {
        return this.txnId;
    }

    private ArrayBuffer<String> readTxn() {
        return this.readTxn;
    }

    private ArrayBuffer<Expression> readPredicates() {
        return this.readPredicates;
    }

    private HashSet<AddFile> readFiles() {
        return this.readFiles;
    }

    private boolean readTheWholeTable() {
        return this.readTheWholeTable;
    }

    private void readTheWholeTable_$eq(boolean x$1) {
        this.readTheWholeTable = x$1;
    }

    private boolean committed() {
        return this.committed;
    }

    private void committed_$eq(boolean x$1) {
        this.committed = x$1;
    }

    private Option<Metadata> newMetadata() {
        return this.newMetadata;
    }

    private void newMetadata_$eq(Option<Metadata> x$1) {
        this.newMetadata = x$1;
    }

    private Option<Protocol> newProtocol() {
        return this.newProtocol;
    }

    private void newProtocol_$eq(Option<Protocol> x$1) {
        this.newProtocol = x$1;
    }

    private boolean isCreatingNewTable() {
        return this.isCreatingNewTable;
    }

    private void isCreatingNewTable_$eq(boolean x$1) {
        this.isCreatingNewTable = x$1;
    }

    private long commitAttemptStartTime() {
        return this.commitAttemptStartTime;
    }

    private void commitAttemptStartTime_$eq(long x$1) {
        this.commitAttemptStartTime = x$1;
    }

    public Protocol protocol() {
        return (Protocol)this.newProtocol().getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.snapshot.protocolScala());
    }

    public Metadata metadataScala() {
        return (Metadata)this.newMetadata().getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.snapshot.metadataScala());
    }

    private long readVersion() {
        return this.snapshot.version();
    }

    @Override
    public io.delta.standalone.actions.Metadata metadata() {
        return ConversionUtils$.MODULE$.convertMetadata(this.metadataScala());
    }

    @Override
    public <T extends io.delta.standalone.actions.Action> CommitResult commit(Iterable<T> actionsJ, Operation op, String engineInfo) {
        CommitInfo commitInfo;
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(actionsJ).asScala()).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends T, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof io.delta.standalone.actions.Metadata) {
                    io.delta.standalone.actions.Metadata metadata = (io.delta.standalone.actions.Metadata)A1;
                    object = metadata;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(T x1) {
                T t = x1;
                boolean bl = t instanceof io.delta.standalone.actions.Metadata;
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)m -> {
            this.updateMetadata(m);
            return BoxedUnit.UNIT;
        });
        Seq actions = ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(actionsJ).asScala()).map((Function1 & Serializable & scala.Serializable)external -> ConversionUtils$.MODULE$.convertActionJ((io.delta.standalone.actions.Action)external), Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)OptimisticTransactionImpl.$anonfun$commit$4(x$1)))).toSeq();
        Seq preparedActions = this.prepareCommit((Seq<Action>)actions);
        boolean noDataChanged = ((IterableLike)actions.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Action, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof FileAction) {
                    FileAction fileAction = (FileAction)A1;
                    object = BoxesRunTime.boxToBoolean((boolean)fileAction.dataChange());
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Action x2) {
                Action action = x2;
                boolean bl = action instanceof FileAction;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)OptimisticTransactionImpl.$anonfun$commit$5(BoxesRunTime.unboxToBoolean((Object)x$2))));
        IsolationLevel isolationLevelToUse = noDataChanged ? SnapshotIsolation$.MODULE$ : Serializable$.MODULE$;
        boolean dependsOnFiles = this.readPredicates().nonEmpty() || this.readFiles().nonEmpty();
        boolean onlyAddFiles = ((IterableLike)preparedActions.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Action, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof FileAction) {
                    FileAction fileAction = (FileAction)A1;
                    object = fileAction;
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Action x3) {
                Action action = x3;
                boolean bl = action instanceof FileAction;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)OptimisticTransactionImpl.$anonfun$commit$6(x$3)));
        boolean isBlindAppend = onlyAddFiles && !dependsOnFiles;
        CommitInfo commitInfo2 = commitInfo = CommitInfo$.MODULE$.apply(this.deltaLog.clock().getTimeMillis(), op.getName().toString(), (Map<String, String>)(op.getParameters() == null ? null : ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(op.getParameters()).asScala()).toMap(Predef$.MODULE$.$conforms())), (Map<String, String>)Predef$.MODULE$.Map().empty(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.readVersion())).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$4 -> x$4 >= 0L), (Option<String>)Option$.MODULE$.apply((Object)((IsolationLevel)isolationLevelToUse).toString()), (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)isBlindAppend)), (Option<Map<String, String>>)new Some((Object)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(op.getMetrics()).asScala()).toMap(Predef$.MODULE$.$conforms())), (Option<String>)(op.getUserMetadata().isPresent() ? new Some((Object)op.getUserMetadata().get()) : None$.MODULE$), (Option<String>)new Some((Object)new StringBuilder(2).append(engineInfo.replaceAll("\\s", "-")).append(" ").append(package$.MODULE$.NAME().replaceAll("\\s", "-")).append("/").append(package$.MODULE$.VERSION()).toString()));
        preparedActions = (Seq)preparedActions.$plus$colon((Object)commitInfo2, Seq$.MODULE$.canBuildFrom());
        this.commitAttemptStartTime_$eq(this.deltaLog.clock().getTimeMillis());
        long commitVersion = this.doCommitRetryIteratively(this.snapshot.version() + 1L, (Seq<Action>)preparedActions, isolationLevelToUse);
        this.postCommit(commitVersion);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Committed delta #").append(commitVersion).append(" to ").append($this.deltaLog.logPath()).toString());
        return new CommitResult(commitVersion);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DeltaScan markFilesAsRead(Expression readPredicate) {
        void var2_2;
        DeltaScanImpl scan = this.snapshot.scanScala(readPredicate);
        AddFile[] matchedFiles = scan.getFilesScala();
        Object object = scan.getPushedPredicate().isPresent() ? this.readPredicates().$plus$eq((Object)scan.getPushedPredicate().get()) : BoxedUnit.UNIT;
        this.readFiles().$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])matchedFiles)));
        return var2_2;
    }

    @Override
    public void updateMetadata(io.delta.standalone.actions.Metadata metadataJ) {
        ObjectRef latestMetadata = ObjectRef.create((Object)ConversionUtils$.MODULE$.convertMetadataJ(metadataJ));
        if (this.newMetadata().contains((Object)((Metadata)latestMetadata.elem))) {
            return;
        }
        Predef$.MODULE$.assert(this.newMetadata().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Cannot change the metadata more than once in a transaction.");
        if (this.readVersion() == -1L || this.isCreatingNewTable()) {
            latestMetadata.elem = this.withGlobalConfigDefaults((Metadata)latestMetadata.elem);
            this.isCreatingNewTable_$eq(true);
        }
        String string = this.snapshot.metadataScala().schemaString();
        String string2 = ((Metadata)latestMetadata.elem).schemaString();
        if (string == null ? string2 != null : !string.equals(string2)) {
            SchemaUtils$.MODULE$.checkUnenforceableNotNullConstraints(((Metadata)latestMetadata.elem).schema());
        }
        this.verifyNewMetadata((Metadata)latestMetadata.elem);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Updated metadata from ").append(this.newMetadata().getOrElse((Function0 & Serializable & scala.Serializable)() -> "-")).append(" to ").append((Metadata)latestMetadata$1.elem).toString());
        this.newMetadata_$eq((Option<Metadata>)new Some((Object)((Metadata)latestMetadata.elem)));
    }

    @Override
    public void readWholeTable() {
        this.readPredicates().$plus$eq((Object)Literal.True);
        this.readTheWholeTable_$eq(true);
    }

    @Override
    public long txnVersion(String id) {
        this.readTxn().$plus$eq((Object)id);
        return BoxesRunTime.unboxToLong((Object)this.snapshot.transactions().getOrElse((Object)id, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Action> prepareCommit(Seq<Action> actions) {
        void var3_3;
        block4: {
            Option protocolOpt;
            Predef$.MODULE$.assert(!this.committed(), (Function0 & Serializable & scala.Serializable)() -> "Transaction already committed.");
            boolean customCommitInfo = actions.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)OptimisticTransactionImpl.$anonfun$prepareCommit$2(x$6)));
            Predef$.MODULE$.assert(!customCommitInfo, (Function0 & Serializable & scala.Serializable)() -> "Cannot commit a custom CommitInfo in a transaction.");
            Seq finalActions = (Seq)actions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Action action;
                Action action2 = x0$1;
                if (action2 instanceof AddFile) {
                    AddFile addFile = (AddFile)action2;
                    action = addFile.copy(DeltaFileOperations$.MODULE$.tryRelativizePath($this.deltaLog.fs(), $this.deltaLog.getPath(), new Path(addFile.path()), DeltaFileOperations$.MODULE$.tryRelativizePath$default$4()).toString(), addFile.copy$default$2(), addFile.copy$default$3(), addFile.copy$default$4(), addFile.copy$default$5(), addFile.copy$default$6(), addFile.copy$default$7());
                } else if (action2 != null) {
                    Action action3;
                    action = action3 = action2;
                } else {
                    throw new MatchError((Object)action2);
                }
                return action;
            }, Seq$.MODULE$.canBuildFrom());
            this.newMetadata().foreach((Function1 & Serializable & scala.Serializable)m -> {
                this.verifySchemaCompatibility(this.snapshot.metadataScala().schema(), m.schema(), (Seq<Action>)actions);
                return BoxedUnit.UNIT;
            });
            finalActions = (Seq)Option$.MODULE$.option2Iterable(this.newMetadata()).toSeq().$plus$plus((GenTraversableOnce)finalActions, Seq$.MODULE$.canBuildFrom());
            if (this.snapshot.version() == -1L) {
                this.deltaLog.ensureLogDirectoryExist();
                if (!finalActions.exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)OptimisticTransactionImpl.$anonfun$prepareCommit$6(x$7)))) {
                    Protocol protocol = this.protocol();
                    finalActions = (Seq)finalActions.$plus$colon((Object)protocol, Seq$.MODULE$.canBuildFrom());
                }
                if (!finalActions.exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)OptimisticTransactionImpl.$anonfun$prepareCommit$7(x$9)))) {
                    throw DeltaErrors$.MODULE$.metadataAbsentException();
                }
            }
            if ((protocolOpt = finalActions.collectFirst((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof Protocol) {
                        Protocol protocol = (Protocol)A1;
                        object = protocol;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Action x1) {
                    Action action = x1;
                    boolean bl = action instanceof Protocol;
                    return bl;
                }
            })).isDefined()) {
                Object object = protocolOpt.get();
                Protocol protocol = new Protocol(Protocol$.MODULE$.apply$default$1(), Protocol$.MODULE$.apply$default$2());
                Predef$.MODULE$.assert(!(object != null ? !object.equals(protocol) : protocol != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Invalid Protocol ").append(((Protocol)protocolOpt.get()).simpleString()).append(". ").append("Currently only Protocol readerVersion 1 and writerVersion 2 is supported.").toString());
            }
            Set partitionColumns = this.metadataScala().partitionColumns().toSet();
            finalActions.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                OptimisticTransactionImpl.$anonfun$prepareCommit$9(partitionColumns, x0$2);
                return BoxedUnit.UNIT;
            });
            this.deltaLog.assertProtocolWrite(this.snapshot.protocolScala());
            Seq removes = (Seq)actions.collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Action, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof RemoveFile) {
                        RemoveFile removeFile = (RemoveFile)A1;
                        object = removeFile;
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Action x2) {
                    Action action = x2;
                    boolean bl = action instanceof RemoveFile;
                    return bl;
                }
            }, Seq$.MODULE$.canBuildFrom());
            if (!removes.exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.dataChange()))) break block4;
            this.deltaLog.assertRemovable();
        }
        return var3_3;
    }

    public long doCommitRetryIteratively(long attemptVersion, Seq<Action> actions, IsolationLevel isolationLevel) {
        return BoxesRunTime.unboxToLong(this.deltaLog.lockInterruptibly((JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
            boolean tryCommit = true;
            long commitVersion = attemptVersion;
            int attemptNumber = 0;
            while (tryCommit) {
                try {
                    long l;
                    if (attemptNumber == 0) {
                        l = this.doCommit(commitVersion, actions, isolationLevel);
                    } else {
                        if (attemptNumber > this.DELTA_MAX_RETRY_COMMIT_ATTEMPTS()) {
                            long totalCommitAttemptTime = $this.deltaLog.clock().getTimeMillis() - this.commitAttemptStartTime();
                            throw DeltaErrors$.MODULE$.maxCommitRetriesExceededException(attemptNumber, commitVersion, attemptVersion, actions.length(), totalCommitAttemptTime);
                        }
                        commitVersion = this.checkForConflicts(commitVersion, actions, attemptNumber, isolationLevel);
                        l = this.doCommit(commitVersion, actions, isolationLevel);
                    }
                    tryCommit = false;
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    ++attemptNumber;
                }
            }
            return commitVersion;
        }));
    }

    private long doCommit(long attemptVersion, Seq<Action> actions, IsolationLevel isolationLevel) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Attempting to commit version ").append(attemptVersion).append(" with ").append(actions.size()).append(" actions with ").append(new StringBuilder(16).append(isolationLevel).append(" isolation level").toString()).toString());
        if (this.readVersion() > -1L) {
            String string = this.metadata().getId();
            String string2 = this.snapshot.getMetadata().getId();
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Change in the table id detected in txn. Table id for txn on table at ").append(new StringBuilder(35).append($this.deltaLog.dataPath()).append(" was ").append($this.snapshot.getMetadata().getId()).append(" when the txn was created and ").toString()).append(new StringBuilder(19).append("is now changed to ").append(this.metadata().getId()).append(".").toString()).toString());
            }
        }
        this.deltaLog.store().write(FileNames$.MODULE$.deltaFile(this.deltaLog.logPath(), attemptVersion), (Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(((IterableLike)actions.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.json(), Seq$.MODULE$.canBuildFrom())).toIterator()).asJava(), Predef$.MODULE$.boolean2Boolean(false), this.deltaLog.hadoopConf());
        SnapshotImpl postCommitSnapshot = this.deltaLog.update();
        if (postCommitSnapshot.version() < attemptVersion) {
            throw new IllegalStateException(new StringBuilder(26).append("The committed version is ").append(attemptVersion).append(" ").append(new StringBuilder(28).append("but the current version is ").append(postCommitSnapshot.version()).append(".").toString()).toString());
        }
        return attemptVersion;
    }

    private void postCommit(long commitVersion) {
        block2: {
            this.committed_$eq(true);
            if (!this.shouldCheckpoint(commitVersion)) break block2;
            try {
                this.deltaLog.checkpoint(this.deltaLog.getSnapshotForVersionAsOf(commitVersion));
            }
            catch (IllegalStateException e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to checkpoint table state.", e);
            }
        }
    }

    private long checkForConflicts(long checkVersion, Seq<Action> actions, int attemptNumber, IsolationLevel commitIsolationLevel) {
        long nextAttemptVersion = this.getNextAttemptVersion();
        CurrentTransactionInfo currentTransactionInfo = new CurrentTransactionInfo((Seq<Expression>)this.readPredicates(), (Set<AddFile>)this.readFiles().toSet(), this.readTheWholeTable(), (Set<String>)this.readTxn().toSet(), this.metadataScala(), actions, this.deltaLog);
        String logPrefixStr = new StringBuilder(10).append("[attempt ").append(attemptNumber).append("]").toString();
        LongRef adds = LongRef.create((long)0L);
        LongRef removes = LongRef.create((long)0L);
        currentTransactionInfo.actions().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            OptimisticTransactionImpl.$anonfun$checkForConflicts$1(adds, removes, x0$1);
            return BoxedUnit.UNIT;
        });
        String txnDetailsLogStr = new StringBuilder(35).append(adds.elem).append(" adds, ").append(removes.elem).append(" removes, ").append(this.readPredicates().size()).append(" read predicates, ").append(new StringBuilder(11).append(this.readFiles().size()).append(" read files").toString()).toString();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append(logPrefixStr).append(" Checking for conflicts with versions ").append(new StringBuilder(29).append("[").append(checkVersion).append(", ").append(nextAttemptVersion).append(") with current txn having ").append(txnDetailsLogStr).toString()).toString());
        new RichLong(Predef$.MODULE$.longWrapper(checkVersion)).until((Object)BoxesRunTime.boxToLong((long)nextAttemptVersion)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)otherCommitVersion -> {
            ConflictChecker conflictChecker = new ConflictChecker(currentTransactionInfo, otherCommitVersion, commitIsolationLevel, logPrefixStr);
            conflictChecker.checkConflicts();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append(logPrefixStr).append(" No conflicts in version ").append(otherCommitVersion).append(", ").append(new StringBuilder(15).append($this.deltaLog.clock().getTimeMillis() - this.commitAttemptStartTime()).append(" ms since start").toString()).toString());
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append(logPrefixStr).append(" No conflicts with versions [").append(checkVersion).append(", ").append(nextAttemptVersion).append(") ").append(new StringBuilder(26).append("with current txn having ").append(txnDetailsLogStr).append(", ").toString()).append(new StringBuilder(15).append($this.deltaLog.clock().getTimeMillis() - this.commitAttemptStartTime()).append(" ms since start").toString()).toString());
        return nextAttemptVersion;
    }

    private void verifyNewMetadata(Metadata metadata) {
        SchemaMergingUtils$.MODULE$.checkColumnNameDuplication(metadata.schema(), "in the metadata update");
        SchemaUtils$.MODULE$.checkFieldNames(SchemaMergingUtils$.MODULE$.explodeNestedFieldNames(metadata.dataSchema()));
        try {
            SchemaUtils$.MODULE$.checkFieldNames(metadata.partitionColumns());
        }
        catch (DeltaStandaloneException e) {
            throw DeltaErrors$.MODULE$.invalidPartitionColumn(e);
        }
        Protocol$.MODULE$.checkMetadataProtocolProperties(metadata, this.protocol());
    }

    private void verifySchemaCompatibility(StructType existingSchema, StructType newSchema, Seq<Action> actions) {
        boolean tableEmpty;
        LazyBoolean allCurrentFilesRemoved$lzy = new LazyBoolean();
        boolean bl = tableEmpty = this.snapshot.numOfFiles() == 0L;
        if (tableEmpty || this.allCurrentFilesRemoved$1(allCurrentFilesRemoved$lzy, actions)) {
            return;
        }
        if (!existingSchema.isWriteCompatible(newSchema)) {
            throw DeltaErrors$.MODULE$.schemaChangedException(existingSchema, newSchema);
        }
    }

    private boolean shouldCheckpoint(long committedVersion) {
        return committedVersion != 0L && committedVersion % (long)this.deltaLog.checkpointInterval() == 0L;
    }

    private long getNextAttemptVersion() {
        this.deltaLog.update();
        return this.deltaLog.snapshot().version() + 1L;
    }

    private Metadata withGlobalConfigDefaults(Metadata metadata) {
        Map<String, String> x$1 = DeltaConfigs$.MODULE$.mergeGlobalConfigs(this.deltaLog.hadoopConf(), metadata.configuration());
        String x$2 = metadata.copy$default$1();
        String x$3 = metadata.copy$default$2();
        String x$4 = metadata.copy$default$3();
        Format x$5 = metadata.copy$default$4();
        String x$6 = metadata.copy$default$5();
        Seq<String> x$7 = metadata.copy$default$6();
        Option<Object> x$8 = metadata.copy$default$8();
        return metadata.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$1, x$8);
    }

    private String logPrefix$lzycompute() {
        OptimisticTransactionImpl optimisticTransactionImpl = this;
        synchronized (optimisticTransactionImpl) {
            if (!this.bitmap$0) {
                this.logPrefix = new StringBuilder(18).append("[tableId=").append(OptimisticTransactionImpl.truncate$1(this.snapshot.metadataScala().id())).append(",txnId=").append(OptimisticTransactionImpl.truncate$1(this.txnId())).append("] ").toString();
                this.bitmap$0 = true;
            }
        }
        this.txnId = null;
        return this.logPrefix;
    }

    public String logPrefix() {
        return !this.bitmap$0 ? this.logPrefix$lzycompute() : this.logPrefix;
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(0).append(this.logPrefix()).append(msg.apply()).toString());
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(0).append(this.logPrefix()).append(msg.apply()).toString());
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(0).append(this.logPrefix()).append(msg.apply()).toString(), throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(0).append(this.logPrefix()).append(msg.apply()).toString());
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(0).append(this.logPrefix()).append(msg.apply()).toString(), throwable);
    }

    public static final /* synthetic */ boolean $anonfun$commit$4(Action x$1) {
        return !(x$1 instanceof Metadata);
    }

    public static final /* synthetic */ boolean $anonfun$commit$5(boolean x$2) {
        return !x$2;
    }

    public static final /* synthetic */ boolean $anonfun$commit$6(FileAction x$3) {
        return x$3 instanceof AddFile;
    }

    public static final /* synthetic */ boolean $anonfun$prepareCommit$2(Action x$6) {
        return x$6 instanceof CommitInfo;
    }

    public static final /* synthetic */ boolean $anonfun$prepareCommit$6(Action x$7) {
        return x$7 instanceof Protocol;
    }

    public static final /* synthetic */ boolean $anonfun$prepareCommit$7(Action x$9) {
        return x$9 instanceof Metadata;
    }

    public static final /* synthetic */ void $anonfun$prepareCommit$9(Set partitionColumns$1, Action x0$2) {
        Action action = x0$2;
        if (action instanceof AddFile) {
            AddFile addFile = (AddFile)action;
            Set set = partitionColumns$1;
            Set set2 = addFile.partitionValues().keySet();
            if (set == null ? set2 != null : !set.equals(set2)) {
                throw DeltaErrors$.MODULE$.addFilePartitioningMismatchException((Seq<String>)addFile.partitionValues().keySet().toSeq(), (Seq<String>)partitionColumns$1.toSeq());
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$checkForConflicts$1(LongRef adds$1, LongRef removes$1, Action x0$1) {
        Action action = x0$1;
        if (action instanceof AddFile) {
            ++adds$1.elem;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (action instanceof RemoveFile) {
            ++removes$1.elem;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final /* synthetic */ boolean allCurrentFilesRemoved$lzycompute$1(LazyBoolean allCurrentFilesRemoved$lzy$1, Seq actions$4) {
        boolean bl;
        LazyBoolean lazyBoolean = allCurrentFilesRemoved$lzy$1;
        synchronized (lazyBoolean) {
            boolean bl2;
            if (allCurrentFilesRemoved$lzy$1.initialized()) {
                bl2 = allCurrentFilesRemoved$lzy$1.value();
            } else {
                Seq removeFiles = (Seq)actions$4.collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof RemoveFile) {
                            RemoveFile removeFile = (RemoveFile)A1;
                            object = removeFile;
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Action x1) {
                        Action action = x1;
                        boolean bl = action instanceof RemoveFile;
                        return bl;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Set set = ((TraversableOnce)removeFiles.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.path(), Seq$.MODULE$.canBuildFrom())).toSet();
                Set set2 = ((TraversableOnce)this.snapshot.allFilesScala().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.path(), Seq$.MODULE$.canBuildFrom())).toSet();
                bl2 = allCurrentFilesRemoved$lzy$1.initialize(!(set != null ? !set.equals(set2) : set2 != null));
            }
            bl = bl2;
        }
        return bl;
    }

    private final boolean allCurrentFilesRemoved$1(LazyBoolean allCurrentFilesRemoved$lzy$1, Seq actions$4) {
        return allCurrentFilesRemoved$lzy$1.initialized() ? allCurrentFilesRemoved$lzy$1.value() : this.allCurrentFilesRemoved$lzycompute$1(allCurrentFilesRemoved$lzy$1, actions$4);
    }

    private static final String truncate$1(String uuid) {
        return (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])uuid.split("-"))).head();
    }

    public OptimisticTransactionImpl(DeltaLogImpl deltaLog, SnapshotImpl snapshot) {
        this.deltaLog = deltaLog;
        this.snapshot = snapshot;
        Logging.$init$(this);
        this.DELTA_MAX_RETRY_COMMIT_ATTEMPTS = 10000000;
        this.txnId = UUID.randomUUID().toString();
        this.readTxn = new ArrayBuffer();
        this.readPredicates = new ArrayBuffer();
        this.readFiles = new HashSet();
        this.readTheWholeTable = false;
        this.committed = false;
        this.newMetadata = None$.MODULE$;
        this.newProtocol = None$.MODULE$;
        this.isCreatingNewTable = false;
    }
}

