/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.geospatial.aggregation;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.geospatial.serde.EsriGeometrySerde;
import com.facebook.presto.plugin.geospatial.GeometryType;
import com.facebook.presto.plugin.geospatial.aggregation.GeometryState;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.google.common.base.Joiner;
import io.airlift.slice.Slice;
import java.util.Set;

@Description(value="Returns a geometry that is the convex hull of all the geometries in the set.")
@AggregationFunction(value="convex_hull_agg")
public class ConvexHullAggregation {
    private static final Joiner OR_JOINER = Joiner.on((String)" or ");

    private ConvexHullAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState GeometryState state, @SqlType(value="Geometry") Slice input) {
        OGCGeometry geometry = EsriGeometrySerde.deserialize((Slice)input);
        if (state.getGeometry() == null) {
            state.setGeometry(geometry.convexHull(), 0L);
        } else if (!geometry.isEmpty()) {
            long previousMemorySize = state.getGeometry().estimateMemorySize();
            state.setGeometry(state.getGeometry().union(geometry).convexHull(), previousMemorySize);
        }
    }

    @CombineFunction
    public static void combine(@AggregationState GeometryState state, @AggregationState GeometryState otherState) {
        if (state.getGeometry() == null) {
            state.setGeometry(otherState.getGeometry(), 0L);
        } else if (otherState.getGeometry() != null && !otherState.getGeometry().isEmpty()) {
            long previousMemorySize = state.getGeometry().estimateMemorySize();
            state.setGeometry(state.getGeometry().union(otherState.getGeometry()).convexHull(), previousMemorySize);
        }
    }

    @OutputFunction(value="Geometry")
    public static void output(@AggregationState GeometryState state, BlockBuilder out) {
        if (state.getGeometry() == null) {
            out.appendNull();
        } else {
            GeometryType.GEOMETRY.writeSlice(out, EsriGeometrySerde.serialize((OGCGeometry)state.getGeometry()));
        }
    }

    private static void validateType(String function, OGCGeometry geometry, Set<com.facebook.presto.geospatial.GeometryType> validTypes) {
        com.facebook.presto.geospatial.GeometryType type = com.facebook.presto.geospatial.GeometryType.getForEsriGeometryType((String)geometry.geometryType());
        if (!validTypes.contains(type)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("%s only applies to %s. Input type is: %s", function, OR_JOINER.join(validTypes), type));
        }
    }
}

