/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.geospatial.aggregation;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.geospatial.serde.EsriGeometrySerde;
import com.facebook.presto.plugin.geospatial.GeometryType;
import com.facebook.presto.plugin.geospatial.aggregation.GeometryState;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import io.airlift.slice.Slice;

public class GeometryStateSerializer
implements AccumulatorStateSerializer<GeometryState> {
    public Type getSerializedType() {
        return GeometryType.GEOMETRY;
    }

    public void serialize(GeometryState state, BlockBuilder out) {
        if (state.getGeometry() == null) {
            out.appendNull();
        } else {
            GeometryType.GEOMETRY.writeSlice(out, EsriGeometrySerde.serialize((OGCGeometry)state.getGeometry()));
        }
    }

    public void deserialize(Block block, int index, GeometryState state) {
        long previousMemorySize = state.getGeometry() != null ? state.getGeometry().estimateMemorySize() : 0L;
        state.setGeometry(EsriGeometrySerde.deserialize((Slice)GeometryType.GEOMETRY.getSlice(block, index)), previousMemorySize);
    }
}

