/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.com.google.common.collect;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hudi.com.google.common.annotations.Beta;
import org.apache.hudi.com.google.common.annotations.GwtCompatible;
import org.apache.hudi.com.google.common.base.Preconditions;
import org.apache.hudi.com.google.common.collect.ForwardingCollection;
import org.apache.hudi.com.google.common.collect.Sets;

@GwtCompatible
public abstract class ForwardingSet<E>
extends ForwardingCollection<E>
implements Set<E> {
    protected ForwardingSet() {
    }

    @Override
    protected abstract Set<E> delegate();

    @Override
    public boolean equals(@Nullable Object object) {
        return object == this || ((Object)this.delegate()).equals(object);
    }

    @Override
    public int hashCode() {
        return ((Object)this.delegate()).hashCode();
    }

    @Override
    protected boolean standardRemoveAll(Collection<?> collection) {
        return Sets.removeAllImpl(this, Preconditions.checkNotNull(collection));
    }

    @Beta
    protected boolean standardEquals(@Nullable Object object) {
        return Sets.equalsImpl(this, object);
    }

    @Beta
    protected int standardHashCode() {
        return Sets.hashCodeImpl(this);
    }
}

