/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;

public class HoodieRollbackStat
implements Serializable {
    private final String partitionPath;
    private final List<String> successDeleteFiles;
    private final List<String> failedDeleteFiles;
    private final Map<FileStatus, Long> commandBlocksCount;
    private final Map<FileStatus, Long> writtenLogFileSizeMap;

    public HoodieRollbackStat(String partitionPath, List<String> successDeleteFiles, List<String> failedDeleteFiles, Map<FileStatus, Long> commandBlocksCount, Map<FileStatus, Long> writtenLogFileSizeMap) {
        this.partitionPath = partitionPath;
        this.successDeleteFiles = successDeleteFiles;
        this.failedDeleteFiles = failedDeleteFiles;
        this.commandBlocksCount = commandBlocksCount;
        this.writtenLogFileSizeMap = writtenLogFileSizeMap;
    }

    public Map<FileStatus, Long> getCommandBlocksCount() {
        return this.commandBlocksCount;
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public List<String> getSuccessDeleteFiles() {
        return this.successDeleteFiles;
    }

    public List<String> getFailedDeleteFiles() {
        return this.failedDeleteFiles;
    }

    public Map<FileStatus, Long> getWrittenLogFileSizeMap() {
        return this.writtenLogFileSizeMap;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private List<String> successDeleteFiles;
        private List<String> failedDeleteFiles;
        private Map<FileStatus, Long> commandBlocksCount;
        private Map<FileStatus, Long> writtenLogFileSizeMap;
        private String partitionPath;

        public Builder withDeletedFileResults(Map<FileStatus, Boolean> deletedFiles) {
            this.successDeleteFiles = deletedFiles.entrySet().stream().filter(s -> (Boolean)s.getValue()).map(s -> ((FileStatus)s.getKey()).getPath().toString()).collect(Collectors.toList());
            this.failedDeleteFiles = deletedFiles.entrySet().stream().filter(s -> (Boolean)s.getValue() == false).map(s -> ((FileStatus)s.getKey()).getPath().toString()).collect(Collectors.toList());
            return this;
        }

        public Builder withDeletedFileResult(String fileName, boolean isDeleted) {
            if (isDeleted) {
                this.successDeleteFiles = Collections.singletonList(fileName);
            } else {
                this.failedDeleteFiles = Collections.singletonList(fileName);
            }
            return this;
        }

        public Builder withRollbackBlockAppendResults(Map<FileStatus, Long> commandBlocksCount) {
            this.commandBlocksCount = commandBlocksCount;
            return this;
        }

        public Builder withWrittenLogFileSizeMap(Map<FileStatus, Long> writtenLogFileSizeMap) {
            this.writtenLogFileSizeMap = writtenLogFileSizeMap;
            return this;
        }

        public Builder withPartitionPath(String partitionPath) {
            this.partitionPath = partitionPath;
            return this;
        }

        public HoodieRollbackStat build() {
            if (this.successDeleteFiles == null) {
                this.successDeleteFiles = Collections.EMPTY_LIST;
            }
            if (this.failedDeleteFiles == null) {
                this.failedDeleteFiles = Collections.EMPTY_LIST;
            }
            if (this.commandBlocksCount == null) {
                this.commandBlocksCount = Collections.EMPTY_MAP;
            }
            if (this.writtenLogFileSizeMap == null) {
                this.writtenLogFileSizeMap = Collections.EMPTY_MAP;
            }
            return new HoodieRollbackStat(this.partitionPath, this.successDeleteFiles, this.failedDeleteFiles, this.commandBlocksCount, this.writtenLogFileSizeMap);
        }
    }
}

