/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.clean;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieCleanFileInfo;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.versioning.AbstractMigratorBase;
import org.apache.hudi.common.util.collection.Pair;

public class CleanPlanV1MigrationHandler
extends AbstractMigratorBase<HoodieCleanerPlan> {
    public static final Integer VERSION = 1;

    public CleanPlanV1MigrationHandler(HoodieTableMetaClient metaClient) {
        super(metaClient);
    }

    @Override
    public Integer getManagedVersion() {
        return VERSION;
    }

    @Override
    public HoodieCleanerPlan upgradeFrom(HoodieCleanerPlan plan) {
        throw new IllegalArgumentException("This is the lowest version. Plan cannot be any lower version");
    }

    @Override
    public HoodieCleanerPlan downgradeFrom(HoodieCleanerPlan plan) {
        if (this.metaClient.getTableConfig().getBootstrapBasePath().isPresent()) {
            throw new IllegalArgumentException("This version do not support METADATA_ONLY bootstrapped tables. Failed to downgrade.");
        }
        Map<String, List<String>> filesPerPartition = plan.getFilePathsToBeDeletedPerPartition().entrySet().stream().map(e -> Pair.of(e.getKey(), ((List)e.getValue()).stream().map(v -> new Path(v.getFilePath()).getName()).collect(Collectors.toList()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        return new HoodieCleanerPlan(plan.getEarliestInstantToRetain(), plan.getPolicy(), filesPerPartition, VERSION, new HashMap<String, List<HoodieCleanFileInfo>>());
    }
}

