/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hudi.com.esotericsoftware.kryo.Kryo;
import org.apache.hudi.com.esotericsoftware.kryo.io.Input;
import org.apache.hudi.com.esotericsoftware.kryo.io.Output;
import org.apache.hudi.org.objenesis.strategy.StdInstantiatorStrategy;

public class SerializationUtils {
    private static final ThreadLocal<KryoSerializerInstance> SERIALIZER_REF = ThreadLocal.withInitial(KryoSerializerInstance::new);

    public static byte[] serialize(Object obj) throws IOException {
        return SERIALIZER_REF.get().serialize(obj);
    }

    public static <T> T deserialize(byte[] objectData) {
        if (objectData == null) {
            throw new IllegalArgumentException("The byte[] must not be null");
        }
        return (T)SERIALIZER_REF.get().deserialize(objectData);
    }

    private static class KryoInstantiator
    implements Serializable {
        private KryoInstantiator() {
        }

        public Kryo newKryo() {
            Kryo kryo = new Kryo();
            kryo.setRegistrationRequired(false);
            kryo.setInstantiatorStrategy(new Kryo.DefaultInstantiatorStrategy(new StdInstantiatorStrategy()));
            kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
            return kryo;
        }
    }

    private static class KryoSerializerInstance
    implements Serializable {
        public static final int KRYO_SERIALIZER_INITIAL_BUFFER_SIZE = 0x100000;
        private final Kryo kryo;
        private final ByteArrayOutputStream baos;

        KryoSerializerInstance() {
            KryoInstantiator kryoInstantiator = new KryoInstantiator();
            this.kryo = kryoInstantiator.newKryo();
            this.baos = new ByteArrayOutputStream(0x100000);
            this.kryo.setRegistrationRequired(false);
        }

        byte[] serialize(Object obj) {
            this.kryo.reset();
            this.baos.reset();
            Output output = new Output(this.baos);
            this.kryo.writeClassAndObject(output, obj);
            output.close();
            return this.baos.toByteArray();
        }

        Object deserialize(byte[] objectData) {
            return this.kryo.readClassAndObject(new Input(objectData));
        }
    }
}

