/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.mapred.FileSplit;

public class BootstrapBaseFileSplit
extends FileSplit {
    private FileSplit bootstrapFileSplit;

    public BootstrapBaseFileSplit() {
    }

    public BootstrapBaseFileSplit(FileSplit baseSplit, FileSplit bootstrapFileSplit) throws IOException {
        super(baseSplit.getPath(), baseSplit.getStart(), baseSplit.getLength(), baseSplit.getLocations());
        this.bootstrapFileSplit = bootstrapFileSplit;
    }

    public FileSplit getBootstrapFileSplit() {
        return this.bootstrapFileSplit;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.bootstrapFileSplit.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.bootstrapFileSplit = new WrapperFileSplit();
        this.bootstrapFileSplit.readFields(in);
    }

    public static class WrapperFileSplit
    extends FileSplit {
    }
}

