/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hudi.com.google.common.annotations.VisibleForTesting;
import org.apache.hudi.com.google.protobuf.BlockingRpcChannel;
import org.apache.hudi.com.google.protobuf.RpcController;
import org.apache.hudi.com.google.protobuf.ServiceException;
import org.apache.hudi.org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hudi.org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hudi.org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hudi.org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hudi.org.apache.hadoop.hbase.RegionLocations;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hudi.org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hudi.org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.client.Admin;
import org.apache.hudi.org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hudi.org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hudi.org.apache.hadoop.hbase.client.BufferedMutatorImpl;
import org.apache.hudi.org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hudi.org.apache.hadoop.hbase.client.ClientScanner;
import org.apache.hudi.org.apache.hadoop.hbase.client.ClientSmallReversedScanner;
import org.apache.hudi.org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hudi.org.apache.hadoop.hbase.client.ClusterStatusListener;
import org.apache.hudi.org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hudi.org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hudi.org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hudi.org.apache.hadoop.hbase.client.Consistency;
import org.apache.hudi.org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hudi.org.apache.hadoop.hbase.client.HConnectable;
import org.apache.hudi.org.apache.hadoop.hbase.client.HConnection;
import org.apache.hudi.org.apache.hadoop.hbase.client.HConnectionKey;
import org.apache.hudi.org.apache.hadoop.hbase.client.HRegionLocator;
import org.apache.hudi.org.apache.hadoop.hbase.client.HTable;
import org.apache.hudi.org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hudi.org.apache.hadoop.hbase.client.MasterKeepAliveConnection;
import org.apache.hudi.org.apache.hadoop.hbase.client.MetaCache;
import org.apache.hudi.org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hudi.org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hudi.org.apache.hadoop.hbase.client.NeedUnmanagedConnectionException;
import org.apache.hudi.org.apache.hadoop.hbase.client.NoServerForRegionException;
import org.apache.hudi.org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hudi.org.apache.hadoop.hbase.client.PerClientRandomNonceGenerator;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionOfflineException;
import org.apache.hudi.org.apache.hadoop.hbase.client.Registry;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegistryFactory;
import org.apache.hudi.org.apache.hadoop.hbase.client.Result;
import org.apache.hudi.org.apache.hadoop.hbase.client.RetryingCallerInterceptor;
import org.apache.hudi.org.apache.hadoop.hbase.client.RetryingCallerInterceptorFactory;
import org.apache.hudi.org.apache.hadoop.hbase.client.Row;
import org.apache.hudi.org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hudi.org.apache.hadoop.hbase.client.Scan;
import org.apache.hudi.org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hudi.org.apache.hadoop.hbase.client.ZooKeeperKeepAliveConnection;
import org.apache.hudi.org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicy;
import org.apache.hudi.org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicyFactory;
import org.apache.hudi.org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.ClientExceptionsUtil;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hudi.org.apache.hadoop.hbase.security.User;
import org.apache.hudi.org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hudi.org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hudi.org.apache.hadoop.hbase.util.Threads;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
class ConnectionManager {
    static final Log LOG = LogFactory.getLog(ConnectionManager.class);
    public static final String RETRIES_BY_SERVER_KEY = "hbase.client.retries.by.server";
    private static final String CLIENT_NONCES_ENABLED_KEY = "hbase.client.nonces.enabled";
    private static final String RESOLVE_HOSTNAME_ON_FAIL_KEY = "hbase.resolve.hostnames.on.failure";
    static final Map<HConnectionKey, HConnectionImplementation> CONNECTION_INSTANCES;
    public static final int MAX_CACHED_CONNECTION_INSTANCES;
    private static volatile NonceGenerator nonceGenerator;
    private static Object nonceGeneratorCreateLock;

    private ConnectionManager() {
    }

    @VisibleForTesting
    static NonceGenerator injectNonceGeneratorForTesting(ClusterConnection conn, NonceGenerator cnm) {
        HConnectionImplementation connImpl = (HConnectionImplementation)conn;
        NonceGenerator ng = connImpl.getNonceGenerator();
        LOG.warn((Object)("Nonce generator is being replaced by test code for " + cnm.getClass().getName()));
        connImpl.nonceGenerator = cnm;
        return ng;
    }

    @Deprecated
    public static HConnection getConnection(Configuration conf) throws IOException {
        return ConnectionManager.getConnectionInternal(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ClusterConnection getConnectionInternal(Configuration conf) throws IOException {
        HConnectionKey connectionKey = new HConnectionKey(conf);
        Map<HConnectionKey, HConnectionImplementation> map = CONNECTION_INSTANCES;
        synchronized (map) {
            HConnectionImplementation connection = CONNECTION_INSTANCES.get(connectionKey);
            if (connection == null) {
                connection = (HConnectionImplementation)ConnectionManager.createConnection(conf, true);
                CONNECTION_INSTANCES.put(connectionKey, connection);
            } else if (connection.isClosed()) {
                ConnectionManager.deleteConnection(connectionKey, true);
                connection = (HConnectionImplementation)ConnectionManager.createConnection(conf, true);
                CONNECTION_INSTANCES.put(connectionKey, connection);
            }
            connection.incCount();
            return connection;
        }
    }

    public static HConnection createConnection(Configuration conf) throws IOException {
        return ConnectionManager.createConnectionInternal(conf);
    }

    static ClusterConnection createConnectionInternal(Configuration conf) throws IOException {
        UserProvider provider = UserProvider.instantiate(conf);
        return ConnectionManager.createConnection(conf, false, null, provider.getCurrent());
    }

    public static HConnection createConnection(Configuration conf, ExecutorService pool) throws IOException {
        UserProvider provider = UserProvider.instantiate(conf);
        return ConnectionManager.createConnection(conf, false, pool, provider.getCurrent());
    }

    public static HConnection createConnection(Configuration conf, User user) throws IOException {
        return ConnectionManager.createConnection(conf, false, null, user);
    }

    public static HConnection createConnection(Configuration conf, ExecutorService pool, User user) throws IOException {
        return ConnectionManager.createConnection(conf, false, pool, user);
    }

    @Deprecated
    static HConnection createConnection(Configuration conf, boolean managed) throws IOException {
        UserProvider provider = UserProvider.instantiate(conf);
        return ConnectionManager.createConnection(conf, managed, null, provider.getCurrent());
    }

    @Deprecated
    static ClusterConnection createConnection(Configuration conf, boolean managed, ExecutorService pool, User user) throws IOException {
        return (ClusterConnection)ConnectionFactory.createConnection(conf, managed, pool, user);
    }

    @Deprecated
    public static void deleteConnection(Configuration conf) {
        ConnectionManager.deleteConnection(new HConnectionKey(conf), false);
    }

    @Deprecated
    public static void deleteStaleConnection(HConnection connection) {
        ConnectionManager.deleteConnection(connection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void deleteAllConnections(boolean staleConnection) {
        Map<HConnectionKey, HConnectionImplementation> map = CONNECTION_INSTANCES;
        synchronized (map) {
            HashSet<HConnectionKey> connectionKeys = new HashSet<HConnectionKey>();
            connectionKeys.addAll(CONNECTION_INSTANCES.keySet());
            for (HConnectionKey connectionKey : connectionKeys) {
                ConnectionManager.deleteConnection(connectionKey, staleConnection);
            }
            CONNECTION_INSTANCES.clear();
        }
    }

    @Deprecated
    public static void deleteAllConnections() {
        ConnectionManager.deleteAllConnections(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static void deleteConnection(HConnection connection, boolean staleConnection) {
        Map<HConnectionKey, HConnectionImplementation> map = CONNECTION_INSTANCES;
        synchronized (map) {
            for (Map.Entry<HConnectionKey, HConnectionImplementation> e : CONNECTION_INSTANCES.entrySet()) {
                if (e.getValue() != connection) continue;
                ConnectionManager.deleteConnection(e.getKey(), staleConnection);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static void deleteConnection(HConnectionKey connectionKey, boolean staleConnection) {
        Map<HConnectionKey, HConnectionImplementation> map = CONNECTION_INSTANCES;
        synchronized (map) {
            HConnectionImplementation connection = CONNECTION_INSTANCES.get(connectionKey);
            if (connection != null) {
                connection.decCount();
                if (connection.isZeroReference() || staleConnection) {
                    CONNECTION_INSTANCES.remove(connectionKey);
                    connection.internalClose();
                }
            } else {
                LOG.error((Object)("Connection not found in the list, can't delete it (connection key=" + connectionKey + "). May be the key was modified?"), (Throwable)new Exception());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public static <T> T execute(HConnectable<T> connectable) throws IOException {
        if (connectable == null || connectable.conf == null) {
            return null;
        }
        Configuration conf = connectable.conf;
        HConnection connection = ConnectionManager.getConnection(conf);
        boolean connectSucceeded = false;
        try {
            T returnValue = connectable.connect(connection);
            connectSucceeded = true;
            T t = returnValue;
            return t;
        }
        finally {
            block8: {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    ExceptionUtil.rethrowIfInterrupt(e);
                    if (!connectSucceeded) break block8;
                    throw new IOException("The connection to " + connection + " could not be deleted.", e);
                }
            }
        }
    }

    static {
        nonceGenerator = null;
        nonceGeneratorCreateLock = new Object();
        MAX_CACHED_CONNECTION_INSTANCES = HBaseConfiguration.create().getInt("hbase.zookeeper.property.maxClientCnxns", 300) + 1;
        CONNECTION_INSTANCES = new LinkedHashMap<HConnectionKey, HConnectionImplementation>((int)((float)MAX_CACHED_CONNECTION_INSTANCES / 0.75f) + 1, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<HConnectionKey, HConnectionImplementation> eldest) {
                return this.size() > MAX_CACHED_CONNECTION_INSTANCES;
            }
        };
    }

    static class ServerErrorTracker {
        private final ConcurrentMap<ServerName, ServerErrors> errorsByServer = new ConcurrentHashMap<ServerName, ServerErrors>();
        private final long canRetryUntil;
        private final int maxRetries;
        private final long startTrackingTime;

        public ServerErrorTracker(long timeout, int maxRetries) {
            this.maxRetries = maxRetries;
            this.canRetryUntil = EnvironmentEdgeManager.currentTime() + timeout;
            this.startTrackingTime = new Date().getTime();
        }

        boolean canRetryMore(int numRetry) {
            return numRetry < this.maxRetries || this.maxRetries > 1 && EnvironmentEdgeManager.currentTime() < this.canRetryUntil;
        }

        long calculateBackoffTime(ServerName server, long basePause) {
            ServerErrors errorStats = (ServerErrors)this.errorsByServer.get(server);
            long result = errorStats != null ? ConnectionUtils.getPauseTime(basePause, errorStats.retries.get()) : 0L;
            return result;
        }

        void reportServerError(ServerName server) {
            ServerErrors errors = (ServerErrors)this.errorsByServer.get(server);
            if (errors != null) {
                errors.addError();
            } else {
                errors = this.errorsByServer.putIfAbsent(server, new ServerErrors());
                if (errors != null) {
                    errors.addError();
                }
            }
        }

        long getStartTrackingTime() {
            return this.startTrackingTime;
        }

        private static class ServerErrors {
            public final AtomicInteger retries = new AtomicInteger(0);

            private ServerErrors() {
            }

            public void addError() {
                this.retries.incrementAndGet();
            }
        }
    }

    @SuppressWarnings(value={"AT_OPERATION_SEQUENCE_ON_CONCURRENT_ABSTRACTION"}, justification="Access to the conncurrent hash map is under a lock so should be fine.")
    static class HConnectionImplementation
    implements ClusterConnection,
    Closeable {
        static final Log LOG = LogFactory.getLog(HConnectionImplementation.class);
        private final boolean hostnamesCanChange;
        private final long pause;
        private final boolean useMetaReplicas;
        private final int numTries;
        final int rpcTimeout;
        private NonceGenerator nonceGenerator = null;
        private final AsyncProcess asyncProcess;
        private final ServerStatisticTracker stats;
        private volatile boolean closed;
        private volatile boolean aborted;
        ClusterStatusListener clusterStatusListener;
        private final Object metaRegionLock = new Object();
        private final Object masterAndZKLock = new Object();
        private long keepZooKeeperWatcherAliveUntil = Long.MAX_VALUE;
        private volatile ExecutorService batchPool = null;
        private volatile ExecutorService metaLookupPool = null;
        private volatile boolean cleanupPool = false;
        private final Configuration conf;
        private final ConnectionConfiguration connectionConfig;
        private RpcClient rpcClient;
        private final MetaCache metaCache;
        private final MetricsConnection metrics;
        private int refCount;
        private boolean managed;
        protected User user;
        private RpcRetryingCallerFactory rpcCallerFactory;
        private RpcControllerFactory rpcControllerFactory;
        private final RetryingCallerInterceptor interceptor;
        Registry registry;
        private final ClientBackoffPolicy backoffPolicy;
        protected String clusterId = null;
        private final ConcurrentHashMap<String, Object> stubs = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, String> connectionLock = new ConcurrentHashMap();
        private ZooKeeperKeepAliveConnection keepAliveZookeeper;
        private AtomicInteger keepAliveZookeeperUserCount = new AtomicInteger(0);
        private boolean canCloseZKW = true;
        private static final long keepAlive = 300000L;
        final MasterServiceState masterServiceState = new MasterServiceState(this);

        HConnectionImplementation(Configuration conf, boolean managed) throws IOException {
            this(conf, managed, null, null);
        }

        HConnectionImplementation(Configuration conf, boolean managed, ExecutorService pool, User user) throws IOException {
            this(conf);
            this.user = user;
            this.batchPool = pool;
            this.managed = managed;
            this.registry = this.setupRegistry();
            this.retrieveClusterId();
            this.rpcClient = RpcClientFactory.createClient(this.conf, this.clusterId, this.metrics);
            this.rpcControllerFactory = RpcControllerFactory.instantiate(conf);
            boolean shouldListen = conf.getBoolean("hbase.status.published", false);
            Class listenerClass = conf.getClass("hbase.status.listener.class", ClusterStatusListener.DEFAULT_STATUS_LISTENER_CLASS, ClusterStatusListener.Listener.class);
            if (shouldListen) {
                if (listenerClass == null) {
                    LOG.warn((Object)"hbase.status.published is true, but hbase.status.listener.class is not set - not listening status");
                } else {
                    this.clusterStatusListener = new ClusterStatusListener(new ClusterStatusListener.DeadServerHandler(){

                        @Override
                        public void newDead(ServerName sn) {
                            HConnectionImplementation.this.clearCaches(sn);
                            HConnectionImplementation.this.rpcClient.cancelConnections(sn);
                        }
                    }, conf, listenerClass);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected HConnectionImplementation(Configuration conf) {
            this.conf = conf;
            this.connectionConfig = new ConnectionConfiguration(conf);
            this.closed = false;
            this.pause = conf.getLong("hbase.client.pause", 100L);
            this.useMetaReplicas = conf.getBoolean("hbase.meta.replicas.use", false);
            this.numTries = this.connectionConfig.getRetriesNumber();
            this.rpcTimeout = conf.getInt("hbase.rpc.timeout", 60000);
            if (conf.getBoolean(ConnectionManager.CLIENT_NONCES_ENABLED_KEY, true)) {
                Object object = nonceGeneratorCreateLock;
                synchronized (object) {
                    if (nonceGenerator == null) {
                        nonceGenerator = new PerClientRandomNonceGenerator();
                    }
                    this.nonceGenerator = nonceGenerator;
                }
            } else {
                this.nonceGenerator = new NoNonceGenerator();
            }
            this.stats = ServerStatisticTracker.create(conf);
            this.asyncProcess = this.createAsyncProcess(this.conf);
            this.interceptor = new RetryingCallerInterceptorFactory(conf).build();
            this.rpcCallerFactory = RpcRetryingCallerFactory.instantiate(conf, this.interceptor, this.stats);
            this.backoffPolicy = ClientBackoffPolicyFactory.create(conf);
            this.metrics = conf.getBoolean("hbase.client.metrics.enable", false) ? new MetricsConnection(this) : null;
            this.hostnamesCanChange = conf.getBoolean(ConnectionManager.RESOLVE_HOSTNAME_ON_FAIL_KEY, true);
            this.metaCache = new MetaCache(this.metrics);
        }

        @Override
        public HTableInterface getTable(String tableName) throws IOException {
            return this.getTable(TableName.valueOf(tableName));
        }

        @Override
        public HTableInterface getTable(byte[] tableName) throws IOException {
            return this.getTable(TableName.valueOf(tableName));
        }

        @Override
        public HTableInterface getTable(TableName tableName) throws IOException {
            return this.getTable(tableName, this.getBatchPool());
        }

        @Override
        public HTableInterface getTable(String tableName, ExecutorService pool) throws IOException {
            return this.getTable(TableName.valueOf(tableName), pool);
        }

        @Override
        public HTableInterface getTable(byte[] tableName, ExecutorService pool) throws IOException {
            return this.getTable(TableName.valueOf(tableName), pool);
        }

        @Override
        public HTableInterface getTable(TableName tableName, ExecutorService pool) throws IOException {
            if (this.managed) {
                throw new NeedUnmanagedConnectionException();
            }
            return new HTable(tableName, this, this.connectionConfig, this.rpcCallerFactory, this.rpcControllerFactory, pool);
        }

        @Override
        public BufferedMutator getBufferedMutator(BufferedMutatorParams params) {
            if (params.getTableName() == null) {
                throw new IllegalArgumentException("TableName cannot be null.");
            }
            if (params.getPool() == null) {
                params.pool(HTable.getDefaultExecutor(this.getConfiguration()));
            }
            if (params.getWriteBufferSize() == -1L) {
                params.writeBufferSize(this.connectionConfig.getWriteBufferSize());
            }
            if (params.getMaxKeyValueSize() == -1) {
                params.maxKeyValueSize(this.connectionConfig.getMaxKeyValueSize());
            }
            return new BufferedMutatorImpl(this, this.rpcCallerFactory, this.rpcControllerFactory, params);
        }

        @Override
        public BufferedMutator getBufferedMutator(TableName tableName) {
            return this.getBufferedMutator(new BufferedMutatorParams(tableName));
        }

        @Override
        public RegionLocator getRegionLocator(TableName tableName) throws IOException {
            return new HRegionLocator(tableName, this);
        }

        @Override
        public Admin getAdmin() throws IOException {
            if (this.managed) {
                throw new NeedUnmanagedConnectionException();
            }
            return new HBaseAdmin(this);
        }

        @Override
        public MetricsConnection getConnectionMetrics() {
            return this.metrics;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ExecutorService getBatchPool() {
            if (this.batchPool == null) {
                HConnectionImplementation hConnectionImplementation = this;
                synchronized (hConnectionImplementation) {
                    if (this.batchPool == null) {
                        this.batchPool = this.getThreadPool(this.conf.getInt("hbase.hconnection.threads.max", 256), this.conf.getInt("hbase.hconnection.threads.core", 256), "-shared-", null);
                        this.cleanupPool = true;
                    }
                }
            }
            return this.batchPool;
        }

        private ExecutorService getThreadPool(int maxThreads, int coreThreads, String nameHint, BlockingQueue<Runnable> passedWorkQueue) {
            if (maxThreads == 0) {
                maxThreads = Runtime.getRuntime().availableProcessors() * 8;
            }
            if (coreThreads == 0) {
                coreThreads = Runtime.getRuntime().availableProcessors() * 8;
            }
            long keepAliveTime = this.conf.getLong("hbase.hconnection.threads.keepalivetime", 60L);
            BlockingQueue<Runnable> workQueue = passedWorkQueue;
            if (workQueue == null) {
                workQueue = new LinkedBlockingQueue<Runnable>(maxThreads * this.conf.getInt("hbase.client.max.total.tasks", 100));
            }
            ThreadPoolExecutor tpe = new ThreadPoolExecutor(coreThreads, maxThreads, keepAliveTime, TimeUnit.SECONDS, workQueue, Threads.newDaemonThreadFactory(this.toString() + nameHint));
            tpe.allowCoreThreadTimeOut(true);
            return tpe;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ExecutorService getMetaLookupPool() {
            if (this.metaLookupPool == null) {
                HConnectionImplementation hConnectionImplementation = this;
                synchronized (hConnectionImplementation) {
                    if (this.metaLookupPool == null) {
                        this.metaLookupPool = this.getThreadPool(this.conf.getInt("hbase.hconnection.meta.lookup.threads.max", 128), this.conf.getInt("hbase.hconnection.meta.lookup.threads.core", 10), "-metaLookup-shared-", new LinkedBlockingQueue<Runnable>());
                    }
                }
            }
            return this.metaLookupPool;
        }

        protected ExecutorService getCurrentMetaLookupPool() {
            return this.metaLookupPool;
        }

        protected ExecutorService getCurrentBatchPool() {
            return this.batchPool;
        }

        private void shutdownPools() {
            if (this.cleanupPool && this.batchPool != null && !this.batchPool.isShutdown()) {
                this.shutdownBatchPool(this.batchPool);
            }
            if (this.metaLookupPool != null && !this.metaLookupPool.isShutdown()) {
                this.shutdownBatchPool(this.metaLookupPool);
            }
        }

        private void shutdownBatchPool(ExecutorService pool) {
            pool.shutdown();
            try {
                if (!pool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    pool.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                pool.shutdownNow();
            }
        }

        private Registry setupRegistry() throws IOException {
            return RegistryFactory.getRegistry(this);
        }

        @VisibleForTesting
        RpcClient getRpcClient() {
            return this.rpcClient;
        }

        public String toString() {
            return "hconnection-0x" + Integer.toHexString(this.hashCode());
        }

        void retrieveClusterId() {
            if (this.clusterId != null) {
                return;
            }
            this.clusterId = this.registry.getClusterId();
            if (this.clusterId == null) {
                this.clusterId = "default-cluster";
                LOG.debug((Object)("clusterid came back null, using default " + this.clusterId));
            }
        }

        @Override
        public Configuration getConfiguration() {
            return this.conf;
        }

        private void checkIfBaseNodeAvailable(ZooKeeperWatcher zkw) throws MasterNotRunningException {
            try {
                if (ZKUtil.checkExists(zkw, zkw.baseZNode) == -1) {
                    String errorMsg = "The node " + zkw.baseZNode + " is not in ZooKeeper. " + "It should have been written by the master. " + "Check the value configured in 'zookeeper.znode.parent'. " + "There could be a mismatch with the one configured in the master.";
                    LOG.error((Object)errorMsg);
                    throw new MasterNotRunningException(errorMsg);
                }
            }
            catch (KeeperException e) {
                String errorMsg = "Can't get connection to ZooKeeper: " + e.getMessage();
                LOG.error((Object)errorMsg);
                throw new MasterNotRunningException(errorMsg, (Exception)((Object)e));
            }
        }

        @Override
        @Deprecated
        public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
            MasterKeepAliveConnection m = this.getKeepAliveMasterService();
            m.close();
            return true;
        }

        @Override
        public HRegionLocation getRegionLocation(TableName tableName, byte[] row, boolean reload) throws IOException {
            return reload ? this.relocateRegion(tableName, row) : this.locateRegion(tableName, row);
        }

        @Override
        public HRegionLocation getRegionLocation(byte[] tableName, byte[] row, boolean reload) throws IOException {
            return this.getRegionLocation(TableName.valueOf(tableName), row, reload);
        }

        @Override
        public boolean isTableEnabled(TableName tableName) throws IOException {
            return this.registry.isTableOnlineState(tableName, true);
        }

        @Override
        public boolean isTableEnabled(byte[] tableName) throws IOException {
            return this.isTableEnabled(TableName.valueOf(tableName));
        }

        @Override
        public boolean isTableDisabled(TableName tableName) throws IOException {
            return this.registry.isTableOnlineState(tableName, false);
        }

        @Override
        public boolean isTableDisabled(byte[] tableName) throws IOException {
            return this.isTableDisabled(TableName.valueOf(tableName));
        }

        @Override
        public boolean isTableAvailable(final TableName tableName) throws IOException {
            final AtomicBoolean available = new AtomicBoolean(true);
            final AtomicInteger regionCount = new AtomicInteger(0);
            MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                @Override
                public boolean processRow(Result row) throws IOException {
                    HRegionInfo info = MetaScanner.getHRegionInfo(row);
                    if (info != null && !info.isSplitParent()) {
                        if (tableName.equals(info.getTable())) {
                            ServerName server = HRegionInfo.getServerName(row);
                            if (server == null) {
                                available.set(false);
                                return false;
                            }
                            regionCount.incrementAndGet();
                        } else if (tableName.compareTo(info.getTable()) < 0) {
                            return false;
                        }
                    }
                    return true;
                }
            };
            MetaScanner.metaScan(this, visitor, tableName);
            return available.get() && regionCount.get() > 0;
        }

        @Override
        public boolean isTableAvailable(byte[] tableName) throws IOException {
            return this.isTableAvailable(TableName.valueOf(tableName));
        }

        @Override
        public boolean isTableAvailable(final TableName tableName, final byte[][] splitKeys) throws IOException {
            final AtomicBoolean available = new AtomicBoolean(true);
            final AtomicInteger regionCount = new AtomicInteger(0);
            MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                @Override
                public boolean processRow(Result row) throws IOException {
                    HRegionInfo info = MetaScanner.getHRegionInfo(row);
                    if (info != null && !info.isSplitParent()) {
                        if (tableName.equals(info.getTable())) {
                            ServerName server = HRegionInfo.getServerName(row);
                            if (server == null) {
                                available.set(false);
                                return false;
                            }
                            if (!Bytes.equals(info.getStartKey(), HConstants.EMPTY_BYTE_ARRAY)) {
                                for (byte[] splitKey : splitKeys) {
                                    if (!Bytes.equals(info.getStartKey(), splitKey)) continue;
                                    regionCount.incrementAndGet();
                                    break;
                                }
                            } else {
                                regionCount.incrementAndGet();
                            }
                        } else if (tableName.compareTo(info.getTable()) < 0) {
                            return false;
                        }
                    }
                    return true;
                }
            };
            MetaScanner.metaScan(this, visitor, tableName);
            return available.get() && regionCount.get() == splitKeys.length + 1;
        }

        @Override
        public boolean isTableAvailable(byte[] tableName, byte[][] splitKeys) throws IOException {
            return this.isTableAvailable(TableName.valueOf(tableName), splitKeys);
        }

        @Override
        public HRegionLocation locateRegion(byte[] regionName) throws IOException {
            RegionLocations locations = this.locateRegion(HRegionInfo.getTable(regionName), HRegionInfo.getStartKey(regionName), false, true);
            return locations == null ? null : locations.getRegionLocation();
        }

        @Override
        public boolean isDeadServer(ServerName sn) {
            if (this.clusterStatusListener == null) {
                return false;
            }
            return this.clusterStatusListener.isDeadServer(sn);
        }

        @Override
        public List<HRegionLocation> locateRegions(TableName tableName) throws IOException {
            return this.locateRegions(tableName, false, true);
        }

        @Override
        public List<HRegionLocation> locateRegions(byte[] tableName) throws IOException {
            return this.locateRegions(TableName.valueOf(tableName));
        }

        @Override
        public List<HRegionLocation> locateRegions(TableName tableName, boolean useCache, boolean offlined) throws IOException {
            NavigableMap<HRegionInfo, ServerName> regions = MetaScanner.allTableRegions(this, tableName);
            ArrayList<HRegionLocation> locations = new ArrayList<HRegionLocation>();
            for (HRegionInfo regionInfo : regions.keySet()) {
                RegionLocations list = this.locateRegion(tableName, regionInfo.getStartKey(), useCache, true);
                if (list == null) continue;
                for (HRegionLocation loc : list.getRegionLocations()) {
                    if (loc == null) continue;
                    locations.add(loc);
                }
            }
            return locations;
        }

        @Override
        public List<HRegionLocation> locateRegions(byte[] tableName, boolean useCache, boolean offlined) throws IOException {
            return this.locateRegions(TableName.valueOf(tableName), useCache, offlined);
        }

        @Override
        public HRegionLocation locateRegion(TableName tableName, byte[] row) throws IOException {
            RegionLocations locations = this.locateRegion(tableName, row, true, true);
            return locations == null ? null : locations.getRegionLocation();
        }

        @Override
        public HRegionLocation locateRegion(byte[] tableName, byte[] row) throws IOException {
            return this.locateRegion(TableName.valueOf(tableName), row);
        }

        @Override
        public HRegionLocation relocateRegion(TableName tableName, byte[] row) throws IOException {
            RegionLocations locations = this.relocateRegion(tableName, row, 0);
            return locations == null ? null : locations.getRegionLocation(0);
        }

        @Override
        public RegionLocations relocateRegion(TableName tableName, byte[] row, int replicaId) throws IOException {
            if (!tableName.equals(TableName.META_TABLE_NAME) && this.isTableDisabled(tableName)) {
                throw new TableNotEnabledException(tableName.getNameAsString() + " is disabled.");
            }
            return this.locateRegion(tableName, row, false, true, replicaId);
        }

        @Override
        public HRegionLocation relocateRegion(byte[] tableName, byte[] row) throws IOException {
            return this.relocateRegion(TableName.valueOf(tableName), row);
        }

        @Override
        public RegionLocations locateRegion(TableName tableName, byte[] row, boolean useCache, boolean retry) throws IOException {
            return this.locateRegion(tableName, row, useCache, retry, 0);
        }

        @Override
        public RegionLocations locateRegion(TableName tableName, byte[] row, boolean useCache, boolean retry, int replicaId) throws IOException {
            if (this.closed) {
                throw new IOException(this.toString() + " closed");
            }
            if (tableName == null || tableName.getName().length == 0) {
                throw new IllegalArgumentException("table name cannot be null or zero length");
            }
            if (tableName.equals(TableName.META_TABLE_NAME)) {
                return this.locateMeta(tableName, useCache, replicaId);
            }
            return this.locateRegionInMeta(tableName, row, useCache, retry, replicaId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RegionLocations locateMeta(TableName tableName, boolean useCache, int replicaId) throws IOException {
            byte[] metaCacheKey = HConstants.EMPTY_START_ROW;
            RegionLocations locations = null;
            if (useCache && (locations = this.getCachedLocation(tableName, metaCacheKey)) != null && locations.getRegionLocation(replicaId) != null) {
                return locations;
            }
            Object object = this.metaRegionLock;
            synchronized (object) {
                if (useCache && (locations = this.getCachedLocation(tableName, metaCacheKey)) != null && locations.getRegionLocation(replicaId) != null) {
                    return locations;
                }
                locations = this.registry.getMetaRegionLocation();
                if (locations != null) {
                    this.cacheLocation(tableName, locations);
                }
            }
            return locations;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RegionLocations locateRegionInMeta(TableName tableName, byte[] row, boolean useCache, boolean retry, int replicaId) throws IOException {
            RegionLocations locations;
            if (useCache && (locations = this.getCachedLocation(tableName, row)) != null && locations.getRegionLocation(replicaId) != null) {
                return locations;
            }
            byte[] metaKey = HRegionInfo.createRegionName(tableName, row, "99999999999999", false);
            Scan s = new Scan();
            s.setReversed(true);
            s.setStartRow(metaKey);
            s.setSmall(true);
            s.setCaching(1);
            if (this.useMetaReplicas) {
                s.setConsistency(Consistency.TIMELINE);
            }
            int localNumRetries = retry ? this.numTries : 1;
            int tries = 0;
            while (true) {
                if (tries >= localNumRetries) {
                    throw new NoServerForRegionException("Unable to find region for " + Bytes.toStringBinary(row) + " in " + tableName + " after " + localNumRetries + " tries.");
                }
                if (useCache) {
                    RegionLocations locations2 = this.getCachedLocation(tableName, row);
                    if (locations2 != null && locations2.getRegionLocation(replicaId) != null) {
                        return locations2;
                    }
                } else {
                    this.metaCache.clearCache(tableName, row);
                }
                try {
                    Result regionInfoRow = null;
                    try (ClientScanner rcs = null;){
                        rcs = new ClientSmallReversedScanner(this.conf, s, TableName.META_TABLE_NAME, this, this.rpcCallerFactory, this.rpcControllerFactory, this.getMetaLookupPool(), 0);
                        regionInfoRow = rcs.next();
                    }
                    if (regionInfoRow == null) {
                        throw new TableNotFoundException(tableName);
                    }
                    RegionLocations locations3 = MetaTableAccessor.getRegionLocations(regionInfoRow);
                    if (locations3 == null || locations3.getRegionLocation(replicaId) == null) {
                        throw new IOException("HRegionInfo was null in " + tableName + ", row=" + regionInfoRow);
                    }
                    HRegionInfo regionInfo = locations3.getRegionLocation(replicaId).getRegionInfo();
                    if (regionInfo == null) {
                        throw new IOException("HRegionInfo was null or empty in " + TableName.META_TABLE_NAME + ", row=" + regionInfoRow);
                    }
                    if (!regionInfo.getTable().equals(tableName)) {
                        throw new TableNotFoundException("Table '" + tableName + "' was not found, got: " + regionInfo.getTable() + ".");
                    }
                    if (regionInfo.isSplit()) {
                        throw new RegionOfflineException("the only available region for the required row is a split parent, the daughters should be online soon: " + regionInfo.getRegionNameAsString());
                    }
                    if (regionInfo.isOffline()) {
                        throw new RegionOfflineException("the region is offline, could be caused by a disable table call: " + regionInfo.getRegionNameAsString());
                    }
                    ServerName serverName = locations3.getRegionLocation(replicaId).getServerName();
                    if (serverName == null) {
                        throw new NoServerForRegionException("No server address listed in " + TableName.META_TABLE_NAME + " for region " + regionInfo.getRegionNameAsString() + " containing row " + Bytes.toStringBinary(row));
                    }
                    if (this.isDeadServer(serverName)) {
                        throw new RegionServerStoppedException("hbase:meta says the region " + regionInfo.getRegionNameAsString() + " is managed by the server " + serverName + ", but it is dead.");
                    }
                    this.cacheLocation(tableName, locations3);
                    return locations3;
                }
                catch (TableNotFoundException e) {
                    throw e;
                }
                catch (IOException e) {
                    ExceptionUtil.rethrowIfInterrupt(e);
                    if (e instanceof RemoteException) {
                        e = ((RemoteException)((Object)e)).unwrapRemoteException();
                    }
                    if (tries < localNumRetries - 1) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("locateRegionInMeta parentTable=" + TableName.META_TABLE_NAME + ", metaLocation=" + ", attempt=" + tries + " of " + localNumRetries + " failed; retrying after sleep of " + ConnectionUtils.getPauseTime(this.pause, tries) + " because: " + e.getMessage()));
                        }
                    } else {
                        throw e;
                    }
                    if (!(e instanceof RegionOfflineException) && !(e instanceof NoServerForRegionException)) {
                        this.relocateRegion(TableName.META_TABLE_NAME, metaKey, replicaId);
                    }
                    try {
                        Thread.sleep(ConnectionUtils.getPauseTime(this.pause, tries));
                    }
                    catch (InterruptedException e2) {
                        throw new InterruptedIOException("Giving up trying to location region in meta: thread is interrupted.");
                    }
                    ++tries;
                    continue;
                }
                break;
            }
        }

        @Override
        public void cacheLocation(TableName tableName, RegionLocations location) {
            this.metaCache.cacheLocation(tableName, location);
        }

        RegionLocations getCachedLocation(TableName tableName, byte[] row) {
            return this.metaCache.getCachedLocation(tableName, row);
        }

        public void clearRegionCache(TableName tableName, byte[] row) {
            this.metaCache.clearCache(tableName, row);
        }

        @Override
        public void clearCaches(ServerName serverName) {
            this.metaCache.clearCache(serverName);
        }

        @Override
        public void clearRegionCache() {
            this.metaCache.clearCache();
        }

        @Override
        public void clearRegionCache(TableName tableName) {
            this.metaCache.clearCache(tableName);
        }

        @Override
        public void clearRegionCache(byte[] tableName) {
            this.clearRegionCache(TableName.valueOf(tableName));
        }

        private void cacheLocation(TableName tableName, ServerName source, HRegionLocation location) {
            this.metaCache.cacheLocation(tableName, source, location);
        }

        @Override
        public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName serverName) throws IOException {
            return this.getAdmin(serverName, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName serverName, boolean master) throws IOException {
            if (this.isDeadServer(serverName)) {
                throw new RegionServerStoppedException(serverName + " is dead.");
            }
            String key = HConnectionImplementation.getStubKey(AdminProtos.AdminService.BlockingInterface.class.getName(), serverName.getHostname(), serverName.getPort(), this.hostnamesCanChange);
            this.connectionLock.putIfAbsent(key, key);
            AdminProtos.AdminService.BlockingInterface stub = null;
            String string = this.connectionLock.get(key);
            synchronized (string) {
                stub = (AdminProtos.AdminService.BlockingInterface)this.stubs.get(key);
                if (stub == null) {
                    BlockingRpcChannel channel = this.rpcClient.createBlockingRpcChannel(serverName, this.user, this.rpcTimeout);
                    stub = AdminProtos.AdminService.newBlockingStub(channel);
                    this.stubs.put(key, stub);
                }
            }
            return stub;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClientProtos.ClientService.BlockingInterface getClient(ServerName sn) throws IOException {
            if (this.isDeadServer(sn)) {
                throw new RegionServerStoppedException(sn + " is dead.");
            }
            String key = HConnectionImplementation.getStubKey(ClientProtos.ClientService.BlockingInterface.class.getName(), sn.getHostname(), sn.getPort(), this.hostnamesCanChange);
            this.connectionLock.putIfAbsent(key, key);
            ClientProtos.ClientService.BlockingInterface stub = null;
            String string = this.connectionLock.get(key);
            synchronized (string) {
                stub = (ClientProtos.ClientService.BlockingInterface)this.stubs.get(key);
                if (stub == null) {
                    BlockingRpcChannel channel = this.rpcClient.createBlockingRpcChannel(sn, this.user, this.rpcTimeout);
                    stub = ClientProtos.ClientService.newBlockingStub(channel);
                    this.stubs.put(key, stub);
                }
            }
            return stub;
        }

        static String getStubKey(String serviceName, String rsHostname, int port, boolean resolveHostnames) {
            InetAddress i;
            String address = rsHostname;
            if (resolveHostnames && (i = new InetSocketAddress(rsHostname, port).getAddress()) != null) {
                address = i.getHostAddress() + "-" + rsHostname;
            }
            return serviceName + "@" + address + ":" + port;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ZooKeeperKeepAliveConnection getKeepAliveZooKeeperWatcher() throws IOException {
            Object object = this.masterAndZKLock;
            synchronized (object) {
                if (this.keepAliveZookeeper == null) {
                    if (this.closed) {
                        throw new IOException(this.toString() + " closed");
                    }
                    this.keepAliveZookeeper = new ZooKeeperKeepAliveConnection(this.conf, this.toString(), this);
                }
                this.keepAliveZookeeperUserCount.addAndGet(1);
                this.keepZooKeeperWatcherAliveUntil = Long.MAX_VALUE;
                return this.keepAliveZookeeper;
            }
        }

        void releaseZooKeeperWatcher(ZooKeeperWatcher zkw) {
            if (zkw == null) {
                return;
            }
            if (this.keepAliveZookeeperUserCount.addAndGet(-1) <= 0) {
                this.keepZooKeeperWatcherAliveUntil = System.currentTimeMillis() + 300000L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeZooKeeperWatcher() {
            Object object = this.masterAndZKLock;
            synchronized (object) {
                if (this.keepAliveZookeeper != null) {
                    LOG.info((Object)("Closing zookeeper sessionid=0x" + Long.toHexString(this.keepAliveZookeeper.getRecoverableZooKeeper().getSessionId())));
                    this.keepAliveZookeeper.internalClose();
                    this.keepAliveZookeeper = null;
                }
                this.keepAliveZookeeperUserCount.set(0);
            }
        }

        @Override
        public MasterProtos.MasterService.BlockingInterface getMaster() throws MasterNotRunningException {
            return this.getKeepAliveMasterService();
        }

        private void resetMasterServiceState(MasterServiceState mss) {
            ++mss.userCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MasterKeepAliveConnection getKeepAliveMasterService() throws MasterNotRunningException {
            Object object = this.masterAndZKLock;
            synchronized (object) {
                if (!this.isKeepAliveMasterConnectedAndRunning(this.masterServiceState)) {
                    MasterServiceStubMaker stubMaker = new MasterServiceStubMaker();
                    try {
                        this.masterServiceState.stub = stubMaker.makeStub();
                    }
                    catch (MasterNotRunningException ex) {
                        throw ex;
                    }
                    catch (IOException e) {
                        throw new MasterNotRunningException(e);
                    }
                }
                this.resetMasterServiceState(this.masterServiceState);
            }
            final MasterProtos.MasterService.BlockingInterface stub = this.masterServiceState.stub;
            return new MasterKeepAliveConnection(){
                MasterServiceState mss;
                {
                    this.mss = HConnectionImplementation.this.masterServiceState;
                }

                @Override
                public MasterProtos.AbortProcedureResponse abortProcedure(RpcController controller, MasterProtos.AbortProcedureRequest request) throws ServiceException {
                    return stub.abortProcedure(controller, request);
                }

                @Override
                public MasterProtos.ListProceduresResponse listProcedures(RpcController controller, MasterProtos.ListProceduresRequest request) throws ServiceException {
                    return stub.listProcedures(controller, request);
                }

                @Override
                public MasterProtos.AddColumnResponse addColumn(RpcController controller, MasterProtos.AddColumnRequest request) throws ServiceException {
                    return stub.addColumn(controller, request);
                }

                @Override
                public MasterProtos.DeleteColumnResponse deleteColumn(RpcController controller, MasterProtos.DeleteColumnRequest request) throws ServiceException {
                    return stub.deleteColumn(controller, request);
                }

                @Override
                public MasterProtos.ModifyColumnResponse modifyColumn(RpcController controller, MasterProtos.ModifyColumnRequest request) throws ServiceException {
                    return stub.modifyColumn(controller, request);
                }

                @Override
                public MasterProtos.MoveRegionResponse moveRegion(RpcController controller, MasterProtos.MoveRegionRequest request) throws ServiceException {
                    return stub.moveRegion(controller, request);
                }

                @Override
                public MasterProtos.DispatchMergingRegionsResponse dispatchMergingRegions(RpcController controller, MasterProtos.DispatchMergingRegionsRequest request) throws ServiceException {
                    return stub.dispatchMergingRegions(controller, request);
                }

                @Override
                public MasterProtos.AssignRegionResponse assignRegion(RpcController controller, MasterProtos.AssignRegionRequest request) throws ServiceException {
                    return stub.assignRegion(controller, request);
                }

                @Override
                public MasterProtos.UnassignRegionResponse unassignRegion(RpcController controller, MasterProtos.UnassignRegionRequest request) throws ServiceException {
                    return stub.unassignRegion(controller, request);
                }

                @Override
                public MasterProtos.OfflineRegionResponse offlineRegion(RpcController controller, MasterProtos.OfflineRegionRequest request) throws ServiceException {
                    return stub.offlineRegion(controller, request);
                }

                @Override
                public MasterProtos.DeleteTableResponse deleteTable(RpcController controller, MasterProtos.DeleteTableRequest request) throws ServiceException {
                    return stub.deleteTable(controller, request);
                }

                @Override
                public MasterProtos.TruncateTableResponse truncateTable(RpcController controller, MasterProtos.TruncateTableRequest request) throws ServiceException {
                    return stub.truncateTable(controller, request);
                }

                @Override
                public MasterProtos.EnableTableResponse enableTable(RpcController controller, MasterProtos.EnableTableRequest request) throws ServiceException {
                    return stub.enableTable(controller, request);
                }

                @Override
                public MasterProtos.DisableTableResponse disableTable(RpcController controller, MasterProtos.DisableTableRequest request) throws ServiceException {
                    return stub.disableTable(controller, request);
                }

                @Override
                public MasterProtos.ModifyTableResponse modifyTable(RpcController controller, MasterProtos.ModifyTableRequest request) throws ServiceException {
                    return stub.modifyTable(controller, request);
                }

                @Override
                public MasterProtos.CreateTableResponse createTable(RpcController controller, MasterProtos.CreateTableRequest request) throws ServiceException {
                    return stub.createTable(controller, request);
                }

                @Override
                public MasterProtos.ShutdownResponse shutdown(RpcController controller, MasterProtos.ShutdownRequest request) throws ServiceException {
                    return stub.shutdown(controller, request);
                }

                @Override
                public MasterProtos.StopMasterResponse stopMaster(RpcController controller, MasterProtos.StopMasterRequest request) throws ServiceException {
                    return stub.stopMaster(controller, request);
                }

                @Override
                public MasterProtos.BalanceResponse balance(RpcController controller, MasterProtos.BalanceRequest request) throws ServiceException {
                    return stub.balance(controller, request);
                }

                @Override
                public MasterProtos.SetBalancerRunningResponse setBalancerRunning(RpcController controller, MasterProtos.SetBalancerRunningRequest request) throws ServiceException {
                    return stub.setBalancerRunning(controller, request);
                }

                @Override
                public MasterProtos.NormalizeResponse normalize(RpcController controller, MasterProtos.NormalizeRequest request) throws ServiceException {
                    return stub.normalize(controller, request);
                }

                @Override
                public MasterProtos.SetNormalizerRunningResponse setNormalizerRunning(RpcController controller, MasterProtos.SetNormalizerRunningRequest request) throws ServiceException {
                    return stub.setNormalizerRunning(controller, request);
                }

                @Override
                public MasterProtos.RunCatalogScanResponse runCatalogScan(RpcController controller, MasterProtos.RunCatalogScanRequest request) throws ServiceException {
                    return stub.runCatalogScan(controller, request);
                }

                @Override
                public MasterProtos.EnableCatalogJanitorResponse enableCatalogJanitor(RpcController controller, MasterProtos.EnableCatalogJanitorRequest request) throws ServiceException {
                    return stub.enableCatalogJanitor(controller, request);
                }

                @Override
                public MasterProtos.IsCatalogJanitorEnabledResponse isCatalogJanitorEnabled(RpcController controller, MasterProtos.IsCatalogJanitorEnabledRequest request) throws ServiceException {
                    return stub.isCatalogJanitorEnabled(controller, request);
                }

                @Override
                public ClientProtos.CoprocessorServiceResponse execMasterService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
                    return stub.execMasterService(controller, request);
                }

                @Override
                public MasterProtos.SnapshotResponse snapshot(RpcController controller, MasterProtos.SnapshotRequest request) throws ServiceException {
                    return stub.snapshot(controller, request);
                }

                @Override
                public MasterProtos.GetCompletedSnapshotsResponse getCompletedSnapshots(RpcController controller, MasterProtos.GetCompletedSnapshotsRequest request) throws ServiceException {
                    return stub.getCompletedSnapshots(controller, request);
                }

                @Override
                public MasterProtos.DeleteSnapshotResponse deleteSnapshot(RpcController controller, MasterProtos.DeleteSnapshotRequest request) throws ServiceException {
                    return stub.deleteSnapshot(controller, request);
                }

                @Override
                public MasterProtos.IsSnapshotDoneResponse isSnapshotDone(RpcController controller, MasterProtos.IsSnapshotDoneRequest request) throws ServiceException {
                    return stub.isSnapshotDone(controller, request);
                }

                @Override
                public MasterProtos.RestoreSnapshotResponse restoreSnapshot(RpcController controller, MasterProtos.RestoreSnapshotRequest request) throws ServiceException {
                    return stub.restoreSnapshot(controller, request);
                }

                @Override
                public MasterProtos.IsRestoreSnapshotDoneResponse isRestoreSnapshotDone(RpcController controller, MasterProtos.IsRestoreSnapshotDoneRequest request) throws ServiceException {
                    return stub.isRestoreSnapshotDone(controller, request);
                }

                @Override
                public MasterProtos.ExecProcedureResponse execProcedure(RpcController controller, MasterProtos.ExecProcedureRequest request) throws ServiceException {
                    return stub.execProcedure(controller, request);
                }

                @Override
                public MasterProtos.ExecProcedureResponse execProcedureWithRet(RpcController controller, MasterProtos.ExecProcedureRequest request) throws ServiceException {
                    return stub.execProcedureWithRet(controller, request);
                }

                @Override
                public MasterProtos.IsProcedureDoneResponse isProcedureDone(RpcController controller, MasterProtos.IsProcedureDoneRequest request) throws ServiceException {
                    return stub.isProcedureDone(controller, request);
                }

                @Override
                public MasterProtos.GetProcedureResultResponse getProcedureResult(RpcController controller, MasterProtos.GetProcedureResultRequest request) throws ServiceException {
                    return stub.getProcedureResult(controller, request);
                }

                @Override
                public MasterProtos.IsMasterRunningResponse isMasterRunning(RpcController controller, MasterProtos.IsMasterRunningRequest request) throws ServiceException {
                    return stub.isMasterRunning(controller, request);
                }

                @Override
                public MasterProtos.ModifyNamespaceResponse modifyNamespace(RpcController controller, MasterProtos.ModifyNamespaceRequest request) throws ServiceException {
                    return stub.modifyNamespace(controller, request);
                }

                @Override
                public MasterProtos.CreateNamespaceResponse createNamespace(RpcController controller, MasterProtos.CreateNamespaceRequest request) throws ServiceException {
                    return stub.createNamespace(controller, request);
                }

                @Override
                public MasterProtos.DeleteNamespaceResponse deleteNamespace(RpcController controller, MasterProtos.DeleteNamespaceRequest request) throws ServiceException {
                    return stub.deleteNamespace(controller, request);
                }

                @Override
                public MasterProtos.GetNamespaceDescriptorResponse getNamespaceDescriptor(RpcController controller, MasterProtos.GetNamespaceDescriptorRequest request) throws ServiceException {
                    return stub.getNamespaceDescriptor(controller, request);
                }

                @Override
                public MasterProtos.ListNamespaceDescriptorsResponse listNamespaceDescriptors(RpcController controller, MasterProtos.ListNamespaceDescriptorsRequest request) throws ServiceException {
                    return stub.listNamespaceDescriptors(controller, request);
                }

                @Override
                public MasterProtos.ListTableDescriptorsByNamespaceResponse listTableDescriptorsByNamespace(RpcController controller, MasterProtos.ListTableDescriptorsByNamespaceRequest request) throws ServiceException {
                    return stub.listTableDescriptorsByNamespace(controller, request);
                }

                @Override
                public MasterProtos.ListTableNamesByNamespaceResponse listTableNamesByNamespace(RpcController controller, MasterProtos.ListTableNamesByNamespaceRequest request) throws ServiceException {
                    return stub.listTableNamesByNamespace(controller, request);
                }

                @Override
                public void close() {
                    HConnectionImplementation.release(this.mss);
                }

                @Override
                public MasterProtos.GetSchemaAlterStatusResponse getSchemaAlterStatus(RpcController controller, MasterProtos.GetSchemaAlterStatusRequest request) throws ServiceException {
                    return stub.getSchemaAlterStatus(controller, request);
                }

                @Override
                public MasterProtos.GetTableDescriptorsResponse getTableDescriptors(RpcController controller, MasterProtos.GetTableDescriptorsRequest request) throws ServiceException {
                    return stub.getTableDescriptors(controller, request);
                }

                @Override
                public MasterProtos.GetTableNamesResponse getTableNames(RpcController controller, MasterProtos.GetTableNamesRequest request) throws ServiceException {
                    return stub.getTableNames(controller, request);
                }

                @Override
                public MasterProtos.GetClusterStatusResponse getClusterStatus(RpcController controller, MasterProtos.GetClusterStatusRequest request) throws ServiceException {
                    return stub.getClusterStatus(controller, request);
                }

                @Override
                public MasterProtos.SetQuotaResponse setQuota(RpcController controller, MasterProtos.SetQuotaRequest request) throws ServiceException {
                    return stub.setQuota(controller, request);
                }

                @Override
                public MasterProtos.MajorCompactionTimestampResponse getLastMajorCompactionTimestamp(RpcController controller, MasterProtos.MajorCompactionTimestampRequest request) throws ServiceException {
                    return stub.getLastMajorCompactionTimestamp(controller, request);
                }

                @Override
                public MasterProtos.MajorCompactionTimestampResponse getLastMajorCompactionTimestampForRegion(RpcController controller, MasterProtos.MajorCompactionTimestampForRegionRequest request) throws ServiceException {
                    return stub.getLastMajorCompactionTimestampForRegion(controller, request);
                }

                @Override
                public MasterProtos.IsBalancerEnabledResponse isBalancerEnabled(RpcController controller, MasterProtos.IsBalancerEnabledRequest request) throws ServiceException {
                    return stub.isBalancerEnabled(controller, request);
                }

                @Override
                public MasterProtos.IsNormalizerEnabledResponse isNormalizerEnabled(RpcController controller, MasterProtos.IsNormalizerEnabledRequest request) throws ServiceException {
                    return stub.isNormalizerEnabled(controller, request);
                }

                @Override
                public MasterProtos.SecurityCapabilitiesResponse getSecurityCapabilities(RpcController controller, MasterProtos.SecurityCapabilitiesRequest request) throws ServiceException {
                    return stub.getSecurityCapabilities(controller, request);
                }
            };
        }

        private static void release(MasterServiceState mss) {
            if (mss != null && mss.connection != null) {
                ((HConnectionImplementation)mss.connection).releaseMaster(mss);
            }
        }

        private boolean isKeepAliveMasterConnectedAndRunning(MasterServiceState mss) {
            if (mss.getStub() == null) {
                return false;
            }
            try {
                return mss.isMasterRunning();
            }
            catch (UndeclaredThrowableException e) {
                LOG.info((Object)"Master connection is not running anymore", e.getUndeclaredThrowable());
                return false;
            }
            catch (ServiceException se) {
                LOG.warn((Object)"Checking master connection", (Throwable)se);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseMaster(MasterServiceState mss) {
            if (mss.getStub() == null) {
                return;
            }
            Object object = this.masterAndZKLock;
            synchronized (object) {
                --mss.userCount;
            }
        }

        private void closeMasterService(MasterServiceState mss) {
            if (mss.getStub() != null) {
                LOG.info((Object)("Closing master protocol: " + mss));
                mss.clearStub();
            }
            mss.userCount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeMaster() {
            Object object = this.masterAndZKLock;
            synchronized (object) {
                this.closeMasterService(this.masterServiceState);
            }
        }

        void updateCachedLocation(HRegionInfo hri, ServerName source, ServerName serverName, long seqNum) {
            HRegionLocation newHrl = new HRegionLocation(hri, serverName, seqNum);
            this.cacheLocation(hri.getTable(), source, newHrl);
        }

        @Override
        public void deleteCachedRegionLocation(HRegionLocation location) {
            this.metaCache.clearCache(location);
        }

        @Override
        public void updateCachedLocations(TableName tableName, byte[] rowkey, Object exception, HRegionLocation source) {
            assert (source != null);
            this.updateCachedLocations(tableName, source.getRegionInfo().getRegionName(), rowkey, exception, source.getServerName());
        }

        @Override
        public void updateCachedLocations(TableName tableName, byte[] regionName, byte[] rowkey, Object exception, ServerName source) {
            if (rowkey == null || tableName == null) {
                LOG.warn((Object)("Coding error, see method javadoc. row=" + (rowkey == null ? "null" : (Object)rowkey) + ", tableName=" + (tableName == null ? "null" : tableName)));
                return;
            }
            if (source == null) {
                return;
            }
            if (regionName == null) {
                this.metaCache.clearCache(tableName, rowkey, source);
                return;
            }
            RegionLocations oldLocations = this.getCachedLocation(tableName, rowkey);
            HRegionLocation oldLocation = null;
            if (oldLocations != null) {
                oldLocation = oldLocations.getRegionLocationByRegionName(regionName);
            }
            if (oldLocation == null || !source.equals(oldLocation.getServerName())) {
                return;
            }
            HRegionInfo regionInfo = oldLocation.getRegionInfo();
            Throwable cause = ClientExceptionsUtil.findException(exception);
            if (cause != null) {
                if (!ClientExceptionsUtil.isMetaClearingException(cause)) {
                    return;
                }
                if (cause instanceof RegionMovedException) {
                    RegionMovedException rme = (RegionMovedException)cause;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Region " + regionInfo.getRegionNameAsString() + " moved to " + rme.getHostname() + ":" + rme.getPort() + " according to " + source.getHostAndPort()));
                    }
                    this.updateCachedLocation(regionInfo, source, rme.getServerName(), rme.getLocationSeqNum());
                    return;
                }
            }
            this.metaCache.clearCache(regionInfo);
        }

        @Override
        public void updateCachedLocations(byte[] tableName, byte[] rowkey, Object exception, HRegionLocation source) {
            this.updateCachedLocations(TableName.valueOf(tableName), rowkey, exception, source);
        }

        @Override
        @Deprecated
        public void processBatch(List<? extends Row> list, TableName tableName, ExecutorService pool, Object[] results) throws IOException, InterruptedException {
            if (results.length != list.size()) {
                throw new IllegalArgumentException("argument results must be the same size as argument list");
            }
            this.processBatchCallback(list, tableName, pool, results, null);
        }

        @Override
        @Deprecated
        public void processBatch(List<? extends Row> list, byte[] tableName, ExecutorService pool, Object[] results) throws IOException, InterruptedException {
            this.processBatch(list, TableName.valueOf(tableName), pool, results);
        }

        @Override
        @Deprecated
        public <R> void processBatchCallback(List<? extends Row> list, TableName tableName, ExecutorService pool, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
            AsyncProcess.AsyncRequestFuture ars = this.asyncProcess.submitAll(pool, tableName, list, callback, results);
            ars.waitUntilDone();
            if (ars.hasError()) {
                throw ars.getErrors();
            }
        }

        @Override
        @Deprecated
        public <R> void processBatchCallback(List<? extends Row> list, byte[] tableName, ExecutorService pool, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
            this.processBatchCallback(list, TableName.valueOf(tableName), pool, results, callback);
        }

        protected AsyncProcess createAsyncProcess(Configuration conf) {
            return new AsyncProcess(this, conf, this.batchPool, RpcRetryingCallerFactory.instantiate(conf, this.getStatisticsTracker()), false, RpcControllerFactory.instantiate(conf));
        }

        @Override
        public AsyncProcess getAsyncProcess() {
            return this.asyncProcess;
        }

        @Override
        public ServerStatisticTracker getStatisticsTracker() {
            return this.stats;
        }

        @Override
        public ClientBackoffPolicy getBackoffPolicy() {
            return this.backoffPolicy;
        }

        @VisibleForTesting
        int getNumberOfCachedRegionLocations(TableName tableName) {
            return this.metaCache.getNumberOfCachedRegionLocations(tableName);
        }

        @Override
        @Deprecated
        public void setRegionCachePrefetch(TableName tableName, boolean enable) {
        }

        @Override
        @Deprecated
        public void setRegionCachePrefetch(byte[] tableName, boolean enable) {
        }

        @Override
        @Deprecated
        public boolean getRegionCachePrefetch(TableName tableName) {
            return false;
        }

        @Override
        @Deprecated
        public boolean getRegionCachePrefetch(byte[] tableName) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void abort(String msg, Throwable t) {
            if (t instanceof KeeperException.SessionExpiredException && this.keepAliveZookeeper != null) {
                Object object = this.masterAndZKLock;
                synchronized (object) {
                    if (this.keepAliveZookeeper != null) {
                        LOG.warn((Object)"This client just lost it's session with ZooKeeper, closing it. It will be recreated next time someone needs it", t);
                        this.closeZooKeeperWatcher();
                    }
                }
            } else {
                if (t != null) {
                    LOG.fatal((Object)msg, t);
                } else {
                    LOG.fatal((Object)msg);
                }
                this.aborted = true;
                this.close();
                this.closed = true;
            }
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public boolean isAborted() {
            return this.aborted;
        }

        @Override
        public int getCurrentNrHRS() throws IOException {
            return this.registry.getCurrentNrHRS();
        }

        void incCount() {
            ++this.refCount;
        }

        void decCount() {
            if (this.refCount > 0) {
                --this.refCount;
            }
        }

        boolean isZeroReference() {
            return this.refCount == 0;
        }

        void internalClose() {
            if (this.closed) {
                return;
            }
            this.closeMaster();
            this.shutdownPools();
            if (this.metrics != null) {
                this.metrics.shutdown();
            }
            this.closed = true;
            this.closeZooKeeperWatcher();
            this.stubs.clear();
            if (this.clusterStatusListener != null) {
                this.clusterStatusListener.close();
            }
            if (this.rpcClient != null) {
                this.rpcClient.close();
            }
        }

        @Override
        public void close() {
            if (this.managed) {
                if (this.aborted) {
                    ConnectionManager.deleteStaleConnection(this);
                } else {
                    ConnectionManager.deleteConnection(this, false);
                }
            } else {
                this.internalClose();
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.refCount = 1;
            this.close();
        }

        @Override
        @Deprecated
        public HTableDescriptor[] listTables() throws IOException {
            try (MasterKeepAliveConnection master = this.getKeepAliveMasterService();){
                MasterProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest((List<TableName>)null);
                HTableDescriptor[] hTableDescriptorArray = ProtobufUtil.getHTableDescriptorArray(master.getTableDescriptors(null, req));
                return hTableDescriptorArray;
            }
        }

        @Override
        @Deprecated
        public String[] getTableNames() throws IOException {
            TableName[] tableNames = this.listTableNames();
            String[] result = new String[tableNames.length];
            for (int i = 0; i < tableNames.length; ++i) {
                result[i] = tableNames[i].getNameAsString();
            }
            return result;
        }

        @Override
        @Deprecated
        public TableName[] listTableNames() throws IOException {
            try (MasterKeepAliveConnection master = this.getKeepAliveMasterService();){
                TableName[] tableNameArray = ProtobufUtil.getTableNameArray(master.getTableNames(null, MasterProtos.GetTableNamesRequest.newBuilder().build()).getTableNamesList());
                return tableNameArray;
            }
        }

        @Override
        @Deprecated
        public HTableDescriptor[] getHTableDescriptorsByTableName(List<TableName> tableNames) throws IOException {
            if (tableNames == null || tableNames.isEmpty()) {
                return new HTableDescriptor[0];
            }
            try (MasterKeepAliveConnection master = this.getKeepAliveMasterService();){
                MasterProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(tableNames);
                HTableDescriptor[] hTableDescriptorArray = ProtobufUtil.getHTableDescriptorArray(master.getTableDescriptors(null, req));
                return hTableDescriptorArray;
            }
        }

        @Override
        @Deprecated
        public HTableDescriptor[] getHTableDescriptors(List<String> names) throws IOException {
            ArrayList<TableName> tableNames = new ArrayList<TableName>(names.size());
            for (String name : names) {
                tableNames.add(TableName.valueOf(name));
            }
            return this.getHTableDescriptorsByTableName(tableNames);
        }

        @Override
        public NonceGenerator getNonceGenerator() {
            return this.nonceGenerator;
        }

        @Override
        @Deprecated
        public HTableDescriptor getHTableDescriptor(TableName tableName) throws IOException {
            MasterProtos.GetTableDescriptorsResponse htds;
            if (tableName == null) {
                return null;
            }
            try (MasterKeepAliveConnection master = this.getKeepAliveMasterService();){
                MasterProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(tableName);
                htds = master.getTableDescriptors(null, req);
            }
            if (!htds.getTableSchemaList().isEmpty()) {
                return HTableDescriptor.convert(htds.getTableSchemaList().get(0));
            }
            throw new TableNotFoundException(tableName.getNameAsString());
        }

        @Override
        @Deprecated
        public HTableDescriptor getHTableDescriptor(byte[] tableName) throws IOException {
            return this.getHTableDescriptor(TableName.valueOf(tableName));
        }

        @Override
        public RpcRetryingCallerFactory getNewRpcRetryingCallerFactory(Configuration conf) {
            return RpcRetryingCallerFactory.instantiate(conf, this.interceptor, this.getStatisticsTracker());
        }

        @Override
        public boolean isManaged() {
            return this.managed;
        }

        @Override
        public boolean hasCellBlockSupport() {
            return this.rpcClient.hasCellBlockSupport();
        }

        @Override
        public ConnectionConfiguration getConnectionConfiguration() {
            return this.connectionConfig;
        }

        @Override
        public RpcRetryingCallerFactory getRpcRetryingCallerFactory() {
            return this.rpcCallerFactory;
        }

        @Override
        public RpcControllerFactory getRpcControllerFactory() {
            return this.rpcControllerFactory;
        }

        class MasterServiceStubMaker
        extends StubMaker {
            private MasterProtos.MasterService.BlockingInterface stub;

            MasterServiceStubMaker() {
            }

            @Override
            protected String getServiceName() {
                return MasterProtos.MasterService.getDescriptor().getName();
            }

            @Override
            MasterProtos.MasterService.BlockingInterface makeStub() throws IOException {
                return (MasterProtos.MasterService.BlockingInterface)super.makeStub();
            }

            @Override
            protected Object makeStub(BlockingRpcChannel channel) {
                this.stub = MasterProtos.MasterService.newBlockingStub(channel);
                return this.stub;
            }

            @Override
            protected void isMasterRunning() throws ServiceException {
                this.stub.isMasterRunning(null, RequestConverter.buildIsMasterRunningRequest());
            }
        }

        abstract class StubMaker {
            StubMaker() {
            }

            protected abstract String getServiceName();

            protected abstract Object makeStub(BlockingRpcChannel var1);

            protected abstract void isMasterRunning() throws ServiceException;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object makeStubNoRetries() throws IOException, KeeperException, ServiceException {
                ZooKeeperKeepAliveConnection zkw;
                try {
                    zkw = HConnectionImplementation.this.getKeepAliveZooKeeperWatcher();
                }
                catch (IOException e) {
                    ExceptionUtil.rethrowIfInterrupt(e);
                    throw new ZooKeeperConnectionException("Can't connect to ZooKeeper", e);
                }
                try {
                    HConnectionImplementation.this.checkIfBaseNodeAvailable(zkw);
                    ServerName sn = MasterAddressTracker.getMasterAddress(zkw);
                    if (sn == null) {
                        String msg = "ZooKeeper available but no active master location found";
                        LOG.info((Object)msg);
                        throw new MasterNotRunningException(msg);
                    }
                    if (HConnectionImplementation.this.isDeadServer(sn)) {
                        throw new MasterNotRunningException(sn + " is dead.");
                    }
                    String key = HConnectionImplementation.getStubKey(this.getServiceName(), sn.getHostname(), sn.getPort(), HConnectionImplementation.this.hostnamesCanChange);
                    HConnectionImplementation.this.connectionLock.putIfAbsent(key, key);
                    Object stub = null;
                    String string = (String)HConnectionImplementation.this.connectionLock.get(key);
                    synchronized (string) {
                        stub = HConnectionImplementation.this.stubs.get(key);
                        if (stub == null) {
                            BlockingRpcChannel channel = HConnectionImplementation.this.rpcClient.createBlockingRpcChannel(sn, HConnectionImplementation.this.user, HConnectionImplementation.this.rpcTimeout);
                            stub = this.makeStub(channel);
                            this.isMasterRunning();
                            HConnectionImplementation.this.stubs.put(key, stub);
                        }
                    }
                    string = stub;
                    return string;
                }
                finally {
                    zkw.close();
                }
            }

            Object makeStub() throws IOException {
                Object object = HConnectionImplementation.this.masterAndZKLock;
                synchronized (object) {
                    Throwable exceptionCaught = null;
                    if (!HConnectionImplementation.this.closed) {
                        try {
                            return this.makeStubNoRetries();
                        }
                        catch (IOException e) {
                            exceptionCaught = e;
                        }
                        catch (KeeperException e) {
                            exceptionCaught = e;
                        }
                        catch (ServiceException e) {
                            exceptionCaught = e;
                        }
                        throw new MasterNotRunningException((Exception)exceptionCaught);
                    }
                    throw new DoNotRetryIOException("Connection was closed while trying to get master");
                }
            }
        }

        static class MasterServiceState {
            HConnection connection;
            MasterProtos.MasterService.BlockingInterface stub;
            int userCount;

            MasterServiceState(HConnection connection) {
                this.connection = connection;
            }

            public String toString() {
                return "MasterService";
            }

            Object getStub() {
                return this.stub;
            }

            void clearStub() {
                this.stub = null;
            }

            boolean isMasterRunning() throws ServiceException {
                MasterProtos.IsMasterRunningResponse response = this.stub.isMasterRunning(null, RequestConverter.buildIsMasterRunningRequest());
                return response != null ? response.getIsMasterRunning() : false;
            }
        }
    }

    static class NoNonceGenerator
    implements NonceGenerator {
        NoNonceGenerator() {
        }

        @Override
        public long getNonceGroup() {
            return 0L;
        }

        @Override
        public long newNonce() {
            return 0L;
        }
    }
}

