/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.UUID;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValue;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.org.apache.hadoop.hbase.client.Durability;
import org.apache.hudi.org.apache.hadoop.hbase.client.Mutation;
import org.apache.hudi.org.apache.hadoop.hbase.client.Row;
import org.apache.hudi.org.apache.hadoop.hbase.client.WrongRowIOException;
import org.apache.hudi.org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Delete
extends Mutation
implements Comparable<Row> {
    public Delete(byte[] row) {
        this(row, Long.MAX_VALUE);
    }

    public Delete(byte[] row, long timestamp) {
        this(row, 0, row.length, timestamp);
    }

    public Delete(byte[] rowArray, int rowOffset, int rowLength) {
        this(rowArray, rowOffset, rowLength, Long.MAX_VALUE);
    }

    public Delete(byte[] rowArray, int rowOffset, int rowLength, long ts) {
        Delete.checkRow(rowArray, rowOffset, rowLength);
        this.row = Bytes.copy(rowArray, rowOffset, rowLength);
        this.setTimestamp(ts);
    }

    public Delete(Delete d) {
        this.row = d.getRow();
        this.ts = d.getTimeStamp();
        this.familyMap.putAll(d.getFamilyCellMap());
        this.durability = d.durability;
        for (Map.Entry<String, byte[]> entry : d.getAttributesMap().entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public Delete addDeleteMarker(Cell kv) throws IOException {
        if (!CellUtil.isDelete(kv)) {
            throw new IOException("The recently added KeyValue is not of type delete. Rowkey: " + Bytes.toStringBinary(this.row));
        }
        if (Bytes.compareTo(this.row, 0, this.row.length, kv.getRowArray(), kv.getRowOffset(), kv.getRowLength()) != 0) {
            throw new WrongRowIOException("The row in " + kv.toString() + " doesn't match the original one " + Bytes.toStringBinary(this.row));
        }
        byte[] family = CellUtil.cloneFamily(kv);
        ArrayList<Cell> list = (ArrayList<Cell>)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<Cell>();
        }
        list.add(kv);
        this.familyMap.put(family, list);
        return this;
    }

    @Deprecated
    public Delete deleteFamily(byte[] family) {
        return this.addFamily(family);
    }

    public Delete addFamily(byte[] family) {
        this.deleteFamily(family, this.ts);
        return this;
    }

    @Deprecated
    public Delete deleteFamily(byte[] family, long timestamp) {
        return this.addFamily(family, timestamp);
    }

    public Delete addFamily(byte[] family, long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + timestamp);
        }
        ArrayList<KeyValue> list = (ArrayList<KeyValue>)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<KeyValue>();
        } else if (!list.isEmpty()) {
            list.clear();
        }
        KeyValue kv = new KeyValue(this.row, family, null, timestamp, KeyValue.Type.DeleteFamily);
        list.add(kv);
        this.familyMap.put(family, list);
        return this;
    }

    @Deprecated
    public Delete deleteFamilyVersion(byte[] family, long timestamp) {
        return this.addFamilyVersion(family, timestamp);
    }

    public Delete addFamilyVersion(byte[] family, long timestamp) {
        ArrayList<KeyValue> list = (ArrayList<KeyValue>)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<KeyValue>();
        }
        list.add(new KeyValue(this.row, family, null, timestamp, KeyValue.Type.DeleteFamilyVersion));
        this.familyMap.put(family, list);
        return this;
    }

    @Deprecated
    public Delete deleteColumns(byte[] family, byte[] qualifier) {
        return this.addColumns(family, qualifier);
    }

    public Delete addColumns(byte[] family, byte[] qualifier) {
        this.addColumns(family, qualifier, this.ts);
        return this;
    }

    @Deprecated
    public Delete deleteColumns(byte[] family, byte[] qualifier, long timestamp) {
        return this.addColumns(family, qualifier, timestamp);
    }

    public Delete addColumns(byte[] family, byte[] qualifier, long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + timestamp);
        }
        ArrayList<KeyValue> list = (ArrayList<KeyValue>)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<KeyValue>();
        }
        list.add(new KeyValue(this.row, family, qualifier, timestamp, KeyValue.Type.DeleteColumn));
        this.familyMap.put(family, list);
        return this;
    }

    @Deprecated
    public Delete deleteColumn(byte[] family, byte[] qualifier) {
        return this.addColumn(family, qualifier);
    }

    public Delete addColumn(byte[] family, byte[] qualifier) {
        this.deleteColumn(family, qualifier, this.ts);
        return this;
    }

    @Deprecated
    public Delete deleteColumn(byte[] family, byte[] qualifier, long timestamp) {
        return this.addColumn(family, qualifier, timestamp);
    }

    public Delete addColumn(byte[] family, byte[] qualifier, long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + timestamp);
        }
        ArrayList<KeyValue> list = (ArrayList<KeyValue>)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<KeyValue>();
        }
        KeyValue kv = new KeyValue(this.row, family, qualifier, timestamp, KeyValue.Type.Delete);
        list.add(kv);
        this.familyMap.put(family, list);
        return this;
    }

    public Delete setTimestamp(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + timestamp);
        }
        this.ts = timestamp;
        return this;
    }

    @Override
    public Map<String, Object> toMap(int maxCols) {
        Map<String, Object> map = super.toMap(maxCols);
        map.put("ts", this.ts);
        return map;
    }

    @Override
    public Delete setAttribute(String name, byte[] value) {
        return (Delete)super.setAttribute(name, value);
    }

    @Override
    public Delete setId(String id) {
        return (Delete)super.setId(id);
    }

    @Override
    @Deprecated
    public Delete setWriteToWAL(boolean write) {
        return (Delete)super.setWriteToWAL(write);
    }

    @Override
    public Delete setDurability(Durability d) {
        return (Delete)super.setDurability(d);
    }

    @Override
    public Delete setFamilyCellMap(NavigableMap<byte[], List<Cell>> map) {
        return (Delete)super.setFamilyCellMap(map);
    }

    @Override
    @Deprecated
    public Delete setFamilyMap(NavigableMap<byte[], List<KeyValue>> map) {
        return (Delete)super.setFamilyMap(map);
    }

    @Override
    public Delete setClusterIds(List<UUID> clusterIds) {
        return (Delete)super.setClusterIds(clusterIds);
    }

    @Override
    public Delete setCellVisibility(CellVisibility expression) {
        return (Delete)super.setCellVisibility(expression);
    }

    @Override
    public Delete setACL(String user, Permission perms) {
        return (Delete)super.setACL(user, perms);
    }

    @Override
    public Delete setACL(Map<String, Permission> perms) {
        return (Delete)super.setACL(perms);
    }

    @Override
    public Delete setTTL(long ttl) {
        throw new UnsupportedOperationException("Setting TTLs on Deletes is not supported");
    }
}

